package com.biz.crm.excel.component.saver.mdm.material;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.material.MdmMaterialImportVo;
import com.biz.crm.mdm.material.entity.MdmMaterialEntity;
import com.biz.crm.mdm.material.mapper.MdmMaterialMapper;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;


/**
 * 物料导入
 * @Author hej
 * @Created Date 2020-12-31 15:13
 **/
@Slf4j
@Component("mdmMaterialImportSaver")
@Transactional("mdmTransactionManager")
public class MdmMaterialImportSaver <M extends BaseMapper<T>, T> extends ServiceImpl<MdmMaterialMapper, MdmMaterialEntity> implements ExcelImportSaver<MdmMaterialImportVo> {
    @Override
    public void save(List<MdmMaterialImportVo> data, DefaultImportContext context) {
        log.info("物料导入:{}",data);
        if(!CollectionUtils.isEmpty(data)){
            data.forEach(item->{
                if (StringUtils.isEmpty(item.getMaterialCode())) {
                    item.setMaterialCode(CodeUtil.generateCode(CodeRuleEnum.MDM_MATERIAL_CODE.getCode()));
                }
            });
            List<List<MdmMaterialImportVo>> materials = Lists.partition(data, 50);
            for (List<MdmMaterialImportVo> material : materials) {
                List<MdmMaterialEntity> entityList = CrmBeanUtil.copyList(material, MdmMaterialEntity.class);
                this.saveBatch(entityList);
            }
        }
    }

}
