package com.biz.crm.excel.component.saver.mdm.materialGroup;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.material.MdmMaterialImportVo;
import com.biz.crm.excel.vo.mdm.materialGroup.MdmMaterialGroupImportVo;
import com.biz.crm.mdm.material.entity.MdmMaterialEntity;
import com.biz.crm.mdm.material.mapper.MdmMaterialMapper;
import com.biz.crm.mdm.materialGroup.entity.MdmMaterialGroupEntity;
import com.biz.crm.mdm.materialGroup.entity.MdmMaterialGroupRelEntity;
import com.biz.crm.mdm.materialGroup.mapper.MdmMaterialGroupMapper;
import com.biz.crm.mdm.materialGroup.mapper.MdmMaterialGroupRelMapper;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * @ClassName: MdmMaterialGroupImportSaver
 * @Author: yangfan
 * @Description: 物料组导入
 * @Date: 2021/8/25 16:57
 * @Version: 1.0
 */
@Slf4j
@Component("mdmMaterialGroupImportSaver")
@Transactional("mdmTransactionManager")
public class MdmMaterialGroupImportSaver<M extends BaseMapper<T>, T> extends ServiceImpl<MdmMaterialGroupMapper, MdmMaterialGroupEntity> implements ExcelImportSaver<MdmMaterialGroupImportVo> {

  @Resource
  private MdmMaterialGroupRelMapper mdmMaterialGroupRelMapper;

  @Override
  public void save(List<MdmMaterialGroupImportVo> data, DefaultImportContext context) {
    log.info("物料组导入:{}",data);
    if(!CollectionUtils.isEmpty(data)){
      List<List<MdmMaterialGroupImportVo>> materials = Lists.partition(data, 50);
      for (List<MdmMaterialGroupImportVo> material : materials) {

        // 插入物料组与物料对应关系
        material.forEach(item->{
          String materialCode = item.getMaterialCode();
          List<String> materialCodeList = Arrays.asList(materialCode.split(","));
          MdmMaterialGroupEntity groupEntity = CrmBeanUtil.copy(item, MdmMaterialGroupEntity.class);
          groupEntity.setMaterialNum(materialCodeList==null?0:materialCodeList.size());
          this.save(groupEntity);
          materialCodeList.forEach(itemMaterial->{
            MdmMaterialGroupRelEntity relEntity = new MdmMaterialGroupRelEntity();
            relEntity.setMaterialCode(itemMaterial);
            relEntity.setMaterialGroupCode(item.getMaterialGroupCode());
            mdmMaterialGroupRelMapper.insert(relEntity);
          });
        });
      }
    }
  }
}
