package com.biz.crm.excel.component.saver.mdm.org;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.org.MdmOrgImportVo;
import com.biz.crm.mdm.org.entity.MdmOrgEntity;
import com.biz.crm.mdm.org.mapper.MdmOrgMapper;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgTreeRespVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 组织导入
 *
 * @author zxw
 * @date 2020-12-29 11:36
 **/
@Slf4j
@Component("mdmOrgImportSaver")
@Transactional("mdmTransactionManager")
public class MdmOrgImportSaver<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<MdmOrgMapper, MdmOrgEntity, MdmOrgImportVo> implements ExcelImportSaver<MdmOrgImportVo> {

    @Resource
    private MdmOrgMapper mdmOrgMapper;

    @Override
    public void save(List<MdmOrgImportVo> data, DefaultImportContext context) {
        log.info("组织导入:{}", data);
        if (!CollectionUtils.isEmpty(data)) {
            List<MdmOrgEntity> entityList = new ArrayList<>();
            for (MdmOrgImportVo item :
                    data) {
                if (MdmOrgImportVo.ProcessTypeEnum.SUCCESS == item.getProcessType()) {
                    MdmOrgEntity copy = CrmBeanUtil.copy(item, MdmOrgEntity.class);
                    if (StringUtils.isEmpty(copy.getOrgCode())) {
                        copy.setOrgCode(CodeUtil.generateCode(CodeRuleEnum.MDM_ORG_CODE.getCode()));
                    }
                    copy.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                    copy.setRuleCode(UUID.randomUUID().toString().replace("-", ""));
                    copy.setLevelNum(1);
                    entityList.add(copy);
                }
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(entityList)) {
                List<List<MdmOrgEntity>> partition = Lists.partition(entityList, 50);
                for (List<MdmOrgEntity> item :
                        partition) {
                    this.saveBatch(item);
                }
                resetRuleCode();
            }
        }
    }

    /**
     * 全表重置降维编码，方法需要优化
     */
    private void resetRuleCode() {
        long l = System.currentTimeMillis();
        log.info("-----------重置企业组织降维编码（导入）_" + l + "_开始-----------");
        mdmOrgMapper.copyIdToRuleCode();
        log.info("-----------重置企业组织降维编码（导入）_" + l + "_编码重置成id成功-----------");
        mdmOrgMapper.setNullNotExistParentCode();
        log.info("-----------重置企业组织降维编码（导入）_" + l + "_清除无效上级编码成功-----------");
        List<MdmOrgTreeRespVo> orgTree = getOrgTreeForResetRuleCode();
        log.info("-----------重置企业组织降维编码（导入）_" + l + "_树形结构构建成功-----------");
        updateCurAndChildren2(orgTree, "", 1);
        log.info("-----------重置企业组织降维编码（导入）_" + l + "_编码更新成功-----------");
        OrgUtil.deleteAllCache();
        log.info("-----------重置企业组织降维编码（导入）_" + l + "_缓存清除成功-----------");
        log.info("-----------重置企业组织降维编码（导入）_" + l + "_结束-----------");
    }

   private void updateCurAndChildren2(List<MdmOrgTreeRespVo> list, String parentRuleCode, int curLevelNum) {
        //查询下一层
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            //遍历下级
            for (int i = 0; i < list.size(); i++) {
                MdmOrgTreeRespVo item = list.get(i);
                item.setRuleCode(parentRuleCode + TreeRuleCodeUtil.numToSingleCode(i + 1));
                item.setLevelNum(curLevelNum);
                this.lambdaUpdate()
                        .eq(MdmOrgEntity::getOrgCode, item.getOrgCode())
                        .set(MdmOrgEntity::getRuleCode, item.getRuleCode())
                        .set(MdmOrgEntity::getLevelNum, item.getLevelNum())
                        .update();
                if (CollectionUtil.listNotEmptyNotSizeZero(item.getChildren())) {
                    //递归调用
                    updateCurAndChildren2(item.getChildren(), item.getRuleCode(), (item.getLevelNum() + 1));
                }
            }
        }
    }

    /**
     * 构建树形结构用来重置降维编码
     *
     * @return
     */
    private List<MdmOrgTreeRespVo> getOrgTreeForResetRuleCode() {
        List<MdmOrgEntity> list = this.lambdaQuery()
                .select(MdmOrgEntity::getId, MdmOrgEntity::getOrgCode, MdmOrgEntity::getParentCode)
                .list();
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List<MdmOrgTreeRespVo> totalList = CrmBeanUtil.copyList(list, MdmOrgTreeRespVo.class);

            //构建树list
            List<MdmOrgTreeRespVo> treeList = new ArrayList<>();
            //当前操作层级数据
            List<MdmOrgTreeRespVo> curLevelList = new ArrayList<>();
            //未操作数据
            List<MdmOrgTreeRespVo> restList = new ArrayList<>();

            final Set<String> totalCodeSet = totalList.stream().map(MdmOrgTreeRespVo::getOrgCode).collect(Collectors.toSet());

            //查找第一层
            for (MdmOrgTreeRespVo item :
                    totalList) {
                if (StringUtils.isEmpty(item.getParentCode()) || !totalCodeSet.contains(item.getParentCode())) {
                    treeList.add(item);
                    curLevelList.add(item);
                } else {
                    restList.add(item);
                }
            }

            //构建数据，从第二层开始
            while (curLevelList.size() > 0 && restList.size() > 0) {
                List<MdmOrgTreeRespVo> restTempList = new ArrayList<>();
                List<MdmOrgTreeRespVo> curLevelTempList = new ArrayList<>();
                final Set<String> curLevelCodeSet = curLevelList.stream().map(MdmOrgTreeRespVo::getOrgCode).collect(Collectors.toSet());
                Map<String, List<MdmOrgTreeRespVo>> curLevelChildrenMap = new HashMap<>();

                for (MdmOrgTreeRespVo item :
                        restList) {
                    if (curLevelCodeSet.contains(item.getParentCode())) {
                        curLevelTempList.add(item);

                        List<MdmOrgTreeRespVo> childrenList = new ArrayList<>();
                        if (curLevelChildrenMap.containsKey(item.getParentCode())) {
                            childrenList.addAll(curLevelChildrenMap.get(item.getParentCode()));
                        }
                        childrenList.add(item);
                        curLevelChildrenMap.put(item.getParentCode(), childrenList);
                    } else {
                        restTempList.add(item);
                    }
                }
                for (MdmOrgTreeRespVo item :
                        curLevelList) {
                    if (curLevelChildrenMap.containsKey(item.getOrgCode())) {
                        item.setChildren(curLevelChildrenMap.get(item.getOrgCode()));
                    }
                }
                curLevelList.clear();
                curLevelList.addAll(curLevelTempList);
                restList.clear();
                restList.addAll(restTempList);
            }
            return treeList;
        }
        return new ArrayList<>();
    }
}
