package com.biz.crm.excel.component.saver.mdm.positionlevel;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.positionlevel.MdmPositionLevelImportVo;
import com.biz.crm.mdm.positionlevel.entity.MdmPositionLevelEntity;
import com.biz.crm.mdm.positionlevel.entity.MdmPositionLevelRoleEntity;
import com.biz.crm.mdm.positionlevel.mapper.MdmPositionLevelMapper;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @Description:职位级别导入进数据库
 * @project：crm-core
 * @package：com.biz.crm.excel.component.saver.mdm.positionlevel
 * @author：dell
 * @create：2020/12/30 18:12
 */
@Slf4j
@Component("mdmPositionLevelImportSaver")
@Transactional("mdmTransactionManager")
public class MdmPositionLevelImportSaver <M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<MdmPositionLevelMapper, MdmPositionLevelEntity, MdmPositionLevelImportVo> implements ExcelImportSaver<MdmPositionLevelImportVo> {

    @Resource(name = "mdmPositionLevelRoleImportSaver")
    private MdmPositionLevelRoleImportSaver mdmPositionLevelRoleImportSaver;
    /**
     * 保存数据逻辑
     * 在一个事务内完成，要么都成功，要么都失败
     *
     * @param data
     */

    @Override
    public void save(List<MdmPositionLevelImportVo> data, DefaultImportContext context) {
        log.info("数据保存:{}",data);

        List<MdmPositionLevelRoleEntity> roleEntityList = new ArrayList<>();
        List<MdmPositionLevelImportVo> list = new ArrayList<>();

            for (int i = 0;i<data.size();i++){
                MdmPositionLevelImportVo item = data.get(i);
                if (item.getProcessType() == AbstractImportVo.ProcessTypeEnum.SUCCESS){
                    if (StringUtils.isEmpty(item.getPositionLevelCode())) {
                        item.setPositionLevelCode(CodeUtil.generateCode(CodeRuleEnum.MDM_POSITION_LEVEL_CODE.getCode()));
                    }
                    List<String> roleCode = Arrays.asList(item.getRoleCode().split(","));
                    for (int x = 0;x<roleCode.size();x++){
                        MdmPositionLevelRoleEntity roleEntity = new MdmPositionLevelRoleEntity();
                        roleEntity.setPositionLevelCode(item.getPositionLevelCode());
                        roleEntity.setRoleCode(roleCode.get(x));
                        roleEntityList.add(roleEntity);
                    }
                    list.add(item);
                }
            }

        this.saveBatch(CrmBeanUtil.copyList(list,MdmPositionLevelEntity.class));
        mdmPositionLevelRoleImportSaver.save(roleEntityList);
    }
}
