package com.biz.crm.excel.component.saver.mdm.price;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.price.MdmPriceSettingImportVo;
import com.biz.crm.mdm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.mdm.customer.model.MdmCustomerEntity;
import com.biz.crm.mdm.org.entity.MdmOrgEntity;
import com.biz.crm.mdm.org.mapper.MdmOrgMapper;
import com.biz.crm.mdm.price.mapper.MdmPriceSettingMapper;
import com.biz.crm.mdm.price.model.MdmPriceSettingEntity;
import com.biz.crm.mdm.product.entity.MdmProductEntity;
import com.biz.crm.mdm.product.mapper.MdmProductMapper;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSettingReqVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author zxw
 * @date 2021-02-10 09:05
 **/
@Slf4j
@Component("mdmPriceImportSavor")
@Transactional("mdmTransactionManager")
public class MdmPriceImportSavor<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<MdmPriceSettingMapper, MdmPriceSettingEntity, MdmPriceSettingImportVo> implements ExcelImportSaver<MdmPriceSettingImportVo> {

    @Resource
    private MdmPriceSettingServiceHelper mdmPriceSettingServiceHelper;

    @Resource
    private MdmProductMapper mdmProductMapper;

    @Resource
    private MdmOrgMapper mdmOrgMapper;

    @Resource
    private MdmCustomerMsgMapper mdmCustomerMsgMapper;

    @Override
    public void save(List<MdmPriceSettingImportVo> data, DefaultImportContext context) {
        if (!CollectionUtils.isEmpty(data)) {
            Map<String, String> channelMap = DictUtil.dictRevertMap("channel");
            Map<String, String> currencyTypeMap = DictUtil.dictRevertMap("currency_type");
            Map<String, String> baseUnitMap = DictUtil.dictRevertMap("product_base_unit");
            Map<String, String> unitTypeMap = DictUtil.dictRevertMap("unit_type");
            Map<String, String> saleUnitMap = DictUtil.dictRevertMap("product_sale_unit");
            LambdaQueryWrapper<MdmProductEntity> productWrapper = Wrappers.<MdmProductEntity>lambdaQuery()
                    .select(MdmProductEntity::getProductCode, MdmProductEntity::getProductName);
            Map<String, String> productMap = mdmProductMapper.selectList(productWrapper).stream()
                    .filter(x -> x != null && !StringUtils.isEmpty(x.getProductCode()))
                    .collect(Collectors.toMap(MdmProductEntity::getProductCode, MdmProductEntity::getProductName));
            LambdaQueryWrapper<MdmCustomerEntity> customerWrapper = Wrappers.<MdmCustomerEntity>lambdaQuery()
                    .select(MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getCustomerName);
            Map<String, String> customerMap = mdmCustomerMsgMapper.selectList(customerWrapper).stream()
                    .filter(x -> x != null && !StringUtils.isEmpty(x.getCustomerCode()))
                    .collect(Collectors.toMap(MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getCustomerName));
            LambdaQueryWrapper<MdmOrgEntity> orgWrapper = Wrappers.<MdmOrgEntity>lambdaQuery()
                    .select(MdmOrgEntity::getOrgCode, MdmOrgEntity::getOrgName);
            Map<String, String> orgMap = mdmOrgMapper.selectList(orgWrapper).stream()
                    .filter(x -> x != null && !StringUtils.isEmpty(x.getOrgCode()))
                    .collect(Collectors.toMap(MdmOrgEntity::getOrgCode, MdmOrgEntity::getOrgName));

            for (MdmPriceSettingImportVo datum : data) {

                datum.setCurrencyType(currencyTypeMap.get(datum.getCurrencyType()));
                MdmPriceSettingReqVo reqVo = CrmBeanUtil.copy(datum, MdmPriceSettingReqVo.class);
                reqVo.setChannelName(datum.getChannel());
                reqVo.setChannel(channelMap.get(datum.getChannel()));

                reqVo.setCurrencyType(datum.getCurrencyType());

                String unitType = unitTypeMap.get(reqVo.getUnitType());
                reqVo.setUnitType(unitType);
                reqVo.setPriceName(datum.getPriceUnit());
                if ("baseUnit".equals(unitType)) {
                    reqVo.setPriceUnit(baseUnitMap.get(datum.getPriceUnit()));
                }else{
                    reqVo.setPriceUnit(saleUnitMap.get(datum.getPriceUnit()));
                }
                reqVo.setProductName(productMap.get(datum.getProductCode()));
                reqVo.setOrgName(orgMap.get(datum.getOrgCode()));
                reqVo.setCustomerName(productMap.get(datum.getCustomerCode()));
                reqVo.setBeginDateSecond("00:00:00");
                reqVo.setEndDateSecond("00:00:00");
                reqVo.setPrice(new BigDecimal(datum.getPrice()));
                List<MdmPriceSettingEntity> mdmPriceSettingEntities = mdmPriceSettingServiceHelper.dataUniqueSaveOrUpdate(reqVo);
                if(!CollectionUtils.isEmpty(mdmPriceSettingEntities)){
                    this.saveOrUpdateBatch((mdmPriceSettingEntities));
                }
            }
        }
    }
}
