package com.biz.crm.excel.component.saver.mdm.product;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.product.MdmProductImportVo;
import com.biz.crm.mdm.kms.MdmKmsFeign;
import com.biz.crm.mdm.product.entity.MdmProductEntity;
import com.biz.crm.mdm.product.entity.MdmProductMaterialEntity;
import com.biz.crm.mdm.product.mapper.MdmProductMapper;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 商品导入
 *
 * @author hej
 * @date 2020-12-31 10:36
 **/
@Slf4j
@Component("mdmProductImportSaver")
public class MdmProductImportSaver<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<MdmProductMapper, MdmProductEntity, MdmProductImportVo> implements ExcelImportSaver<MdmProductImportVo> {

    @Resource
    private MdmKmsFeign mdmKmsFeign;

    @Override
    @Transactional(rollbackFor = Exception.class,transactionManager ="mdmTransactionManager")
    public void save(List<MdmProductImportVo> data, DefaultImportContext context) {
        log.info("商品导入:{}",data);
        if(!CollectionUtils.isEmpty(data)){
            data.forEach(item->{
                if (StringUtils.isEmpty(item.getProductCode())) {
                    item.setProductCode(CodeUtil.generateCode(CodeRuleEnum.MDM_PRODUCT_CODE.getCode()));
                }
            });

            List<List<MdmProductImportVo>> partition = Lists.partition(data, 50);
            for (List<MdmProductImportVo> mdmProductImportVos : partition) {
                //商品主表
                List<MdmProductEntity> entityList = CrmBeanUtil.copyList(mdmProductImportVos, MdmProductEntity.class);
                entityList.stream().forEach(m->{
                    if(StringUtils.isNotEmpty(m.getBeginDate())){
                        m.setBeginDateSecond("00:00:00");
                    }
                    if(StringUtils.isNotEmpty(m.getEndDate())) {
                        m.setEndDateSecond("23:59:59");
                    }
                });
                mdmKmsFeign.addProBatch(CrmBeanUtil.copyList(entityList, MdmProductReqVo.class));
                this.saveBatch(entityList);
                //富文本表
//                List<MdmProductIntroductionEntity> introductionEntities = new ArrayList<>();
//                mdmProductImportVos.stream()
//                        .filter(m -> StringUtils.isNotEmpty(m.getIntroduction()))
//                        .forEach(m->{
//                            MdmProductIntroductionEntity entity = new MdmProductIntroductionEntity();
//                            entity.setIntroductionText(m.getIntroduction());
//                            entity.setProductCode(m.getProductCode());
//                            introductionEntities.add(entity);
//                        });
//                MdmProductIntroductionImportSaver mdmProductIntroductionImportSaver = new MdmProductIntroductionImportSaver();
//                if(CollectionUtil.listNotEmptyNotSizeZero(introductionEntities)){
//                    mdmProductIntroductionImportSaver.saveBatch(introductionEntities);
//                }
                //物料表
                List<MdmProductMaterialEntity> materialEntities = new ArrayList<>();
                mdmProductImportVos.stream().filter(m->StringUtils.isNotEmpty(m.getMaterialCode())).forEach(m->{
                    MdmProductMaterialEntity copy = CrmBeanUtil.copy(m, MdmProductMaterialEntity.class);
                    if(!Objects.isNull(m.getCount())){
                        copy.setCount(Integer.valueOf(m.getCount()));
                    }
                    materialEntities.add(copy);
                });
                MdmProductMaterialImportSaver mdmProductMaterialImportSaver = new MdmProductMaterialImportSaver();
                if(CollectionUtil.listNotEmptyNotSizeZero(materialEntities)){
                    mdmProductMaterialImportSaver.saveBatch(materialEntities);
                }
            }
        }
    }
}
