package com.biz.crm.excel.component.saver.mdm.product;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.product.MdmProductLevelImportVo;
import com.biz.crm.mdm.kms.MdmKmsFeign;
import com.biz.crm.mdm.product.entity.MdmProductLevelEntity;
import com.biz.crm.mdm.product.mapper.MdmProductLevelMapper;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelReqVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.UUID;

/**
 * 产品层级
 *
 * @Author hej
 * @Created Date 2020-12-31 14:51
 **/
@Slf4j
@Component("mdmProductLevelImportSaver")
@Transactional("mdmTransactionManager")
public class MdmProductLevelImportSaver<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<MdmProductLevelMapper, MdmProductLevelEntity, MdmProductLevelImportVo> implements ExcelImportSaver<MdmProductLevelImportVo> {

    @Resource
    private MdmProductLevelMapper mdmProductLevelMapper;

    @Resource
    private MdmKmsFeign mdmKmsFeign;


    @Override
    public void save(List<MdmProductLevelImportVo> data, DefaultImportContext context) {
        log.info("产品层级导入:{}", data);
        if (!data.isEmpty()) {
            List<List<MdmProductLevelImportVo>> productLevel = Lists.partition(data,50);
            for (List<MdmProductLevelImportVo> mdmProductLevelImportVos : productLevel) {
                List<MdmProductLevelEntity> levelEntities = CrmBeanUtil.copyList(mdmProductLevelImportVos, MdmProductLevelEntity.class);
                levelEntities.forEach(m -> {
                            if (StringUtils.isEmpty(m.getProductLevelCode())) {
                                m.setProductLevelCode(CodeUtil.generateCode(CodeRuleEnum.MDM_PRODUCT_LEVEL_CODE.getCode()));
                            }
                            m.setRuleCode(UUID.randomUUID().toString().replace("-", ""));
                            m.setLevelNum(1);
                        });
                mdmKmsFeign.addCategoryBatch(CrmBeanUtil.copyList(levelEntities, MdmProductLevelReqVo.class));
                this.saveBatch(levelEntities);
            }
            resetRuleCode();
        }
    }

    /**
     * 全表重置降维编码，方法需要优化
     */
    private void resetRuleCode() {
        long l = System.currentTimeMillis();
        log.info("-----------重置产品层级降维编码（导入）_" + l + "_开始-----------");
        mdmProductLevelMapper.copyIdToRuleCode();
        log.info("-----------重置产品层级降维编码（导入）_" + l + "_编码重置成id成功-----------");
        mdmProductLevelMapper.setNullNotExistParentCode();
        log.info("-----------重置产品层级降维编码（导入）_" + l + "_清除无效上级编码成功-----------");
        List<MdmProductLevelEntity> topList = this.lambdaQuery()
                .isNull(MdmProductLevelEntity::getParentCode)
                .or()
                .eq(MdmProductLevelEntity::getParentCode, "")
                .list();

        for (int i = 0; i < topList.size(); i++) {
            updateCurAndChildren(topList.get(i).getProductLevelCode(), TreeRuleCodeUtil.numToSingleCode(i + 1), 1);
        }
        log.info("-----------重置产品层级降维编码（导入）_" + l + "_编码重新生成成功-----------");
        ProductLevelUtil.deleteAllCache();
        log.info("-----------重置产品层级降维编码（导入）_" + l + "_缓存清除成功-----------");
        log.info("-----------重置产品层级降维编码（导入）_" + l + "_结束-----------");
    }
    /**
     * 更新产品层级及产品层级下级降维编码和层级
     *
     * @param productLevelCode 当前产品层级编码
     * @param curCode      当前产品层级降维编码
     * @param levelNum     当前产品层级
     */
    private void updateCurAndChildren(String productLevelCode, String curCode, int levelNum) {

        //更新当前
        this.lambdaUpdate()
                .eq(MdmProductLevelEntity::getProductLevelCode, productLevelCode)
                .set(MdmProductLevelEntity::getRuleCode, curCode)
                .set(MdmProductLevelEntity::getLevelNum, levelNum)
                .update();

        //查询下一层
        List<MdmProductLevelEntity> list = this.lambdaQuery()
                .eq(MdmProductLevelEntity::getParentCode, productLevelCode)
                .eq(MdmProductLevelEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode())
                .select(MdmProductLevelEntity::getProductLevelCode)
                .list();

        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            //遍历下级
            for (int i = 0; i < list.size(); i++) {
                //递归调用
                updateCurAndChildren(list.get(i).getProductLevelCode(), curCode + TreeRuleCodeUtil.numToSingleCode(i + 1), (levelNum + 1));
            }
        }
    }

}
