package com.biz.crm.excel.component.saver.mdm.role;

import com.alibaba.excel.context.AnalysisContext;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.TestImportVo;
import com.biz.crm.excel.vo.mdm.role.MdmRoleImportVo;
import com.biz.crm.mdm.role.entity.MdmRoleEntity;
import com.biz.crm.mdm.role.mapper.MdmRoleMapper;
import com.biz.crm.sfa.test.entity.TestImportEntity;
import com.biz.crm.sfa.test.mapper.TestImportMapper;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 权限角色导入保存
 *
 * @author Tao.Chen
 * @date 2021-01-04 20:46:13
 */
@Slf4j
@Component("mdmRoleImportSaver")
@Transactional("mdmTransactionManager")
public class MdmRoleImportSaver<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<MdmRoleMapper, MdmRoleEntity, MdmRoleImportVo> implements ExcelImportSaver<MdmRoleImportVo> {

    @Override
    public void save(List<MdmRoleImportVo> data, DefaultImportContext context) {
        log.info("角色导入:{}", data);
        if (!CollectionUtils.isEmpty(data)) {
            List<MdmRoleEntity> entityList = new ArrayList<>();
            for (MdmRoleImportVo item :
                    data) {
                if (MdmRoleImportVo.ProcessTypeEnum.SUCCESS == item.getProcessType()) {
                    MdmRoleEntity copy = CrmBeanUtil.copy(item, MdmRoleEntity.class);
                    if (StringUtils.isEmpty(copy.getRoleCode())) {
                        copy.setRoleCode(CodeUtil.generateCode(CodeRuleEnum.MDM_ROLE_CODE.getCode()));
                    }
                    copy.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                    entityList.add(copy);
                }
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(entityList)) {
                List<List<MdmRoleEntity>> partition = Lists.partition(entityList, 50);
                for (List<MdmRoleEntity> item :
                        partition) {
                    this.saveBatch(item);
                }
            }
        }
    }
}
