package com.biz.crm.excel.component.saver.mdm.terminal;

import com.alibaba.excel.context.AnalysisContext;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.TestImportVo;
import com.biz.crm.excel.vo.mdm.terminal.MdmTerminalContactImportVo;
import com.biz.crm.mdm.terminal.entity.MdmTerminalContactEntity;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalContactMapper;
import com.biz.crm.sfa.test.entity.TestImportEntity;
import com.biz.crm.sfa.test.mapper.TestImportMapper;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 终端导入
 *
 * @author zxw
 * @date 2020-12-29 11:36
 **/
@Slf4j
@Component("mdmTerminalContactImportSaver")
@Transactional("mdmTransactionManager")
public class MdmTerminalContactImportSaver<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<MdmTerminalContactMapper, MdmTerminalContactEntity, MdmTerminalContactImportVo> implements ExcelImportSaver<MdmTerminalContactImportVo> {

    @Resource
    private MdmTerminalContactMapper mdmTerminalContactMapper;

    @Override
    public void save(List<MdmTerminalContactImportVo> data, DefaultImportContext context) {
        if(!CollectionUtils.isEmpty(data)){
            //查询数据库主联系人为1的terminalCode
            LambdaQueryWrapper<MdmTerminalContactEntity> wrapper = Wrappers.<MdmTerminalContactEntity>lambdaQuery()
                    .eq(MdmTerminalContactEntity::getContactMain, YesNoEnum.yesNoEnum.ONE.getValue())
                    .select(MdmTerminalContactEntity::getTerminalCode);
            Set<String> dbTerminalCodeMainSet = mdmTerminalContactMapper.selectList(wrapper)
                    .stream()
                    .filter(x -> x != null && !StringUtils.isEmpty(x.getTerminalCode()))
                    .map(MdmTerminalContactEntity::getTerminalCode)
                    .collect(Collectors.toSet());

            List<MdmTerminalContactImportVo> collect = data.stream()
                    .collect(Collectors.groupingBy(MdmTerminalContactImportVo::getTerminalCode, Collectors.collectingAndThen(Collectors.toList(), x -> {
                        String terminalCode = x.get(0).getTerminalCode();
                        if (CollectionUtils.isEmpty(dbTerminalCodeMainSet) || !dbTerminalCodeMainSet.contains(terminalCode)) {
                            //数据库没有数据或数据库不存在主联系人
                            long count = x.stream()
                                    .filter(k -> !StringUtils.isEmpty(k.getContactMain()) && YesNoEnum.yesNoEnum.ONE.getValue().equals(k.getContactMain()))
                                    .count();
                            if (count != 1) {
                                x = x.stream().peek(k -> k.setContactMain(YesNoEnum.yesNoEnum.ZERO.getValue())).collect(Collectors.toList());
                                x.get(0).setContactMain(YesNoEnum.yesNoEnum.ONE.getValue());
                            }
                        } else {
                            x = x.stream().peek(k -> k.setContactMain(YesNoEnum.yesNoEnum.ZERO.getValue())).collect(Collectors.toList());
                        }
                        return x;
                    })))
                    .values().stream()
                    .filter(x -> !CollectionUtils.isEmpty(x))
                    .flatMap(Collection::stream)
                    .collect(Collectors.toList());


            List<List<MdmTerminalContactImportVo>> partition = Lists.partition(collect, 50);
            for (List<MdmTerminalContactImportVo> mdmTerminalContactImportVos : partition) {
                this.saveBatch(CrmBeanUtil.copyList(mdmTerminalContactImportVos, MdmTerminalContactEntity.class));
            }
        }
    }
}
