package com.biz.crm.excel.component.saver.mdm.terminal;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.ApprovalType;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.terminal.MdmTerminalImportVo;
import com.biz.crm.mdm.kms.MdmKmsFeign;
import com.biz.crm.mdm.terminal.entity.MdmTerminalContactEntity;
import com.biz.crm.mdm.terminal.entity.MdmTerminalEntity;
import com.biz.crm.mdm.terminal.entity.MdmTerminalROrgEntity;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalContactMapper;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalROrgMapper;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.websocket.WebsocketUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 终端导入
 *
 * @author zxw
 * @date 2020-12-29 11:36
 **/
@Slf4j
@Component("mdmTerminalImportSaver")
@Transactional("mdmTransactionManager")
public class MdmTerminalImportSaver<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<MdmTerminalMapper, MdmTerminalEntity, MdmTerminalImportVo> implements ExcelImportSaver<MdmTerminalImportVo> {

    @Resource
    private MdmTerminalROrgMapper mdmTerminalROrgMapper;

    @Resource
    private MdmTerminalContactMapper mdmTerminalContactMapper;

    @Resource
    private MdmKmsFeign mdmKmsFeign;
    @Autowired
    private WebsocketUtil websocketUtil;
    @Value("${kms.url:}")
    private String kms;

    @Override
    public void save(List<MdmTerminalImportVo> data, DefaultImportContext context) {
        log.info("终端导入:{}"+data.size());
        String sid = context.getImportParamVo().getWebSocketClientId();
        websocketUtil.sendMsg(sid,"准备保存数据");
        Map<String, String> channel = DictUtil.dictMap("channel");
        Map<String,String> channelMap = new HashMap<>(16);
        for (Map.Entry<String,String> entry :
                channel.entrySet()){
            if (!channelMap.containsKey(entry.getValue())){
                channelMap.put(entry.getValue(),entry.getKey());
            }
        }
        Map<String,String> map = DictUtil.dictMap("terminal_type");
        Map<String,String> terminalTypeMap = new HashMap<>(16);
        for (Map.Entry<String,String> entry :
                map.entrySet()){
            if (!terminalTypeMap.containsKey(entry.getValue())){
                terminalTypeMap.put(entry.getValue(),entry.getKey());
            }
        }
        if (!CollectionUtils.isEmpty(data)) {
            data = data.stream().filter(x -> MdmTerminalImportVo.ProcessTypeEnum.SUCCESS == x.getProcessType()).collect(Collectors.toList());
            long count = data.stream().filter(x -> StringUtils.isEmpty(x.getTerminalCode())).count();
            if (count > 0) {
                List<String> codes = CodeUtil.generateCodeList(CodeRuleEnum.MDM_TERMINAL.getCode(), (int) count);
                int i = 0;
                for (MdmTerminalImportVo item :
                        data) {
                    if (StringUtils.isEmpty(item.getTerminalCode())) {
                        item.setTerminalCode(codes.get(i++));
                    }
                }
            }

            List<List<MdmTerminalImportVo>> partition = Lists.partition(data, 100);
            websocketUtil.sendMsg(sid,"开始保存终端与组织关系");
            for (List<MdmTerminalImportVo> mdmTerminalVos : partition) {
                List<MdmTerminalROrgEntity> mdmTerminalROrgEntities = mdmTerminalVos.stream()
                        .filter(x -> !StringUtils.isEmpty(x.getOrgCode()) && x.getProcessType() == AbstractImportVo.ProcessTypeEnum.SUCCESS)
                        .flatMap(x -> {
                            List<MdmTerminalROrgEntity> list = new ArrayList<>();
                            String terminalCode = x.getTerminalCode();
                            for (String orgCode : x.getOrgCode().split(",")) {
                                MdmTerminalROrgEntity mdmTerminalROrgEntity = new MdmTerminalROrgEntity();
                                mdmTerminalROrgEntity.setId(UUID.randomUUID().toString());
                                mdmTerminalROrgEntity.setOrgCode(orgCode);
                                mdmTerminalROrgEntity.setTerminalCode(terminalCode);
                                list.add(mdmTerminalROrgEntity);
                            }
                            return list.stream();
                        })
                        .collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(mdmTerminalROrgEntities)) {
                    mdmTerminalROrgMapper.insertBatch(mdmTerminalROrgEntities);
                }
            }
            List<MdmTerminalImportVo> list = new ArrayList<>();
            for (MdmTerminalImportVo mdmTerminalImportVo : data){
                if (mdmTerminalImportVo.getProcessType() == AbstractImportVo.ProcessTypeEnum.SUCCESS){
                    mdmTerminalImportVo.setChannel(channelMap.get(mdmTerminalImportVo.getChannel()));
                    mdmTerminalImportVo.setTerminalType(terminalTypeMap.get(mdmTerminalImportVo.getTerminalType()));
                    list.add(mdmTerminalImportVo);
                }
            }
            if (!CollectionUtils.isEmpty(list)){
                List<MdmTerminalEntity> entityList = CrmBeanUtil.copyList(list, MdmTerminalEntity.class);
                entityList.forEach(x -> {
                    x.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
                    x.setApprovalType(ApprovalType.NULL.getValue());
                    x.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                });
                if(StringUtils.isNotEmpty(kms)){
                    websocketUtil.sendMsg(sid,"开始保存KMS相关信息");
                    mdmKmsFeign.addStoreBatch(CrmBeanUtil.copyList(list, MdmTerminalVo.class));
                }
                websocketUtil.sendMsg(sid,"开始保存终端相关信息");
                this.saveBatch(entityList);
            }
            List<MdmTerminalContactEntity> mdmTerminalContactEntities = data.stream()
                    .filter(x -> (!StringUtils.isEmpty(x.getContactName()) || !StringUtils.isEmpty(x.getContactPhone())) && x.getProcessType() == AbstractImportVo.ProcessTypeEnum.SUCCESS)
                    .map(mdmTerminalImportVo -> {
                        MdmTerminalContactEntity mdmTerminalContactEntity = new MdmTerminalContactEntity();
                        mdmTerminalContactEntity.setId(UUID.randomUUID().toString());
                        mdmTerminalContactEntity.setTerminalCode(mdmTerminalImportVo.getTerminalCode());
                        mdmTerminalContactEntity.setContactName(mdmTerminalImportVo.getContactName());
                        mdmTerminalContactEntity.setContactPhone(mdmTerminalImportVo.getContactPhone());
                        mdmTerminalContactEntity.setContactMain(YesNoEnum.yesNoEnum.ONE.getValue());
                        return mdmTerminalContactEntity;
                    })
                    .collect(Collectors.toList());
            websocketUtil.sendMsg(sid,"开始保存联系人信息");
            if (!CollectionUtils.isEmpty(mdmTerminalContactEntities)) {
                int total = mdmTerminalContactEntities.size();
                for (int i = 0; i < total; i++) {
                    if (i % 100 == 0) {
                        websocketUtil.sendMsg(sid, "保存联系人信息：进度：" + i + "/" + total);
                    }
                    mdmTerminalContactMapper.insert(mdmTerminalContactEntities.get(i));
                }
            }
            websocketUtil.sendMsg(sid,"保存联系人信息完成");
        }
    }
}
