package com.biz.crm.excel.component.saver.mdm.terminal;

import com.alibaba.excel.context.AnalysisContext;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.TestImportVo;
import com.biz.crm.excel.vo.mdm.terminal.MdmTerminalSupplyDetailImportVo;
import com.biz.crm.mdm.terminal.entity.MdmTerminalSupplyDetailEntity;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalSupplyDetailMapper;
import com.biz.crm.sfa.test.entity.TestImportEntity;
import com.biz.crm.sfa.test.mapper.TestImportMapper;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 终端供货关系导入
 *
 * @author zxw
 * @date 2020-12-29 11:36
 **/
@Slf4j
@Component("mdmTerminalSupplyDetailImportSaver")
@Transactional("mdmTransactionManager")
public class MdmTerminalSupplyDetailImportSaver<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<MdmTerminalSupplyDetailMapper, MdmTerminalSupplyDetailEntity, MdmTerminalSupplyDetailImportVo> implements ExcelImportSaver<MdmTerminalSupplyDetailImportVo> {

    @Override
    public void save(List<MdmTerminalSupplyDetailImportVo> data, DefaultImportContext context) {
        if(!CollectionUtils.isEmpty(data)){
            List<List<MdmTerminalSupplyDetailImportVo>> partition = Lists.partition(data, 50);
            for (List<MdmTerminalSupplyDetailImportVo> mdmTerminalSupplyDetailImportVos : partition) {
                this.saveBatch(CrmBeanUtil.copyList(mdmTerminalSupplyDetailImportVos, MdmTerminalSupplyDetailEntity.class));
            }
        }
    }
}
