package com.biz.crm.excel.component.saver.mdm.user;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.user.MdmCustomerUserImportVo;
import com.biz.crm.excel.vo.mdm.user.MdmUserImportVo;
import com.biz.crm.mdm.user.entity.MdmUserEntity;
import com.biz.crm.mdm.user.entity.MdmUserRelCustomerEntity;
import com.biz.crm.mdm.user.entity.MdmUserRelRoleEntity;
import com.biz.crm.mdm.user.mapper.MdmUserMapper;
import com.biz.crm.mdm.user.mapper.MdmUserRelCustomerMapper;
import com.biz.crm.mdm.user.mapper.MdmUserRelRoleMapper;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@Component("mdmCustomerUserImportSaver")
@Transactional("mdmTransactionManager")
public class MdmCustomerUserImportSaver<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<MdmUserMapper, MdmUserEntity, MdmCustomerUserImportVo> implements ExcelImportSaver<MdmCustomerUserImportVo> {

    @Resource
    private MdmUserMapper mdmUserMapper;
    @Resource
    private MdmUserRelCustomerMapper mdmUserRelCustomerMapper;
    @Resource
    private MdmUserRelRoleMapper mdmUserRelRoleMapper;

    /**
     * 保存数据逻辑
     * 在一个事务内完成，要么都成功，要么都失败
     *
     * @param data
     */
    @Override
    public void save(List<MdmCustomerUserImportVo> data, DefaultImportContext context) {
        log.info("导入用户");
        if (data == null || data.size() == 0) {
            return;
        }

        List<MdmUserEntity> userEntityList = new ArrayList<>();
        List<MdmUserRelCustomerEntity> userRelCustomerEntityList = new ArrayList<>();
        List<MdmUserRelRoleEntity> userRelRoleEntityList = new ArrayList<>();
        for (MdmCustomerUserImportVo item :
                data) {
            if (MdmUserImportVo.ProcessTypeEnum.SUCCESS != item.getProcessType()) {
                continue;
            }
            MdmUserEntity copy = CrmBeanUtil.copy(item, MdmUserEntity.class);
            copy.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
            copy.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            copy.setUserPassword(Md5EncryptionAndDecryption.encryPwd(item.getUserPassword()));
            copy.setUserType(UserTypeEnum.CUSTOMER.getCode());
            copy.setUserCode(CodeUtil.generateCode(CodeRuleEnum.MDM_USER_CODE.getCode()));
            copy.setStartTime(item.getStartTime() + " 00:00:00");
            copy.setEndTime(item.getEndTime() + " 23:59:59");
            copy.setForceChangePassword(YesNoEnum.yesNoEnum.ONE.getValue());
            userEntityList.add(copy);

            if (StringUtils.isNotEmpty(item.getRoleCode())) {
                for (String roleCode :
                        item.getRoleCode().split(",")) {
                    MdmUserRelRoleEntity userRelRole = new MdmUserRelRoleEntity();
                    userRelRole.setUserName(item.getUserName());
                    userRelRole.setRoleCode(roleCode);
                    userRelRoleEntityList.add(userRelRole);
                }
            }

            if (StringUtils.isNotEmpty(item.getCustomerCode())) {
                for (String customerCode :
                        item.getCustomerCode().split(",")) {
                    MdmUserRelCustomerEntity userRelCustomer = new MdmUserRelCustomerEntity();
                    userRelCustomer.setUserName(item.getUserName());
                    userRelCustomer.setCustomerCode(customerCode);
                    userRelCustomer.setCurrentFlag(YesNoEnum.yesNoEnum.ZERO.getValue());
                    userRelCustomerEntityList.add(userRelCustomer);
                }
            }
        }

        if (CollectionUtil.listNotEmptyNotSizeZero(userEntityList)) {
            List<List<MdmUserEntity>> userGroup = Lists.partition(userEntityList, 50);
            for (List<MdmUserEntity> item :
                    userGroup) {
                this.saveBatch(item);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(userRelCustomerEntityList)) {
                userRelCustomerEntityList.forEach(x -> {
                    mdmUserRelCustomerMapper.insert(x);
                });
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(userRelRoleEntityList)) {
                userRelRoleEntityList.forEach(x -> {
                    mdmUserRelRoleMapper.insert(x);
                });
            }
        }
    }
}
