package com.biz.crm.excel.component.saver.mdm.user;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.user.MdmUserImportVo;
import com.biz.crm.mdm.position.entity.MdmPositionBpmRoleEntity;
import com.biz.crm.mdm.position.entity.MdmPositionEntity;
import com.biz.crm.mdm.position.entity.MdmPositionRoleEntity;
import com.biz.crm.mdm.position.entity.MdmPositionUserEntity;
import com.biz.crm.mdm.position.mapper.MdmPositionBpmRoleMapper;
import com.biz.crm.mdm.position.mapper.MdmPositionMapper;
import com.biz.crm.mdm.position.mapper.MdmPositionRoleMapper;
import com.biz.crm.mdm.position.mapper.MdmPositionUserMapper;
import com.biz.crm.mdm.positionlevel.entity.MdmPositionLevelEntity;
import com.biz.crm.mdm.positionlevel.mapper.MdmPositionLevelMapper;
import com.biz.crm.mdm.user.entity.MdmUserEntity;
import com.biz.crm.mdm.user.mapper.MdmUserMapper;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.mdm.constant.PositionOperationEnum;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionBpmRoleRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.util.*;
import com.biz.crm.util.websocket.WebsocketUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Component("mdmUserImportSaver")
@Transactional("mdmTransactionManager")
public class MdmUserImportSaver<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<MdmUserMapper, MdmUserEntity, MdmUserImportVo> implements ExcelImportSaver<MdmUserImportVo> {

    @Resource
    private MdmUserMapper mdmUserMapper;
    @Resource
    private MdmPositionUserMapper mdmPositionUserMapper;
    @Resource
    private MdmPositionMapper mdmPositionMapper;
    @Resource
    private MdmPositionRoleMapper mdmPositionRoleMapper;
    @Resource
    private MdmPositionBpmRoleMapper mdmPositionBpmRoleMapper;
    @Resource
    private MdmPositionLevelMapper mdmPositionLevelMapper;
    @Autowired
    private WebsocketUtil websocketUtil;
    @Resource
    private RocketMQProducer rocketMQProducer;

    /**
     * 保存数据逻辑
     * 在一个事务内完成，要么都成功，要么都失败
     *
     * @param data
     */
    @Override
    public void save(List<MdmUserImportVo> data, DefaultImportContext context) {
        log.info("导入用户");
        if (data == null || data.size() == 0) {
            return;
        }
        String sid = context.getImportParamVo().getWebSocketClientId();
        websocketUtil.sendMsg(sid, "开始准备保存数据");
        List<MdmUserImportVo> collect = data.stream().filter(x -> MdmUserImportVo.ProcessTypeEnum.SUCCESS == x.getProcessType()).collect(Collectors.toList());
        int userSize = collect.size();
        if (userSize == 0) {
            return;
        }

        List<String> userCodeList = CodeUtil.generateCodeList(CodeRuleEnum.MDM_USER_CODE.getCode(), userSize);
        for (int i = 0; i < userSize; i++) {
            collect.get(i).setUserCode(userCodeList.get(i));
        }

        List<MdmUserImportVo> newPositionList = collect.stream().filter(x -> PositionOperationEnum.NEW.getCode().equals(x.getOperationType())).collect(Collectors.toList());
        if (newPositionList.size() > 0) {
            int newPositionSize = newPositionList.size();
            List<String> positionCodeList = CodeUtil.generateCodeList(CodeRuleEnum.MDM_POSITION_CODE.getCode(), newPositionSize);
            for (int i = 0; i < newPositionSize; i++) {
                newPositionList.get(i).setPrimaryPositionCode(positionCodeList.get(i));
            }
            generatePositionName(newPositionList);
        }

        final Map<String, MdmUserImportVo> userNamePositionMap = collect.stream().collect(Collectors.toMap(MdmUserImportVo::getUserName, v -> v));
        websocketUtil.sendMsg(sid, "开始获取上级账号预加载数据");
        //登录名已存在校验map
        Map<String, MdmUserEntity> parentUserNameCheckMap = new HashMap<>(16);
        Map<String, MdmPositionEntity> parentUserNamePrimaryPositionMap = new HashMap<>(16);
        Set<String> paramParentUserNameSet = collect.stream().filter(item -> StringUtils.isNotEmpty(item.getParentUserName())).map(MdmUserImportVo::getParentUserName).collect(Collectors.toSet());
        if (!paramParentUserNameSet.isEmpty()) {
            List<String> list = new ArrayList<>(paramParentUserNameSet);
            List<List<String>> lists = Lists.partition(list, 500);
            for (List<String> item : lists) {
                QueryWrapper<MdmUserEntity> userNameQuery = new QueryWrapper<>();
                userNameQuery.in("user_name", item);
                userNameQuery.select("user_name", "user_type", "enable_status");
                List<MdmUserEntity> userNameQueryEntityList = mdmUserMapper.selectList(userNameQuery);
                if (CollectionUtil.listNotEmptyNotSizeZero(userNameQueryEntityList)) {
                    parentUserNameCheckMap.putAll(userNameQueryEntityList.stream().collect(Collectors.toMap(MdmUserEntity::getUserName, v -> v)));
                    QueryWrapper<MdmPositionUserEntity> positionUserQuery = new QueryWrapper<>();
                    positionUserQuery.eq("primary_flag", YesNoEnum.yesNoEnum.ONE.getValue());
                    positionUserQuery.in("user_name", userNameQueryEntityList.stream().map(MdmUserEntity::getUserName).collect(Collectors.toSet()));
                    positionUserQuery.select("user_name", "position_code");
                    List<MdmPositionUserEntity> positionUserEntityList = mdmPositionUserMapper.selectList(positionUserQuery);
                    if (CollectionUtil.listNotEmptyNotSizeZero(positionUserEntityList)) {
                        QueryWrapper<MdmPositionEntity> positionQuery = new QueryWrapper<>();
                        positionQuery.in("position_code", positionUserEntityList.stream().map(MdmPositionUserEntity::getPositionCode).collect(Collectors.toSet()));
                        positionQuery.select("position_code", "position_name", "org_code", "enable_status");
                        final Map<String, MdmPositionEntity> parentPositionMap = mdmPositionMapper.selectList(positionQuery).stream().collect(Collectors.toMap(MdmPositionEntity::getPositionCode, v -> v));
                        if (!parentPositionMap.isEmpty()) {
                            parentUserNamePrimaryPositionMap.putAll(positionUserEntityList.stream().filter(x -> parentPositionMap.containsKey(x.getPositionCode())).collect(Collectors.toMap(MdmPositionUserEntity::getUserName, v -> parentPositionMap.get(v.getPositionCode()))));
                        }
                    }
                }
            }
        }
        websocketUtil.sendMsg(sid, "结束获取上级账号预加载数据===>" + paramParentUserNameSet.size());


        List<MdmUserEntity> userEntityList = new ArrayList<>();
        List<MdmPositionEntity> positionEntityList = new ArrayList<>();
        List<MdmPositionUserEntity> positionRelUserEntityList = new ArrayList<>();
        List<MdmPositionRoleEntity> positionRelRoleEntityList = new ArrayList<>();
        List<MdmPositionBpmRoleEntity> positionRelBpmRoleEntityList = new ArrayList<>();
        for (MdmUserImportVo item :
                collect) {

            MdmUserEntity copy = CrmBeanUtil.copy(item, MdmUserEntity.class);
            copy.setStartTime(item.getStartTime() + " 00:00:00");
            copy.setEndTime(item.getEndTime() + " 23:59:59");
            copy.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
            copy.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            copy.setUserPassword(Md5EncryptionAndDecryption.encryPwd(item.getUserPassword()));
            copy.setUserType(UserTypeEnum.USER.getCode());
            copy.setUserCode(item.getUserCode());
            copy.setForceChangePassword(YesNoEnum.yesNoEnum.ONE.getValue());
            userEntityList.add(copy);

            MdmPositionUserEntity positionRelUser = new MdmPositionUserEntity();
            positionRelUser.setUserName(item.getUserName());
            positionRelUser.setCurrentFlag(YesNoEnum.yesNoEnum.ONE.getValue());
            positionRelUser.setPrimaryFlag(YesNoEnum.yesNoEnum.ONE.getValue());
            positionRelUser.setPositionCode(item.getPrimaryPositionCode());
            positionRelUserEntityList.add(positionRelUser);

            if (PositionOperationEnum.NEW.getCode().equals(item.getOperationType())) {
                MdmPositionEntity position = new MdmPositionEntity();
                position.setPositionCode(item.getPrimaryPositionCode());
                position.setPositionName(item.getPositionName());
                position.setPositionLevelCode(item.getPositionLevelCode());
                position.setOrgCode(item.getOrgCode());
                position.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                position.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                position.setRuleCode(UUID.randomUUID().toString().replace("-", ""));
                position.setLevelNum(1);
                if (StringUtils.isNotEmpty(item.getParentUserName())) {
                    if (parentUserNameCheckMap.containsKey(item.getParentUserName())) {
                        position.setParentCode(parentUserNamePrimaryPositionMap.get(item.getParentUserName()).getPositionCode());
                    } else {
                        MdmUserImportVo mdmUserImportVo = userNamePositionMap.get(item.getParentUserName());
                        if (mdmUserImportVo != null) {
                            position.setParentCode(mdmUserImportVo.getPrimaryPositionCode());
                        }
                    }
                }

                if (StringUtils.isNotEmpty(item.getRoleCode())) {
                    positionRelRoleEntityList.addAll(Arrays.stream(item.getRoleCode().split(",")).map(x -> {
                        MdmPositionRoleEntity positionRoleEntity = new MdmPositionRoleEntity();
                        positionRoleEntity.setPositionCode(item.getPrimaryPositionCode());
                        positionRoleEntity.setRoleCode(x);
                        return positionRoleEntity;
                    }).collect(Collectors.toList()));
                }

                if (StringUtils.isNotEmpty(item.getBpmRoleCode())) {
                    positionRelBpmRoleEntityList.addAll(Arrays.stream(item.getBpmRoleCode().split(",")).map(x -> {
                        MdmPositionBpmRoleEntity positionBpmRoleEntity = new MdmPositionBpmRoleEntity();
                        positionBpmRoleEntity.setPositionCode(item.getPrimaryPositionCode());
                        positionBpmRoleEntity.setBpmRoleCode(x);
                        return positionBpmRoleEntity;
                    }).collect(Collectors.toList()));
                }

                positionEntityList.add(position);
            } else {
                if (StringUtils.isNotEmpty(item.getOtherPositionCodes())) {
                    for (String positionCode :
                            item.getOtherPositionCodes().split(",")) {
                        MdmPositionUserEntity otherRel = new MdmPositionUserEntity();
                        otherRel.setUserName(item.getUserName());
                        otherRel.setPositionCode(positionCode);
                        otherRel.setPrimaryFlag(YesNoEnum.yesNoEnum.ZERO.getValue());
                        otherRel.setCurrentFlag(YesNoEnum.yesNoEnum.ZERO.getValue());
                        positionRelUserEntityList.add(otherRel);
                    }
                }
            }
        }

        websocketUtil.sendMsg(sid, "数据准备完成即将==>保存数据");
        if (CollectionUtil.listNotEmptyNotSizeZero(userEntityList)) {

            if (CollectionUtil.listNotEmptyNotSizeZero(positionRelUserEntityList)) {
                Set<String> pos = positionRelUserEntityList.stream().map(MdmPositionUserEntity::getPositionCode).collect(Collectors.toSet());
                List<String> list = new ArrayList<>(pos);
                List<List<String>> lists = Lists.partition(list, 500);

                for (List<String> item : lists) {
                    QueryWrapper<MdmPositionUserEntity> positionRelUserDelete = new QueryWrapper<>();
                    positionRelUserDelete.in("position_code", item);
                    mdmPositionUserMapper.delete(positionRelUserDelete);
                }
            }

            List<List<MdmUserEntity>> userGroup = Lists.partition(userEntityList, 200);
            int countSave = 1;
            for (List<MdmUserEntity> item :
                    userGroup) {
                websocketUtil.sendMsg(sid, "正在保存用户数据请等待==>" + (countSave * 200));
                this.saveBatch(item);
            }

            websocketUtil.sendMsg(sid, "开始保存数据===>开始保存职位");
            if (CollectionUtil.listNotEmptyNotSizeZero(positionEntityList)) {
                for (MdmPositionEntity item :
                        positionEntityList) {
                    mdmPositionMapper.insert(item);
                }
                this.sendPositionAdd(CrmBeanUtil.copyList(positionEntityList, MdmPositionRespVo.class));
            }
            websocketUtil.sendMsg(sid, "开始保存数据===>结束保存职位===>" + positionEntityList.size());

            websocketUtil.sendMsg(sid, "开始保存数据===>开始保存职位关联角色");
            if (CollectionUtil.listNotEmptyNotSizeZero(positionRelRoleEntityList)) {
                for (MdmPositionRoleEntity item :
                        positionRelRoleEntityList) {
                    mdmPositionRoleMapper.insert(item);
                }
            }
            websocketUtil.sendMsg(sid, "开始保存数据===>结束保存职位关联角色===>" + positionRelRoleEntityList.size());


            websocketUtil.sendMsg(sid, "开始保存数据===>开始保存职位关联流程角色");
            if (CollectionUtil.listNotEmptyNotSizeZero(positionRelBpmRoleEntityList)) {
                for (MdmPositionBpmRoleEntity item :
                        positionRelBpmRoleEntityList) {
                    mdmPositionBpmRoleMapper.insert(item);
                }
                this.sendPositionRelBpmRoleAdd(CrmBeanUtil.copyList(positionRelBpmRoleEntityList, MdmPositionBpmRoleRespVo.class));
            }
            websocketUtil.sendMsg(sid, "开始保存数据===>结束保存职位关联流程角色===>" + positionRelBpmRoleEntityList.size());


            websocketUtil.sendMsg(sid, "正在保存职位与用户关系数据请等待");
            for (MdmPositionUserEntity item :
                    positionRelUserEntityList) {
                mdmPositionUserMapper.insert(item);
            }
            websocketUtil.sendMsg(sid, "保存职位与用户关系数据结束==>导入即将结束");
            PositionUtil.deleteAllCache();
            resetRuleCode(sid);
        }

    }

    /**
     * 生成职位名称
     *
     * @param collect
     */
    public void generatePositionName(List<MdmUserImportVo> collect) {
        if (collect != null && collect.size() > 0) {
            List<MdmUserImportVo> emptyPositionNameList = collect.stream().filter(x -> StringUtils.isEmpty(x.getPositionName())).collect(Collectors.toList());
            if (!emptyPositionNameList.isEmpty()) {
                Set<String> existNameSet = collect.stream().filter(x -> StringUtils.isNotEmpty(x.getPositionName())).map(MdmUserImportVo::getPositionName).collect(Collectors.toSet());
                Map<String, List<MdmUserImportVo>> groupByPositionLevelCode = emptyPositionNameList.stream().collect(Collectors.groupingBy(MdmUserImportVo::getPositionLevelCode));
                for (Map.Entry<String, List<MdmUserImportVo>> entry :
                        groupByPositionLevelCode.entrySet()) {
                    generatePositionNameGroupByPositionLevel(entry.getKey(), entry.getValue(), existNameSet);
                }
            }
        }
    }

    /**
     * 分组生成职位名称
     *
     * @param positionLevelCode
     * @param collect
     * @param generateNameSet
     */
    public void generatePositionNameGroupByPositionLevel(String positionLevelCode, List<MdmUserImportVo> collect, Set<String> generateNameSet) {
        Assert.hasText(positionLevelCode, "缺失职位级别编码");

        QueryWrapper<MdmPositionLevelEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("position_level_code", positionLevelCode);
        MdmPositionLevelEntity positionLevel = mdmPositionLevelMapper.selectOne(wrapper);
        Assert.notNull(positionLevel, "无效的职位级别");
        Assert.isTrue(CrmEnableStatusEnum.ENABLE.getCode().equals(positionLevel.getEnableStatus()), "该职位级别已停用");

        Integer suffixSequence = positionLevel.getSuffixSequence();
        if (suffixSequence == null) {
            suffixSequence = 0;
        }
        Set<String> positionNameSet = new HashSet<>(16);

        QueryWrapper<MdmPositionEntity> positionQuery = new QueryWrapper<>();
        positionQuery.like("position_name", positionLevel.getPositionLevelName());
        positionQuery.select("position_name");
        List<MdmPositionEntity> positionList = mdmPositionMapper.selectList(positionQuery);

        if (CollectionUtil.listNotEmptyNotSizeZero(positionList)) {
            positionNameSet.addAll(positionList.stream().map(MdmPositionEntity::getPositionName).collect(Collectors.toSet()));
        }
        for (MdmUserImportVo item :
                collect) {
            String positionName = positionLevel.getPositionLevelName() + "_" + (++suffixSequence);
            while (positionNameSet.contains(positionName) || generateNameSet.contains(positionName)) {
                positionName = positionLevel.getPositionLevelName() + "_" + (++suffixSequence);
            }
            item.setPositionName(positionName);
            generateNameSet.add(positionName);
        }
        positionLevel.setSuffixSequence(suffixSequence);
        mdmPositionLevelMapper.updateById(positionLevel);
    }

    private void resetRuleCode(String sid) {
        long l = System.currentTimeMillis();
        log.info("-----------重置职位降维编码（导入）_" + l + "_开始-----------");
        websocketUtil.sendMsg(sid, "重置职位降维编码（导入）开始");
        mdmPositionMapper.copyIdToRuleCode();
        log.info("-----------重置职位降维编码（导入）_" + l + "_编码重置成id成功-----------");
        websocketUtil.sendMsg(sid, "重置职位降维编码（导入）编码重置成id成功");
        mdmPositionMapper.setNullNotExistParentCode();
        log.info("-----------重置职位降维编码（导入）_" + l + "_清除无效上级编码成功-----------");
        websocketUtil.sendMsg(sid, "重置职位降维编码（导入）清除无效上级编码成功");
        QueryWrapper<MdmPositionEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("del_flag", CrmDelFlagEnum.NORMAL.getCode());
        wrapper.and(x -> x.eq("parent_code", "").or().isNull("parent_code"));
        List<MdmPositionEntity> list = mdmPositionMapper.selectList(wrapper);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            for (int i = 0; i < list.size(); i++) {
                updateCurAndChildren(list.get(i).getPositionCode(), TreeRuleCodeUtil.numToSingleCode(i + 1), 1);
            }
        }
        log.info("-----------重置职位降维编码（导入）_" + l + "_编码重新生成成功-----------");
        websocketUtil.sendMsg(sid, "重置职位降维编码（导入）编码重新生成成功");
        PositionUtil.deleteAllCache();
        log.info("-----------重置职位降维编码（导入）_" + l + "_缓存清除成功-----------");
        websocketUtil.sendMsg(sid, "重置职位降维编码（导入）缓存清除成功");
        log.info("-----------重置职位降维编码（导入）_" + l + "_结束-----------");
        websocketUtil.sendMsg(sid, "重置职位降维编码（导入）结束");
    }

    /**
     * 更新职位及职位下级降维编码和层级
     *
     * @param positionCode 当前职位编码
     * @param curCode      当前职位降维编码
     * @param levelNum     当前层级
     */
    private void updateCurAndChildren(String positionCode, String curCode, int levelNum) {

        //更新当前
        LambdaUpdateWrapper<MdmPositionEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(MdmPositionEntity::getPositionCode, positionCode)
                .set(MdmPositionEntity::getRuleCode, curCode)
                .set(MdmPositionEntity::getLevelNum, levelNum);
        mdmPositionMapper.update(null, updateWrapper);

        //查询下一层
        LambdaQueryWrapper<MdmPositionEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MdmPositionEntity::getParentCode, positionCode)
                .eq(MdmPositionEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode())
                .select(MdmPositionEntity::getPositionCode);
        List<MdmPositionEntity> list = mdmPositionMapper.selectList(queryWrapper);

        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            //遍历下级
            for (int i = 0; i < list.size(); i++) {
                //递归调用
                updateCurAndChildren(list.get(i).getPositionCode(), curCode + TreeRuleCodeUtil.numToSingleCode(i + 1), (levelNum + 1));
            }
        }
    }

    protected void sendPositionAdd(List<MdmPositionRespVo> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        log.info("职位新增发送MQ消息：{}", list);
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag(RocketMQConstant.CRM_MQ_TAG.POSITION_ADD_TAG);
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(list));
        rocketMQProducer.convertAndSend(rocketMQMessageBody);
        log.info("职位新增发送MQ消息成功：{}", list);
    }

    protected void sendPositionRelBpmRoleAdd(List<MdmPositionBpmRoleRespVo> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        log.info("职位关联流程角色发送MQ消息：{}", list);
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag(RocketMQConstant.CRM_MQ_TAG.POSITION_REL_BPM_ROLE_ADD_TAG);
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(list));
        rocketMQProducer.convertAndSend(rocketMQMessageBody);
        log.info("职位关联流程角色发送MQ消息成功：{}", list);
    }

}
