package com.biz.crm.excel.component.saver.sfa;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.sfa.SfaAchievementRuleImportVo;
import com.biz.crm.sfa.test.entity.SfaAchievementRuleEntity;
import com.biz.crm.sfa.test.mapper.SfaAchievementRuleMapper;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author yangshan
 */
@Slf4j
@Component("sfaAchievementRuleSaver")
@Transactional(transactionManager = "sfaTransactionManager")
public class SfaAchievementRuleSaver<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<SfaAchievementRuleMapper, SfaAchievementRuleEntity, SfaAchievementRuleImportVo> implements ExcelImportSaver<SfaAchievementRuleImportVo> {

    /**
     * 保存数据逻辑
     * 在一个事务内完成，要么都成功，要么都失败
     *
     * @param data
     */
    @Override
    public void save(List<SfaAchievementRuleImportVo> data, DefaultImportContext context) {
        log.info("导入---保存数据逻辑==========================");

        if(CollectionUtils.isEmpty(data)){
            return;
        }
        this.sendWebsocketMsgMQ("开始尝试写入数据，总数:" + data.size(), context);
        //分片插入
        List<List<SfaAchievementRuleImportVo>> partitionDataList = Lists.partition(data, 50);
        partitionDataList.forEach(dataList -> {
            this.saveBatch(CrmBeanUtil.copyList(dataList, SfaAchievementRuleEntity.class));
        });

    }

}
