package com.biz.crm.excel.component.saver.sfa;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.sfa.SfaIndexImportVo;
import com.biz.crm.sfa.test.entity.SfaIndexEntity;
import com.biz.crm.sfa.test.mapper.SfaIndexMapper;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author yangshan
 */
@Slf4j
@Component("sfaIndexSaver")
@Transactional(transactionManager = "sfaTransactionManager")
public class SfaIndexSaver<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<SfaIndexMapper, SfaIndexEntity, SfaIndexImportVo> implements ExcelImportSaver<SfaIndexImportVo> {
    /**
     * 保存数据逻辑
     * 在一个事务内完成，要么都成功，要么都失败
     *
     * @param data
     */
    @Override
    public void save(List<SfaIndexImportVo> data, DefaultImportContext context) {
        log.info("导入---保存数据逻辑==========================");
        //分片插入
        List<List<SfaIndexImportVo>> partitionDataList = Lists.partition(data, 50);
        partitionDataList.forEach(dataList -> {
            this.saveBatch(CrmBeanUtil.copyList(dataList, SfaIndexEntity.class));
        });
    }
}
