package com.biz.crm.excel.component.saver.sfa;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.TestImportVo;
import com.biz.crm.sfa.test.entity.TestImportEntity;
import com.biz.crm.sfa.test.mapper.TestImportMapper;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Slf4j
@Component("testSaver")
@Transactional(transactionManager = "sfaTransactionManager")
public class TestSaver <M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<TestImportMapper, TestImportEntity, TestImportVo> implements ExcelImportSaver<TestImportVo> {
    /**
     * 保存数据逻辑
     * 在一个事务内完成，要么都成功，要么都失败
     *
     * @param data
     */
    @Override
    public void save(List<TestImportVo> data, DefaultImportContext context) {
        log.warn("测试导入---保存数据逻辑==========================");
        //分片插入
        List<List<TestImportVo>> partitionDataList = Lists.partition(data, 50);
        partitionDataList.forEach(dataList -> {
            this.saveBatch(CrmBeanUtil.copyList(dataList, TestImportEntity.class));
        });
        this.sendWebsocketMsgMQ("嘿嘿嘿", context);

    }
}
