package com.biz.crm.excel.component.saver.sfa.visitgroup;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.sfa.SfaVisitGroupImportVo;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactPageReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageVo;
import com.biz.crm.sfa.test.entity.SfaVisitGroupEntity;
import com.biz.crm.sfa.test.entity.SfaVisitclientRelEntity;
import com.biz.crm.sfa.test.mapper.SfaVisitClientRelMapper;
import com.biz.crm.sfa.test.mapper.SfaVisitGroupMapper;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.websocket.WebsocketUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.excel.component.saver.sfa.visitgroup
 * @date 2021/5/27 15:44
 */
@Slf4j
@Component("sfaVisitGroupSaver")
@Transactional("sfaTransactionManager")
public class SfaVisitGroupSaver<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<SfaVisitGroupMapper, SfaVisitGroupEntity, SfaVisitGroupImportVo> implements ExcelImportSaver<SfaVisitGroupImportVo> {


    private final static String DEALER = "0";

    private final static String TERMINAL = "1";

    @Resource
    private MdmPositionFeign mdmPositionFeign;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private SfaVisitClientRelMapper sfaVisitClientRelMapper;
    @Autowired
    private WebsocketUtil websocketUtil;


    @Override
    public void save(List<SfaVisitGroupImportVo> list, DefaultImportContext context) {
        List<List<SfaVisitGroupImportVo>> partitionList = Lists.partition(list,500);
        partitionList.forEach(data->{
            List<String> posCodeList = data.stream().map(SfaVisitGroupImportVo::getPosCode).collect(Collectors.toList());
            //查询用户信息
            List<MdmPositionUserOrgRespVo> userOrgRespVoList = ApiResultUtil.objResult(mdmPositionFeign.detailBatchByPositionCodeList(posCodeList));
            Map<String, MdmPositionUserOrgRespVo> userMap = userOrgRespVoList.stream().collect(Collectors.toMap(MdmPositionUserOrgRespVo::getPositionCode, k -> k));
            //职位校验
            checkPos(data, userMap);
            //职位与客户关联校验
            checkPosClient(data, userMap);
        });
    }

    /**
     * 进行职位校验
     */
    private void checkPos(List<SfaVisitGroupImportVo> data, Map<String, MdmPositionUserOrgRespVo> userMap) {
        data.forEach(p -> {
            if (!userMap.containsKey(p.getPosCode())) {
                p.appendErrorSaveMsg("职位编码不存在" + p.getPosCode());
            }
        });
    }

    /**
     * 校验职位与客户的关联性
     *
     * @param data
     */
    private void checkPosClient(List<SfaVisitGroupImportVo> data, Map<String, MdmPositionUserOrgRespVo> userMap) {
        //过滤 + 通过职位编码+客户类型进行分类
        Map<String, List<SfaVisitGroupImportVo>> posClientTypeMap = data.stream().filter(da -> da.getProcessType()
                .equals(AbstractImportVo.ProcessTypeEnum.SUCCESS)).collect(Collectors.toList())
                .stream().collect(Collectors.groupingBy(da -> da.getPosCode() + "-" + da.getGroupName()));
        posClientTypeMap.entrySet().forEach(pc -> {
            //职位编码
            String posCode = pc.getKey().split("-")[0];
            //线路组名称
            String groupName = pc.getKey().split("-")[1];
            if (!userMap.containsKey(posCode)) {
                return;
            }
            //验证是否存在相同的数据
            SfaVisitGroupEntity visitGroupEntity = this.lambdaQuery()
                    .eq(SfaVisitGroupEntity::getPosCode, posCode)
                    .eq(SfaVisitGroupEntity::getGroupName, groupName).one();
            if (visitGroupEntity != null) {
                Boolean flag = false;
                for (SfaVisitGroupImportVo da : data) {
                    String key = da.getPosCode() + "-" + da.getGroupName();
                    if (key.equals(pc.getKey())) {
                        da.appendErrorSaveMsg("数据库存在该职位[" + posCode + "]相同的线路组名称:[" + groupName + "]");
                        flag = true;
                    }
                }
                if (flag) {
                    return;
                }
            }
            MdmPositionUserOrgRespVo userOrgRespVo = userMap.get(posCode);
            SfaVisitGroupEntity sfaVisitGroupEntity = new SfaVisitGroupEntity() {{
                this.setGroupName(groupName);
                this.setGroupCode(CodeUtil.getCodeDefault());
                this.setPosCode(userOrgRespVo.getPositionCode());
                this.setPosName(userOrgRespVo.getPositionName());
                this.setUserName(userOrgRespVo.getUserName());
                this.setFullName(userOrgRespVo.getFullName());
                this.setOrgCode(userOrgRespVo.getOrgCode());
                this.setOrgName(userOrgRespVo.getOrgName());
            }};
            List<SfaVisitclientRelEntity> sfaVisitClientRelEntities = new ArrayList<>();
            Map<String, List<SfaVisitGroupImportVo>> clientListMap = pc.getValue().stream().collect(Collectors.groupingBy(SfaVisitGroupImportVo::getType));
            clientListMap.entrySet().forEach(client -> {
                //判断为经销商
                if (client.getKey().equals(DEALER)) {
                    PageResult<MdmCustomerMsgRespVo> customerResult = ApiResultUtil.objResult(mdmCustomerMsgFeign.listAndContactPage(new MdmCustomerContactPageReqVo() {{
                        this.setPositionCode(posCode);
                        this.setPageSize(-1);
                    }}));
                    if (customerResult != null && CollectionUtil.listNotEmptyNotSizeZero(customerResult.getData())) {
                        Map<String, MdmCustomerMsgRespVo> customerMap = customerResult.getData().stream().collect(Collectors.toMap(MdmCustomerMsgRespVo::getCustomerCode, k -> k));
                        client.getValue().forEach(c -> {
                            if (!customerMap.containsKey(c.getCode())) {
                                c.appendErrorSaveMsg("未查询到该职位" + posCode + "对应的经销商[" + c.getName() + "]");
                            } else {
                                MdmCustomerMsgRespVo customer = customerMap.get(c.getCode());
                                SfaVisitclientRelEntity relEntity = new SfaVisitclientRelEntity() {{
                                    this.setClientCode(customer.getCustomerCode());
                                    this.setClientName(customer.getCustomerName());
                                    this.setClientType(SfaVisitEnum.ClientType.DEALER.getVal());
                                    this.setClientTypeName(SfaVisitEnum.ClientType.DEALER.getDesc());
                                    this.setClientId(customer.getId());
                                    this.setClientPhone(customer.getCustomerContact());
                                    this.setClientAddress(customer.getRegisteredAddress());
                                    this.setClientSubclass(customer.getCustomerType());
                                    this.setClientSubclassName(customer.getCustomerTypeName());
                                    this.setGroupCode(sfaVisitGroupEntity.getGroupCode());
                                }};
                                if (CollectionUtil.listNotEmptyNotSizeZero(customer.getMdmCustomerContactVos())) {
                                    relEntity.setClientContacts(customer.getMdmCustomerContactVos().get(0).getContactName());
                                }
                                sfaVisitClientRelEntities.add(relEntity);
                            }
                        });
                    } else {
                        client.getValue().forEach(c -> {
                            c.appendErrorSaveMsg("未查询到该职位" + posCode + "对应的经销商[" + c.getName() + "]");
                        });
                    }
                } else if (client.getKey().equals(TERMINAL)) {
                    PageResult<MdmTerminalContactPageVo> terminalResult = ApiResultUtil.objResult(mdmTerminalFeign.terminalContactPage(new MdmTerminalContactPageReqVo() {{
                        this.setPositionCode(posCode);
                        this.setPositionCodeList(Lists.newArrayList(posCode));
                        this.setPageSize(-1);
                    }}));
                    if (terminalResult != null && CollectionUtil.listNotEmptyNotSizeZero(terminalResult.getData())) {
                        Map<String, MdmTerminalContactPageVo> customerMap = terminalResult.getData().stream().collect(Collectors.toMap(MdmTerminalContactPageVo::getTerminalCode, k -> k));
                        client.getValue().forEach(c -> {
                            if (!customerMap.containsKey(c.getCode())) {
                                c.appendErrorSaveMsg("未查询到该职位" + posCode + "对应的终端[" + c.getName() + "]");
                            } else {
                                MdmTerminalContactPageVo terminal = customerMap.get(c.getCode());
                                SfaVisitclientRelEntity relEntity = new SfaVisitclientRelEntity() {{
                                    this.setClientCode(terminal.getTerminalCode());
                                    this.setClientName(terminal.getTerminalName());
                                    this.setClientType(SfaVisitEnum.ClientType.TERMINAL.getVal());
                                    this.setClientTypeName(SfaVisitEnum.ClientType.TERMINAL.getDesc());
                                    this.setClientId(terminal.getId());
                                    this.setClientContacts(terminal.getContactName());
                                    this.setClientPhone(terminal.getContactPhone());
                                    this.setClientPhoto(terminal.getShopImagePath());
                                    this.setClientAddress(terminal.getTerminalAddress());
                                    this.setClientSubclass(terminal.getTerminalType());
                                    this.setClientSubclassName(terminal.getTerminalTypeName());
                                    this.setGroupCode(sfaVisitGroupEntity.getGroupCode());
                                }};
                                sfaVisitClientRelEntities.add(relEntity);
                            }
                        });
                    } else {
                        client.getValue().forEach(c -> {
                            c.appendErrorSaveMsg("未查询到该职位" + posCode + "对应的终端[" + c.getName() + "]");
                        });
                    }
                }
            });
            if (CollectionUtil.listNotEmptyNotSizeZero(sfaVisitClientRelEntities)) {
                this.save(sfaVisitGroupEntity);
                sfaVisitClientRelEntities.forEach(rel -> {
                    this.sfaVisitClientRelMapper.insert(rel);
                });
            }
        });
    }
}
