package com.biz.crm.excel.component.saver.tpm;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.FeeBudgetTypeEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.price.MdmPriceSettingImportVo;
import com.biz.crm.excel.vo.tpm.FeeBudgetImportVo;
import com.biz.crm.mdm.customer.model.MdmCustomerEntity;
import com.biz.crm.mdm.org.entity.MdmOrgEntity;
import com.biz.crm.mdm.org.mapper.MdmOrgMapper;
import com.biz.crm.mdm.price.model.MdmPriceSettingEntity;
import com.biz.crm.mdm.product.entity.MdmProductEntity;
import com.biz.crm.mdm.product.entity.MdmProductLevelEntity;
import com.biz.crm.mdm.product.mapper.MdmProductLevelMapper;
import com.biz.crm.mdm.product.mapper.MdmProductMapper;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSettingReqVo;
import com.biz.crm.nebular.tpm.feebudget.req.FeeBudgetControlOperateTypeEnum;
import com.biz.crm.tpm.feebudget.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.tpm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.tpm.feebudget.mapper.TpmFeeBudgetDetailsMapper;
import com.biz.crm.tpm.feebudget.mapper.TpmFeeBudgetMapper;
import com.biz.crm.tpm.feebudget.model.OperateBudgetControlReqVo;
import com.biz.crm.tpm.feebudget.model.TpmBudgetSubjectsEntity;
import com.biz.crm.tpm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.swagger.models.auth.In;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author zxw
 * @date 2021-02-10 09:05
 **/
@Slf4j
@Component("tpmFeeBudgetImportSavor")
public class TpmFeeBudgetImportSavor<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<TpmFeeBudgetMapper, TpmFeeBudgetEntity, FeeBudgetImportVo> implements ExcelImportSaver<FeeBudgetImportVo> {


    @Autowired
    private FeeBudgetServiceHelper helper;
    @Resource
    private TpmFeeBudgetMapper mapper;

    @Resource
    private TpmFeeBudgetDetailsMapper detailsMapper;

    @Resource
    private TpmFeeBudgetControlMapper controlMapper;


    @Override
    @Transactional(rollbackFor = Exception.class,value = "tpmTransactionManager")
    public void save(List<FeeBudgetImportVo> data, DefaultImportContext context) {
        if (!CollectionUtils.isEmpty(data)) {
            Set<String> budgetSubjectsCodes = Sets.newHashSet();
            Set<String> productCodes = Sets.newHashSet();
            Set<String> productLevelCodes = Sets.newHashSet();
            Set<String> orgCodes = Sets.newHashSet();
            Map<String, Integer> uniqueKeyMap=Maps.newHashMap();
            data.stream().forEach(o->{
                o.setFeeBudgetType(FeeBudgetTypeEnum.DEPARTMENT.getCode());
                if(StringUtils.isEmpty(o.getBudgetYear())){ o.appendErrorSaveMsg("年份不能为空;"); }
                try {
                    Integer year = Integer.valueOf(o.getBudgetYear());
                } catch (NumberFormatException e) {
                    o.appendErrorSaveMsg("年份值错误;");
                }
                if(StringUtils.isEmpty(o.getBudgetMonth())){ o.appendErrorSaveMsg("月份不能为空;"); }
                try {
                    Integer month = Integer.valueOf(o.getBudgetMonth());
                    if(month>12 || month<1 ){ o.appendErrorSaveMsg("月份值错误;");}
                    int quaterByMonth = DateUtil.getQuaterByMonth(month);
                    o.setBudgetQuater(String.valueOf(quaterByMonth));
                } catch (NumberFormatException e) {
                    o.appendErrorSaveMsg("月份值错误;");
                }
                if(StringUtils.isEmpty(o.getProjectNumber())){ o.appendErrorSaveMsg("专案号不能为空;"); }
                if(StringUtils.isEmpty(o.getOrgCode())){ o.appendErrorSaveMsg("组织编码不能为空;"); }
                if(StringUtils.isEmpty(o.getBudgetSubjectsCode())){ o.appendErrorSaveMsg("预算科目编码不能为空;"); }
                budgetSubjectsCodes.add(o.getBudgetSubjectsCode());
                if(StringUtils.isEmpty(o.getOrgCode())){ o.appendErrorSaveMsg("企业组织编码不能为空;"); }
                orgCodes.add(o.getOrgCode());
                if(!StringUtils.isEmpty(o.getProductCode())){ productCodes.add(o.getProductCode()); }
                if(!StringUtils.isEmpty(o.getProductLevelCode())){ productLevelCodes.add(o.getProductLevelCode()); }
                if(StringUtils.isEmpty(o.getInitAmount())){ o.appendErrorSaveMsg("预算金额不能为空;"); }
                try {
                    BigDecimal initAmount = new BigDecimal(o.getInitAmount());
                    if(initAmount.compareTo(BigDecimal.ZERO)!=1){
                        o.appendErrorSaveMsg("预算金额必须大于零;");
                    }
                } catch (Exception e) {
                    o.appendErrorSaveMsg("预算金额值错误;");
                }
                String uniqueKey = helper.getUniqueKey(o);
                if(uniqueKeyMap.containsKey(uniqueKey)){
                    o.appendErrorSaveMsg("表格存在重复维度的数据,重复行号="+uniqueKeyMap.get(uniqueKey)+";");
                }
                uniqueKeyMap.put(uniqueKey,o.getRowIndex());
            });
            Map<String, MdmProductEntity> productMap= helper.getProductMap(productCodes);
            Map<String, MdmOrgEntity> orgMap= helper.getOrgMap(orgCodes);
            Map<String, MdmProductLevelEntity> productLevelMap= helper.getProductLevelMap(productLevelCodes);
            Map<String, TpmBudgetSubjectsEntity> subjectMap= helper.getSubjectMap(budgetSubjectsCodes);
            List<TpmFeeBudgetEntity> saveList = Lists.newArrayList();
            data.stream().forEach(o->{
                MdmOrgEntity mdmOrgEntity = orgMap.get(o.getOrgCode());
                if(Objects.isNull(mdmOrgEntity)){
                    o.appendErrorSaveMsg("企业组织编码错误;");
                }else {
                    if(org.apache.commons.lang3.StringUtils.equals(CrmEnableStatusEnum.DISABLE.getCode(),o.getOrgCode())){
                        o.appendErrorSaveMsg("企业组织编码尚未启用;");
                    }else {
                        o.setOrgName(mdmOrgEntity.getOrgName());
                    }
                }
                TpmBudgetSubjectsEntity tpmBudgetSubjectsEntity = subjectMap.get(o.getBudgetSubjectsCode());
                if(Objects.isNull(tpmBudgetSubjectsEntity)){
                    o.appendErrorSaveMsg("预算科目编码错误;");
                }else {
                    if(org.apache.commons.lang3.StringUtils.equals(CrmEnableStatusEnum.DISABLE.getCode(),tpmBudgetSubjectsEntity.getEnableStatus())){
                        o.appendErrorSaveMsg("预算科目尚未启用;");
                    }
                }
                if(!StringUtils.isEmpty(o.getProductCode())){
                    MdmProductEntity productEntity = productMap.get(o.getProductCode());
                    if(Objects.isNull(productEntity)){
                        o.appendErrorSaveMsg("商品编码错误;");
                    }else {
                        if(org.apache.commons.lang3.StringUtils.equals(CrmEnableStatusEnum.DISABLE.getCode(),productEntity.getEnableStatus())){
                            o.appendErrorSaveMsg("商品编码未启用;");
                        }else if(org.apache.commons.lang3.StringUtils.equals(GlobalWhetherEnum.NO.getCode(),productEntity.getIsShelf())){
                            o.appendErrorSaveMsg("商品编码未上架;");
                        }else {
                            o.setProductName(productEntity.getProductName());
                        }
                        if(!StringUtils.isEmpty(o.getProductLevelCode())){
                            if(!org.apache.commons.lang3.StringUtils.equals(o.getProductLevelCode(),productEntity.getProductLevelCode())){
                                o.appendErrorSaveMsg("商品与商品层级不存在关联关系;");
                            }
                        }
                    }
                }
                if(!StringUtils.isEmpty(o.getProductLevelCode())){
                    MdmProductLevelEntity levelEntity = productLevelMap.get(o.getProductLevelCode());
                    if(Objects.isNull(levelEntity)){
                        o.appendErrorSaveMsg("商品层级编码错误;");
                    }else {
                        if(org.apache.commons.lang3.StringUtils.equals(CrmEnableStatusEnum.DISABLE.getCode(),levelEntity.getEnableStatus())){
                            o.appendErrorSaveMsg("商品层级未启用;");
                        }else {
                            o.setProductLevelName(levelEntity.getProductLevelName());
                        }
                    }
                }
                if(Objects.equals(AbstractImportVo.ProcessTypeEnum.SUCCESS,o.getProcessType())){
                    //校验唯一性
                    helper.checkDataExist(o);
                }
                if(Objects.equals(AbstractImportVo.ProcessTypeEnum.SUCCESS,o.getProcessType())){
                    TpmFeeBudgetEntity copy = CrmBeanUtil.copy(o, TpmFeeBudgetEntity.class);
                    copy.setInitAmount(new BigDecimal(o.getInitAmount()));
                    copy.setExt1(o.getProjectNumber());
                    saveList.add(copy);
                }
            });
            if(CollectionUtil.listNotEmptyNotSizeZero(saveList)){
                //执行保存操作
                saveList.forEach(o->{
                    helper.saveTpmFeeBudget(o);
                });
            }
        }
    }
}
