package com.biz.crm.excel.component.saver.tpm.budgetgeneraterule;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.component.saver.tpm.FeeBudgetServiceHelper;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.tpm.budgetgeneraterule.TpmBudgetGenerateRuleImportVo;
import com.biz.crm.tpm.budgetgeneraterule.mapper.TpmBudgetGenerateRuleMapper;
import com.biz.crm.tpm.budgetgeneraterule.model.TpmBudgetGenerateRuleEntity;
import com.biz.crm.tpm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.tpm.incomebudget.mapper.TpmIncomeBudgetMapper;
import com.biz.crm.tpm.incomebudget.model.TpmIncomeBudgetEntity;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author yb
 * @version 1.0
 * @date 2021/12/10 14:03
 * @description
 */
@Component("tpmBudgetGenerateRuleImportSaver")
public class TpmBudgetGenerateRuleImportSaver <M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<TpmBudgetGenerateRuleMapper, TpmBudgetGenerateRuleEntity, TpmBudgetGenerateRuleImportVo> implements ExcelImportSaver<TpmBudgetGenerateRuleImportVo> {

    @Resource
    private TpmBudgetGenerateRuleMapper tpmBudgetGenerateRuleMapper;

    @Resource
    private TpmIncomeBudgetMapper tpmIncomeBudgetMapper;

    @Resource
    private FeeBudgetServiceHelper helper;

    @Override
    @Transactional(rollbackFor = Exception.class,value = "tpmTransactionManager")
    public void save(List<TpmBudgetGenerateRuleImportVo> data, DefaultImportContext context) {
        data.forEach(importVo -> {
            TpmBudgetGenerateRuleEntity entity = CrmBeanUtil.copy(importVo, TpmBudgetGenerateRuleEntity.class);
            entity.setBudgetRuleCode(CodeUtil.generateCode(CodeRuleEnum.BUDGET_RULE_CODE.getCode()));
            //生成费用预算为是,查找收入预算,生成费用预算
            if(importVo.getIsGenerate().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getValue())) {
                LambdaQueryWrapper<TpmIncomeBudgetEntity> wrapper = Wrappers.lambdaQuery(TpmIncomeBudgetEntity.class)
                        .eq(TpmIncomeBudgetEntity::getFeeBudgetType, importVo.getFeeBudgetType())
                        .eq(TpmIncomeBudgetEntity::getBudgetYear, importVo.getYear())
                        .eq(TpmIncomeBudgetEntity::getBudgetMonth, importVo.getMonth());
                if (importVo.getOrgCode() != null) {
                    wrapper.eq(TpmIncomeBudgetEntity::getOrgCode, importVo.getOrgCode());
                }
                if (importVo.getCustomerCode() != null) {
                    wrapper.eq(TpmIncomeBudgetEntity::getCustomerCode, importVo.getCustomerCode());
                }
                if (importVo.getTerminalCode() != null) {
                    wrapper.eq(TpmIncomeBudgetEntity::getTerminalCode, importVo.getTerminalCode());
                }
                if(importVo.getChannel() != null){
                    wrapper.eq(TpmIncomeBudgetEntity::getChannel, importVo.getChannel());
                }
                //按照维度,年分,月分查找收入预算并生成相应的费用预算
                List<TpmIncomeBudgetEntity> incomeBudgetEntities = tpmIncomeBudgetMapper.selectList(wrapper);
                boolean saveStatus = false;
                if(CollectionUtils.isNotEmpty(incomeBudgetEntities)) {
                    for (TpmIncomeBudgetEntity tpmIncomeBudgetEntity : incomeBudgetEntities) {
                        TpmFeeBudgetEntity tpmFeeBudgetEntity = CrmBeanUtil.copy(tpmIncomeBudgetEntity, TpmFeeBudgetEntity.class);
                        tpmFeeBudgetEntity.setBudgetSubjectsCode(entity.getBudgetSubjectCode());
                        tpmFeeBudgetEntity.setId(null);
                        tpmFeeBudgetEntity.setInitAmount(tpmIncomeBudgetEntity.getInitAmount().multiply(entity.getRatio()).divide(new BigDecimal(100)));
                        tpmFeeBudgetEntity.setBudgetQuater(String.valueOf(DateUtil.getQuaterByMonth(Integer.parseInt(entity.getMonth()))));
                        if(!helper.checkDataExist(tpmFeeBudgetEntity)){
                            saveStatus = true;
                            helper.saveTpmFeeBudget(tpmFeeBudgetEntity);
                        }
                    }
                }
                if(!saveStatus){
                    importVo.appendErrorSaveMsg("未找到相应维度收入预算;");
                    return;
                }
                entity.setIsGenerate(YesNoEnum.yesNoEnum.ONE.getValue());
            }else {
                entity.setIsGenerate(YesNoEnum.yesNoEnum.ZERO.getValue());
            }
            tpmBudgetGenerateRuleMapper.insert(entity);
        });
    }
}
