package com.biz.crm.excel.component.saver.tpm.incomebudget;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.tpm.incomebudget.TpmIncomeBudgetImportVo;
import com.biz.crm.tpm.incomebudget.mapper.TpmIncomeBudgetMapper;
import com.biz.crm.tpm.incomebudget.model.TpmIncomeBudgetEntity;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;


/**
 * @author yb
 * @version 1.0
 * @date 2021/12/14 14:02
 * @description
 */
@Component("tpmIncomeBudgetSaver")
public class TpmIncomeBudgetSaver <M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<TpmIncomeBudgetMapper, TpmIncomeBudgetEntity, TpmIncomeBudgetImportVo> implements ExcelImportSaver<TpmIncomeBudgetImportVo> {

    @Override
    public void save(List<TpmIncomeBudgetImportVo> data, DefaultImportContext context) {
        List<TpmIncomeBudgetEntity> saves = data.stream().map(tpmIncomeBudgetImportVo -> {
            TpmIncomeBudgetEntity entity = CrmBeanUtil.copy(tpmIncomeBudgetImportVo, TpmIncomeBudgetEntity.class);
            entity.setIncomeCode(CodeUtil.createOneCode(CrmCodeRuleConstants.INCOME_BUDGET));
            return entity;
        }).collect(Collectors.toList());
        this.saveBatch(saves);
    }
}
