package com.biz.crm.excel.component.saver.tpm.invoicepool;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.tpm.invoice.TpmInvoiceImportVo;
import com.biz.crm.tpm.invoicepool.mapper.TpmInvoicePoolMapper;
import com.biz.crm.tpm.invoicepool.model.TpmInvoicePoolEntity;
import com.biz.crm.util.CrmBeanUtil;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author yb
 * @version 1.0
 * @date 2021/12/10 14:03
 * @description
 */
@Component("tpmInvoicePoolImportSaver")
public class TpmInvoicePoolImportSaver<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<TpmInvoicePoolMapper, TpmInvoicePoolEntity, TpmInvoiceImportVo> implements ExcelImportSaver<TpmInvoiceImportVo> {

    @Resource
    private TpmInvoicePoolMapper tpmInvoicePoolMapper;


    @Override
    @Transactional(rollbackFor = Exception.class,value = "tpmTransactionManager")
    public void save(List<TpmInvoiceImportVo> data, DefaultImportContext context) {
        data.forEach(importVo -> {
            TpmInvoicePoolEntity entity = CrmBeanUtil.copy(importVo, TpmInvoicePoolEntity.class);
            tpmInvoicePoolMapper.insert(entity);
        });
    }
}
