package com.biz.crm.excel.component.saver.tpm.salesplans;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.sfa.SfaAchievementRuleImportVo;
import com.biz.crm.excel.vo.tpm.salesplans.TpmSalesPlansImportVo;
import com.biz.crm.sfa.test.entity.SfaAchievementRuleEntity;
import com.biz.crm.tpm.salesplans.mapper.TpmSalesPlansMapper;
import com.biz.crm.tpm.salesplans.model.TpmSalesPlansEntity;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @description: 销售计划导入保存
 * @author: rentao
 * @date: 2021/10/28 16:44
 */

@Slf4j
@Component("tpmsalesPlansImportSaver")
@Transactional("tpmTransactionManager")
public class TpmsalesPlansImportSaver<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<TpmSalesPlansMapper, TpmSalesPlansEntity, TpmSalesPlansImportVo> implements ExcelImportSaver<TpmSalesPlansImportVo> {


  /**
   * 保存数据逻辑
   * 在一个事务内完成，要么都成功，要么都失败
   *
   * @param data
   */
  @Override
  public void save(List<TpmSalesPlansImportVo> data, DefaultImportContext context) {
    log.info("导入---保存数据逻辑==========================");

    if(CollectionUtils.isEmpty(data)){
      return;
    }
    this.sendWebsocketMsgMQ("开始尝试写入数据，总数:" + data.size(), context);
    //分片插入
    List<List<TpmSalesPlansImportVo>> partitionDataList = Lists.partition(data, 50);
    partitionDataList.forEach(dataList -> {
      this.saveBatch(CrmBeanUtil.copyList(dataList, TpmSalesPlansEntity.class));
    });
  }



}
