package com.biz.crm.excel.component.validator;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.excel.component.AbstractImportHelper;
import com.biz.crm.excel.util.DefaultImportContext;

import java.util.List;


/**
 * 导入校验接口抽象
 *  @author: luoqi
 *  @Date: 2020-12-8 17:57
 *  @version: V1.0
 *  @Description:
 */
public abstract class AbstractExcelImportValidator<M extends BaseMapper<T>, T, ImportVo extends AbstractImportVo> extends AbstractImportHelper<M, T> implements ExcelImportValidator<ImportVo>{
    /**
     * 添加错误信息
     * @param data
     * @param msg
     * @param context
     */
    protected void errorMsg(ImportVo data, String msg, DefaultImportContext context){
        if(null == data){
            return;
        }
        data.appendErrorValidateMsg(msg);
    }
    /**
     * 添加错误信息,并将信息发送到Websocket
     * @param data
     * @param msg
     * @param context
     */
    protected void errorMsgAndSendWebsocket(ImportVo data, String msg, DefaultImportContext context) {
        this.errorMsg(data, msg, context);
        if (data != null
                && data.getRowIndex() != null
                && data.getRowIndex() > 1) {
            this.sendWebsocketMsgMQ("第" + (data.getRowIndex() - 1) + "行:" + msg, context);
        } else {
            this.sendWebsocketMsgMQ(msg, context);
        }
    }
    /**
     * 批量添加错误信息
     * @param dataList
     * @param msg
     * @param context
     */
    protected void errorMsgBatch(List<ImportVo> dataList, String msg, DefaultImportContext context){
        if(null == dataList){
            return;
        }
        for (ImportVo data : dataList) {
            data.appendErrorValidateMsg(msg);
        }
    }
    /**
     * 批量添加错误信息,并将信息发送到Websocket (Websocket只会发送一次)
     * @param dataList
     * @param msg
     * @param context
     */
    protected void errorMsgBatchAndSendWebsocket(List<ImportVo> dataList, String msg, DefaultImportContext context){
        this.errorMsgBatch(dataList, msg, context);
        this.sendWebsocketMsgMQ(msg, context);
    }

}
