package com.biz.crm.excel.component.validator.kms.confadmin;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.confadmin.model.KmsDirectStoreAreaEntity;
import com.biz.crm.confadmin.model.KmsDirectStoreEntity;
import com.biz.crm.confadmin.model.KmsDirectSystemEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.confadmin.KmsDirectStoreImportVo;
import com.biz.crm.kms.confadmin.mapper.KmsDirectStoreAreaMapper;
import com.biz.crm.kms.confadmin.mapper.KmsDirectStoreMapper;
import com.biz.crm.kms.confadmin.mapper.KmsDirectSystemMapper;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Sets;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author maoshen
 * @date 2021/5/28.
 */
@Slf4j
@Component("kmsDirectStoreValidator")
public class KmsDirectStoreValidator<M extends BaseMapper<T>, T> extends AbstractExcelImportValidator<KmsDirectStoreMapper, KmsDirectStoreEntity, KmsDirectStoreImportVo> implements ExcelImportValidator<KmsDirectStoreImportVo> {

    private Map<String, KmsDirectSystemEntity> spareDirectSystemMap = Maps.newHashMap();

    private final Map<String, Map<String, KmsDirectStoreAreaEntity>> spareStoreAreaMap = Maps.newHashMap();

    @Resource
    private KmsDirectStoreMapper kmsDirectStoreMapper;

    @Resource
    private KmsDirectStoreAreaMapper kmsDirectStoreAreaMapper;

    @Resource
    private KmsDirectSystemMapper kmsDirectSystemMapper;

    private Set<String> directIdSet = Sets.newHashSet();

    @Override

    public void validate(List<KmsDirectStoreImportVo> data, DefaultImportContext context) {

        ConcurrentHashMap<String, Object> map = ThreadLocalUtil.get();
        map.put(GlobalParam.FUNCTION_CODE, "supermarket_deport_list");
        map.put(GlobalParam.MENU_CODE, "CRM20210518000001671");
        ThreadLocalUtil.setUser(UserUtils.getUser());
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        //检验数据填写
        Set<String> idSet = Sets.newHashSet();
        Set<String> directNameSet = Sets.newHashSet();
        Set<String> areaCodeSet = Sets.newHashSet();
        Map<String, KmsDirectStoreImportVo> storeCodeMap = Maps.newHashMap();
        Set<String> storeCodeSet = Sets.newHashSet();
        Map<String, String> storeCodeAreaMap = Maps.newHashMap();
        data.forEach(x -> {
            if (StringUtils.isBlank(x.getDirectName())) {
                x.appendErrorValidateMsg("【商超体系不能为空】、");
            }
            if (StringUtils.isBlank(x.getStoreCode())) {
                x.appendErrorValidateMsg("【商超门店编码不能为空】、");
            }
            if (StringUtils.isBlank(x.getStoreName())) {
                x.appendErrorValidateMsg("【商超门店名称不能为空】、");
            }
            if (StringUtils.isNotBlank(x.getAreaCode())) {
                areaCodeSet.add(x.getAreaCode());
                storeCodeAreaMap.put(x.getStoreCode(), x.getAreaCode());
                if (storeCodeMap.containsKey(x.getDirectName() + x.getStoreCode() + x.getAreaCode())) {
                    x.appendErrorValidateMsg("商超【" + x.getDirectName() + "】下门店【" + x.getStoreCode() + "】不可重复导入、");
                } else {
                    storeCodeMap.put(x.getDirectName() + x.getStoreCode() + x.getAreaCode(), x);
                    storeCodeSet.add(x.getStoreCode());
                }
            }
            if (StringUtils.isBlank(x.getAreaCode())) {
                if (storeCodeMap.containsKey(x.getDirectName() + x.getStoreCode())) {
                    x.appendErrorValidateMsg("商超【" + x.getDirectName() + "】下门店【" + x.getStoreCode() + "】不可重复导入、");
                } else {
                    storeCodeMap.put(x.getDirectName() + x.getStoreCode(), x);
                    storeCodeSet.add(x.getStoreCode());
                }
            }
            directNameSet.add(x.getDirectName());
        });
        List<KmsDirectSystemEntity> systemEntityList = kmsDirectSystemMapper.selectList(Wrappers
                .<KmsDirectSystemEntity>lambdaQuery()
                .in(KmsDirectSystemEntity::getDirectName, directNameSet)
                .eq(KmsDirectSystemEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode())
                .eq(KmsDirectSystemEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
        if (CollectionUtils.isEmpty(systemEntityList)) {
            data.forEach(x -> {
                x.appendErrorValidateMsg("【" + x.getDirectName() + "】商超体系不在维护中");
            });
        } else {
            Map<String, KmsDirectSystemEntity> systemEntityMap = systemEntityList.stream()
                    .collect(Collectors.toMap(KmsDirectSystemEntity::getDirectName, Function.identity()));
            data.forEach(x -> {
                if (systemEntityMap.containsKey(x.getDirectName())) {
                    x.setDirectId(systemEntityMap.get(x.getDirectName()).getId());
                    idSet.add(x.getDirectId());
                    this.directIdSet.add(x.getDirectId());
                } else {
                    x.appendErrorValidateMsg("【" + x.getDirectName() + "】商超体系不在维护中");
                }
            });
        }

        // 组装检验备用数据
        this.spareCheckData(directIdSet, areaCodeSet, data);

        // 检验数据（备用数据 和 excel数据）
        this.compareSpareAndExcel(directIdSet, data);

        this.directIdSet = idSet;
        // 检验数据重复（excel数据 和 数据库数据）
        this.compareDbAndExcel(storeCodeSet, storeCodeMap, data, directIdSet);

    }

    /**
     * 检验数据重复（excel数据 和 数据库数据）
     *
     * @param storeCodeMap
     */
    private void compareDbAndExcel(Set<String> storeCodeSet, Map<String, KmsDirectStoreImportVo> storeCodeMap, List<KmsDirectStoreImportVo> data, Set<String> directIdSet) {
        List<KmsDirectStoreEntity> kmsDirectStoreEntities = kmsDirectStoreMapper
                .selectList(Wrappers.<KmsDirectStoreEntity>lambdaQuery()
                        .eq(KmsDirectStoreEntity::getDelFlag, CrmEnableStatusEnum.ENABLE.getCode())
                        .in(KmsDirectStoreEntity::getDirectId, directIdSet)
                        .in(KmsDirectStoreEntity::getStoreCode, storeCodeSet));

        if (CollectionUtils.isEmpty(kmsDirectStoreEntities)) {
            return;
        }
        Map<String, KmsDirectStoreEntity> storeMapWithArea = Maps.newHashMap();
        Map<String, KmsDirectStoreEntity> storeMapWithoutArea = Maps.newHashMap();
        kmsDirectStoreEntities.forEach(x -> {
            if (StringUtils.isNotBlank(x.getAreaId())) {
                storeMapWithArea.put(x.getDirectId() + x.getStoreCode() + x.getAreaId(), x);
            }
            if (StringUtils.isBlank(x.getAreaId())) {
                storeMapWithoutArea.put(x.getDirectId() + x.getStoreCode(), x);
            }
        });
        data.forEach(x -> {
            if (StringUtils.isBlank(x.getAreaId())) {
                if (storeMapWithoutArea.containsKey(x.getDirectId() + x.getStoreCode())) {
                    x.appendErrorValidateMsg("【该数据已存在】");
                }
            }
            if (StringUtils.isNotBlank(x.getAreaId())) {
                if (storeMapWithArea.containsKey(x.getDirectId() + x.getStoreCode() + x.getAreaId())) {
                    x.appendErrorValidateMsg("【该数据已存在】");
                }
            }
        });

    }

    /**
     * 比较备用数据 和 excel 是否对应；
     *
     * @param directIdSet
     * @param data
     */
    private void compareSpareAndExcel(Set<String> directIdSet, List<KmsDirectStoreImportVo> data) {
        directIdSet.removeAll(this.spareDirectSystemMap.keySet());
        if (CollectionUtils.isNotEmpty(directIdSet)) {
            data.forEach(x -> {
                if (directIdSet.contains(x.getDirectId())) {
                    x.appendErrorValidateMsg("【" + x.getDirectName() + "】的商超系统不在维护中");
                }
            });
        }
        data.forEach(x -> {
            Map<String, KmsDirectStoreAreaEntity> areaEntityMap = this.spareStoreAreaMap.get(x.getDirectId());
            if (StringUtils.isNotBlank(x.getAreaCode())) {
                if (MapUtils.isEmpty(areaEntityMap)) {
                    x.appendErrorValidateMsg("【门店区域不在维护中】");
                    return;
                }
                if (!areaEntityMap.containsKey(x.getAreaCode())) {
                    x.appendErrorValidateMsg("商超系统【" + x.getDirectId() + "门店区域编码" + x.getStoreCode() + "】的门店区域编码不在维护中");
                } else {
                    x.setAreaId(areaEntityMap.get(x.getAreaCode()).getId());
                }
            }
        });
    }


    /**
     * 准备备用检验数据
     *
     * @param directIdSet
     * @param areaCodeSet
     */
    private void spareCheckData(Set<String> directIdSet, Set<String> areaCodeSet, List<KmsDirectStoreImportVo> data) {
        this.spareDirectSystemData(directIdSet, data);
        this.spareAreaData(areaCodeSet, data);
    }


    /**
     * 组装 门店区域备用检验数据
     *
     * @param areaCodeSet
     */
    private void spareAreaData(Set<String> areaCodeSet, List<KmsDirectStoreImportVo> data) {
        if (CollectionUtils.isNotEmpty(areaCodeSet)) {
            List<KmsDirectStoreAreaEntity> kmsDirectStoreAreaEntities = kmsDirectStoreAreaMapper
                    .selectList(Wrappers.<KmsDirectStoreAreaEntity>lambdaQuery()
                            .in(KmsDirectStoreAreaEntity::getDsAreaCode, areaCodeSet)
                            .eq(KmsDirectStoreAreaEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode())
                            .eq(KmsDirectStoreAreaEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
            if (CollectionUtils.isEmpty(kmsDirectStoreAreaEntities)) {
                data.forEach(x -> {
                    x.appendErrorValidateMsg("【" + x.getAreaCode() + "】的门店区域不在维护中");
                });
            }
            kmsDirectStoreAreaEntities.forEach(x -> {
                Map<String, KmsDirectStoreAreaEntity> areaEntityMap = Maps.newHashMap();
                if (this.spareStoreAreaMap.containsKey(x.getDirectId())) {
                    areaEntityMap = this.spareStoreAreaMap.get(x.getDirectId());
                }
                areaEntityMap.put(x.getDsAreaCode(), x);
                this.spareStoreAreaMap.put(x.getDirectId(), areaEntityMap);
            });
        }
    }

    /**
     * 组装 商超系统备用检验数据
     *
     * @param directIdSet
     */
    private void spareDirectSystemData(Set<String> directIdSet, List<KmsDirectStoreImportVo> data) {
        if (CollectionUtils.isNotEmpty(directIdSet)) {
            List<KmsDirectSystemEntity> kmsDirectSystemEntities = kmsDirectSystemMapper
                    .selectList(Wrappers.<KmsDirectSystemEntity>lambdaQuery()
                            .eq(KmsDirectSystemEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode())
                            .in(KmsDirectSystemEntity::getId, directIdSet)
                            .eq(KmsDirectSystemEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
            if (CollectionUtils.isEmpty(kmsDirectSystemEntities)) {
                data.forEach(x -> {
                    x.appendErrorValidateMsg("【" + x.getDirectName() + "】的商超门店不在维护中");
                });
            }
            this.spareDirectSystemMap = kmsDirectSystemEntities.stream()
                    .collect(Collectors.toMap(KmsDirectSystemEntity::getId, Function.identity()));
        }
    }
}
