package com.biz.crm.excel.component.validator.kms.kaproduct;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.confadmin.model.KmsDirectOrderTypeEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.kaproduct.KmsTenantryDirectProductImportVo;
import com.biz.crm.kaproduct.model.KmsTenantryDirectProductEntity;
import com.biz.crm.kms.confadmin.mapper.KmsDirectOrderTypeMapper;
import com.biz.crm.kms.kaproduct.mapper.KmsTenantryDirectProductMapper;
import com.biz.crm.kms.tenantrydirectcustomerorg.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.mdm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.mdm.customerorg.entity.MdmCusOrgEntity;
import com.biz.crm.mdm.customerorg.mapper.MdmCusOrgMapper;
import com.biz.crm.mdm.product.entity.MdmProductEntity;
import com.biz.crm.mdm.product.mapper.MdmProductMapper;
import com.biz.crm.nebular.kms.kaproduct.req.KmsTenantryDirectProductReqVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectCustomerOrgReqVo;
import com.biz.crm.supermarket.model.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Sets;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author maoshen
 * @date 2021/5/25.
 */
@Slf4j
@Component("kmsTenantryDirectProductValidator")
public class KmsTenantryDirectProductValidator<M extends BaseMapper<T>, T> extends AbstractExcelImportValidator<KmsTenantryDirectProductMapper, KmsTenantryDirectProductEntity, KmsTenantryDirectProductImportVo> implements ExcelImportValidator<KmsTenantryDirectProductImportVo> {

    private List<KmsTenantryDirectCustomerOrgEntity> spareCustomerOrgList = Lists.newArrayList();

    private Map<String, KmsTenantryDirectCustomerOrgEntity> spareCustomerOrgMap = Maps.newHashMap();

    private Map<String, MdmCusOrgEntity> spareSellPartyMap = Maps.newHashMap();

    private Map<String, MdmProductEntity> spareProductMap = Maps.newHashMap();

    private Map<String, Set<String>> spareOrderTypeMap = Maps.newHashMap();

    private Set<String> systemIds = Sets.newHashSet();
    @Resource
    private KmsTenantryDirectCustomerOrgMapper kmsTenantryDirectCustomerOrgMapper;

    @Resource
    private MdmCustomerMsgMapper mdmCustomerMsgMapper;

    @Resource
    private MdmCusOrgMapper mdmCusOrgMapper;

    @Resource
    private MdmProductMapper mdmProductMapper;

    @Resource
    private KmsDirectOrderTypeMapper kmsDirectOrderTypeMapper;

    @Resource
    private KmsTenantryDirectProductMapper kmsTenantryDirectProductMapper;


    @Override
    public void validate(List<KmsTenantryDirectProductImportVo> data, DefaultImportContext context) {
        ConcurrentHashMap<String, Object> map = ThreadLocalUtil.get();
        map.put(GlobalParam.FUNCTION_CODE, "kms_on_product_table");
        map.put(GlobalParam.MENU_CODE, "CRM20210414000001468");
        ThreadLocalUtil.setUser(UserUtils.getUser());
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        //检验数据填写
        Set<String> bsCodeSet = Sets.newHashSet();
        Set<String> sellPartySet = Sets.newHashSet();
        Set<String> productCodeSet = Sets.newHashSet();
        Set<String> kaProductCodeSet = Sets.newHashSet();
        Map<String, KmsTenantryDirectProductImportVo> repeatWithoutWeekMap = Maps.newHashMap();
        Map<String, KmsTenantryDirectProductImportVo> repeatWithWeekMap = Maps.newHashMap();
        data.forEach(x -> {
            // 创建Id
            x.setId(UUIDGenerator.generate());
            if (StringUtils.isBlank(x.getBsDirectSystemCode())) {
                x.appendErrorValidateMsg("【直营体系不能为空】、");
            }
            if (StringUtils.isBlank(x.getSellPartyCode())) {
                x.appendErrorValidateMsg("【客户分类编码不能为空】、");
            }
            if (StringUtils.isBlank(x.getProductCode())) {
                x.appendErrorValidateMsg("【CRM产品信息编码不能为空】、");
            }
            if (StringUtils.isBlank(x.getKaProductCode())) {
                x.appendErrorValidateMsg("【客户产品编码不能为空】、");
            }
            if (StringUtils.isBlank(x.getIsDefault())) {
                x.appendErrorValidateMsg("【是否默认产品不能为空】、");
            }
            if (StringUtils.isBlank(x.getOrderType())) {
                x.appendErrorValidateMsg("【单据类型不能为空】、");
            }
            if (StringUtils.isBlank(x.getUnitCode())) {
                x.appendErrorValidateMsg("【CRM产品单位编码不能为空】、");
            }
            if (StringUtils.isBlank(x.getKaUnitCode())) {
                x.appendErrorValidateMsg("【商超产品单位名称不能为空】、");
            }
            if (x.getRatio() == null) {
                x.appendErrorValidateMsg("【单位转换比例系数不能为为空】、");
            }
            if (!GlobalWhetherEnum.YES.getCode().equals(x.getIsDefault())
                    && !GlobalWhetherEnum.NO.getCode().equals(x.getIsDefault())) {
                x.appendErrorValidateMsg("【是否默认产品只能填写Y/N】、");
            }
            bsCodeSet.add(x.getBsDirectSystemCode());
            sellPartySet.add(x.getSellPartyCode());
            productCodeSet.add(x.getProductCode());
            kaProductCodeSet.add(x.getKaProductCode());
            if (x.getTimeOfWeek() != null) {
                String repeatStr = x.getBsDirectSystemCode() + x.getProductCode()
                        + x.getSellPartyCode() + x.getKaProductCode() + x.getTimeOfWeek();
                if (repeatWithWeekMap.containsKey(repeatStr)) {
                    x.appendErrorValidateMsg("【该行excel数据重复】、");
                } else {
                    repeatWithWeekMap.put(repeatStr, x);
                }
            }
            if (x.getTimeOfWeek() == null) {
                String repeatStr = x.getBsDirectSystemCode() + x.getProductCode()
                        + x.getSellPartyCode() + x.getKaProductCode() + x.getOrderType();
                if (repeatWithoutWeekMap.containsKey(repeatStr)) {
                    x.appendErrorValidateMsg("【该行excel数据重复】、");
                } else {
                    repeatWithoutWeekMap.put(repeatStr, x);
                }
            }
            //校验是否已存在数据
            List<KmsTenantryDirectProductEntity> entitys = kmsTenantryDirectProductMapper.checkRepeat(x);
            if (CollectionUtil.listNotEmptyNotSizeZero(entitys)) {
                x.appendErrorValidateMsg("数据库已存在该数据!");
            }
        });

        // 准备备用检验数据
        this.buildSpareData(bsCodeSet, sellPartySet, productCodeSet);

        // 检验备用数据是否和 excel对应
        this.checkSpare(data);

        // 检验excel数据是否与数据库重复
        this.checkExistByDb(repeatWithoutWeekMap, repeatWithWeekMap, bsCodeSet, sellPartySet, productCodeSet, kaProductCodeSet, data);

    }

    private void checkExistByDb(Map<String, KmsTenantryDirectProductImportVo> repeatWithoutWeekMap,
                                Map<String, KmsTenantryDirectProductImportVo> repeatWithWeekMap,
                                Set<String> bsCodeSet,
                                Set<String> sellPartySet,
                                Set<String> productCodeSet,
                                Set<String> kaProductCodeSet,
                                List<KmsTenantryDirectProductImportVo> data) {
//        List<KmsTenantryDirectProductEntity> productEntities = kmsTenantryDirectProductMapper
//                .selectListForExcel(Wrappers.<KmsTenantryDirectProductEntity>lambdaQuery()
//                        .in(KmsTenantryDirectProductEntity::getBsDirectSystemCode, bsCodeSet)
//                        .in(KmsTenantryDirectProductEntity::getProductCode, productCodeSet)
//                        .in(KmsTenantryDirectProductEntity::getKaProductCode, kaProductCodeSet)
//                        .in(KmsTenantryDirectProductEntity::getSellPartyCode, sellPartySet)
//                        .eq(KmsTenantryDirectProductEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode())
//                        .eq(KmsTenantryDirectProductEntity::getCreateOrgCode, UserUtils.getUser().getOrgcode()));
        if (CollectionUtils.isEmpty(systemIds)) {
            data.forEach(x -> {
                x.appendErrorValidateMsg("【没有可用的直营体系】");
            });
            return;
        }
        KmsTenantryDirectProductReqVo reqVo = new KmsTenantryDirectProductReqVo();
        //reqVo.setBsDirectSystemCodeList(Lists.newArrayList(bsCodeSet));
        reqVo.setBsDirectSystemIdList(Lists.newArrayList(systemIds));
        reqVo.setSellPartyCodeList(Lists.newArrayList(sellPartySet));
        reqVo.setProductCodes(Lists.newArrayList(productCodeSet));
        reqVo.setKaProductCodes(Lists.newArrayList(kaProductCodeSet));
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        List<KmsTenantryDirectProductEntity> productEntities = kmsTenantryDirectProductMapper
                .selectListForExcel(reqVo);
        if (CollectionUtils.isEmpty(productEntities)) {
            return;
        }
        Map<String, KmsTenantryDirectProductEntity> checkWithoutWeekByDb = Maps.newHashMap();
        Map<String, KmsTenantryDirectProductEntity> checkWithWeekByDb = Maps.newHashMap();
        productEntities.forEach(x -> {
            if (x.getTimeOfWeek() == null) {
                checkWithoutWeekByDb.put(x.getBsDirectSystemCode() + x.getProductCode()
                        + x.getSellPartyCode() + x.getKaProductCode(), x);
            }
            if (x.getTimeOfWeek() != null) {
                checkWithWeekByDb.put(x.getBsDirectSystemCode() + x.getProductCode()
                        + x.getSellPartyCode() + x.getKaProductCode() + x.getTimeOfWeek(), x);
            }
        });
        repeatWithoutWeekMap.keySet().retainAll(checkWithoutWeekByDb.keySet());
        if (CollectionUtils.isNotEmpty(repeatWithoutWeekMap.keySet())) {
            data.forEach(x -> {
                if (repeatWithoutWeekMap.containsKey(x.getBsDirectSystemCode() + x.getProductCode()
                        + x.getSellPartyCode() + x.getKaProductCode() + x.getOrderType())) {
                    x.appendErrorValidateMsg("【该行的数据已存在】、");
                }
            });
        }
        repeatWithWeekMap.keySet().retainAll(checkWithWeekByDb.keySet());
        if (CollectionUtils.isNotEmpty(repeatWithWeekMap.keySet())) {
            data.forEach(x -> {
                if (repeatWithWeekMap.containsKey(x.getBsDirectSystemCode() + x.getProductCode()
                        + x.getSellPartyCode() + x.getKaProductCode() + x.getTimeOfWeek())) {
                    x.appendErrorValidateMsg("【该行的数据已存在】、");
                }
            });
        }
    }


    /**
     * 检验备用数据是否和 excel对应
     */
    private void checkSpare(List<KmsTenantryDirectProductImportVo> data) {
        Map<String, String> unitMap = DictUtil.dictMap("product_sale_unit");
        data.forEach(x -> {
            if (!this.spareCustomerOrgMap.containsKey(x.getBsDirectSystemCode())) {
                x.setDirectId(null);
                x.appendErrorValidateMsg("【直营体系编码" + x.getBsDirectSystemCode() + "的直营体系不在维护中】、");
            } else {
                KmsTenantryDirectCustomerOrgEntity entity = this.spareCustomerOrgMap.get(x.getBsDirectSystemCode());
                x.setBsDirectSystemId(entity.getId());
                x.setBsDirectSystemName(entity.getBsDirectSystemName());
                x.setDirectId(entity.getDirectId());
                this.systemIds.add(x.getBsDirectSystemId());
            }
            if (!this.spareSellPartyMap.containsKey(x.getSellPartyCode())) {
                x.appendErrorValidateMsg("【客户分类" + x.getSellPartyCode() + "不在维护中】、");
            } else {
                x.setSellPartyName(this.spareSellPartyMap.get(x.getSellPartyCode()).getCustomerOrgDesc());
            }
            if (!this.spareProductMap.containsKey(x.getProductCode())) {
                x.appendErrorValidateMsg("【CRM产品编码" + x.getProductCode() + "的产品不在维护中】、");
            } else {
                x.setProductName(this.spareProductMap.get(x.getProductCode()).getProductName());
            }
            if (this.spareOrderTypeMap.containsKey(x.getDirectId())) {
                if (!this.spareOrderTypeMap.get(x.getDirectId()).contains(x.getOrderType())) {
                    x.appendErrorValidateMsg("【单据类型" + x.getBsDirectSystemCode() + "、" + x.getOrderType() + "不可用】、");
                }
            } else {
                x.appendErrorValidateMsg("【该行没有可用的单据类型】、");
            }
            // 检验企业产品单位
//            if (!unitMap.containsKey(x.getUnitCode())) {
//                x.appendErrorValidateMsg("企业单位编码" + x.getUnitCode() + "的企业单位不存在");
//            }
//            x.setUnitName(unitMap.get(x.getUnitCode()));
        });
    }

    /**
     * 准备备用数据
     *
     * @param bsCodeSet
     */
    private void buildSpareData(Set<String> bsCodeSet, Set<String> sellPartySet, Set<String> productCodeSet) {
        if (CollectionUtils.isNotEmpty(bsCodeSet)) {
            this.spareCustomerOrgData(bsCodeSet);
        }
        if (CollectionUtils.isNotEmpty(productCodeSet)) {
            this.spareProductData(productCodeSet);
        }
        if (CollectionUtils.isNotEmpty(this.spareCustomerOrgList)) {
            Set<String> directIdCode = this.spareCustomerOrgList
                    .stream().map(KmsTenantryDirectCustomerOrgEntity::getDirectId)
                    .collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(directIdCode)) {
                throw new BusinessException("【单据类型不可用】、");
            }
            List<KmsDirectOrderTypeEntity> orderTypeEntities = kmsDirectOrderTypeMapper
                    .selectList(Wrappers.<KmsDirectOrderTypeEntity>lambdaQuery()
                            .eq(KmsDirectOrderTypeEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode())
                            .in(KmsDirectOrderTypeEntity::getDirectId, directIdCode));
            if (CollectionUtils.isEmpty(orderTypeEntities)) {
                throw new BusinessException("【没有可用单据类型】、");
            }
            Map<String, Set<String>> map = Maps.newHashMap();
            orderTypeEntities.forEach(x -> {
                if (map.containsKey(x.getDirectId())) {
                    Set<String> orderTypeSet = map.get(x.getDirectId());
                    orderTypeSet.add(x.getOrderType());
                    map.put(x.getDirectId(), orderTypeSet);
                } else {
                    Set<String> initOrderTypeSet = Sets.newHashSet();
                    initOrderTypeSet.add(x.getOrderType());
                    map.put(x.getDirectId(), initOrderTypeSet);
                }
            });
            this.spareOrderTypeMap = map;
        }
    }

    /**
     * 准备 企业产品信息备用数据
     *
     * @param productCodeSet
     */
    private void spareProductData(Set<String> productCodeSet) {
        List<String> productCodeList = Lists.newArrayList(productCodeSet);
        List<MdmProductEntity> mdmProductEntities = mdmProductMapper.selectList(Wrappers.<MdmProductEntity>lambdaQuery()
                .in(MdmProductEntity::getProductCode, productCodeList)
                .eq(MdmProductEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode())
                .eq(MdmProductEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode()));
        if (CollectionUtils.isNotEmpty(mdmProductEntities)) {
            this.spareProductMap = mdmProductEntities.stream().collect(Collectors
                    .toMap(MdmProductEntity::getProductCode, Function.identity()));
        }
    }

    /**
     * 准备 直营体系备用数据
     *
     * @param bsCodeSet
     */
    private void spareCustomerOrgData(Set<String> bsCodeSet) {
        KmsTenantryDirectCustomerOrgReqVo reqVo = new KmsTenantryDirectCustomerOrgReqVo();
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        reqVo.setBsDirectSystemCodeList(bsCodeSet);
        this.spareCustomerOrgList = kmsTenantryDirectCustomerOrgMapper.selectListForExcel(reqVo);
        if (CollectionUtils.isEmpty(spareCustomerOrgList)) {
            return;
        }
        this.spareCustomerOrgMap = this.spareCustomerOrgList.stream()
                .collect(Collectors.toMap(KmsTenantryDirectCustomerOrgEntity::getBsDirectSystemCode, Function.identity()));
    }
}