package com.biz.crm.excel.component.validator.kms.tenantrydirectaccount;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.tenantrydirectaccount.KmsTenantryDirectAccountImportVo;
import com.biz.crm.kms.config.KmsConfig;
import com.biz.crm.kms.tenantrydirectaccount.mapper.KmsTenantryDirectAccountMapper;
import com.biz.crm.kms.tenantrydirectcustomerorg.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.supermarket.model.KmsTenantryDirectAccountEntity;
import com.biz.crm.supermarket.model.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.util.AesEncoder;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Sets;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author maoshen
 * @date 2021/5/25.
 */
@Slf4j
@Component("kmsTenantryDirectAccountValidator")
public class KmsTenantryDirectAccountValidator<M extends BaseMapper<T>, T> extends AbstractExcelImportValidator<KmsTenantryDirectAccountMapper, KmsTenantryDirectAccountEntity, KmsTenantryDirectAccountImportVo> implements ExcelImportValidator<KmsTenantryDirectAccountImportVo> {

    @Resource
    private KmsTenantryDirectAccountMapper accountMapper;

    /**
     * 直营体系Mapper
     */
    @Resource
    private KmsTenantryDirectCustomerOrgMapper customerOrgMapper;
    /**
     * 加密密码最大长度
     */
    @Resource
    private KmsConfig kmsConfig;

    private static final Integer MAX_PASS_LENGTH = 32;

    @Override
    public void validate(List<KmsTenantryDirectAccountImportVo> data, DefaultImportContext context) {
        ConcurrentHashMap<String, Object> map = ThreadLocalUtil.get();
        map.put(GlobalParam.FUNCTION_CODE, "kms_customer_account_table");
        map.put(GlobalParam.MENU_CODE, "CRM20210414000001467");
        ThreadLocalUtil.setUser(UserUtils.getUser());
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        /*
         *检验填写准确
         * 检验数据重复
         */
        Set<String> deduplicationLoginAcc = Sets.newHashSet();
        Set<String> deduplicationCode = Sets.newHashSet();
        Map<String, String> dataMap = Maps.newHashMap();
        data.forEach(x -> {
            if (StringUtils.isBlank(x.getLoginAcc())) {
                x.appendErrorValidateMsg("【账号没有填写】、");
            }
            if (StringUtils.isBlank(x.getLoginPass())) {
                x.appendErrorValidateMsg("【登录密码没有填写】、");
            } else {
                x.setLoginPass(new AesEncoder(kmsConfig.getEncryptAesKey()).encode(x.getLoginPass()));
            }
            if (deduplicationLoginAcc.contains(x.getLoginAcc())) {
                x.appendErrorValidateMsg("【登录账号重复】、");
            }
            if (StringUtils.isBlank(x.getBsDirectSystemCode())) {
                x.appendErrorValidateMsg("【直营体系相关信息未填写】、");
            }
            deduplicationCode.add(x.getBsDirectSystemCode());
            dataMap.put(x.getLoginAcc(), x.getBsDirectSystemCode());
            deduplicationLoginAcc.add(x.getLoginAcc());
        });
        if (CollectionUtils.isEmpty(deduplicationCode)) {
            return;
        }
        List<KmsTenantryDirectCustomerOrgEntity> customerOrgEntities = customerOrgMapper.selectList(Wrappers
                        .<KmsTenantryDirectCustomerOrgEntity>lambdaQuery()
                        .in(KmsTenantryDirectCustomerOrgEntity::getBsDirectSystemCode, deduplicationCode)
                        .eq(KmsTenantryDirectCustomerOrgEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode())
                        .eq(KmsTenantryDirectCustomerOrgEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode())
                        .eq(KmsTenantryDirectCustomerOrgEntity::getCreateOrgCode, UserUtils.getUser().getOrgcode())
                //.eq(KmsTenantryDirectCustomerOrgEntity::getCreatePosCode, UserUtils.getUser().getPoscode())
        );
        if (CollectionUtils.isEmpty(customerOrgEntities)) {
            data.forEach(x -> {
                x.appendErrorValidateMsg("【" + x.getBsDirectSystemCode() + "】行的直营体系不在维护中");
            });
            return;
        }
        if (CollectionUtils.isEmpty(deduplicationLoginAcc)) {
            return;
        }
        // 检验登录账号和数据库是否重复
        LambdaQueryWrapper<KmsTenantryDirectAccountEntity> wrapper = Wrappers.<KmsTenantryDirectAccountEntity>lambdaQuery()
                .eq(KmsTenantryDirectAccountEntity::getCreateOrgCode, UserUtils.getUser().getOrgcode());
        List<KmsTenantryDirectAccountEntity> entityList = accountMapper.selectList(wrapper);
        if (CollectionUtils.isNotEmpty(entityList)) {
            Map<String, KmsTenantryDirectCustomerOrgEntity> customerOrgEntityMap = customerOrgEntities.stream()
                    .collect(Collectors.toMap(KmsTenantryDirectCustomerOrgEntity::getBsDirectSystemCode, Function.identity()));
            Set<String> loginAccByDb = entityList.stream().map(KmsTenantryDirectAccountEntity::getLoginAcc)
                    .collect(Collectors.toSet());
            data.forEach(x -> {
                if (loginAccByDb.contains(x.getLoginAcc())) {
                    x.appendErrorValidateMsg("【" + x.getLoginAcc() + "】的登录账号已存在");
                }
                if (customerOrgEntityMap.containsKey(x.getBsDirectSystemCode())) {
                    x.setBsDirectSystemId(customerOrgEntityMap.get(x.getBsDirectSystemCode()).getId());
                    x.setBsDirectSystemName(customerOrgEntityMap.get(x.getBsDirectSystemCode()).getBsDirectSystemName());
                } else {
                    x.appendErrorValidateMsg("【" + x.getBsDirectSystemCode() + "】的直营体系不在维护中");
                }
            });
        }
    }
}
