package com.biz.crm.excel.component.validator.kms.tenantrydirectcustomerorg;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.confadmin.model.KmsDirectSystemEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.tenantrydirectcustomerorg.KmsTenantryDirectCustomerOrgImportVo;
import com.biz.crm.kms.confadmin.mapper.KmsDirectSystemMapper;
import com.biz.crm.kms.tenantrydirectcustomerorg.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.mdm.customerorg.entity.MdmCusOrgEntity;
import com.biz.crm.mdm.customerorg.mapper.MdmCusOrgMapper;
import com.biz.crm.supermarket.model.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.util.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Sets;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author maoshen
 * @date 2021/5/25.
 */
@Slf4j
@Component("kmsTenantryDirectCustomerOrgValidator")
public class KmsTenantryDirectCustomerOrgValidator<M extends BaseMapper<T>, T> extends AbstractExcelImportValidator<KmsTenantryDirectCustomerOrgMapper, KmsTenantryDirectCustomerOrgEntity, KmsTenantryDirectCustomerOrgImportVo> implements ExcelImportValidator<KmsTenantryDirectCustomerOrgImportVo> {

    @Resource
    private KmsTenantryDirectCustomerOrgMapper customerOrgMapper;

    @Resource
    private MdmCusOrgMapper mdmCusOrgMapper;

    @Resource
    private KmsDirectSystemMapper systemMapper;

    private List<KmsTenantryDirectCustomerOrgImportVo> importVoList = Lists.newArrayList();

    private List<KmsTenantryDirectCustomerOrgEntity> updateEntities = Lists.newArrayList();

    @Override
    public void validate(List<KmsTenantryDirectCustomerOrgImportVo> data, DefaultImportContext context) {

        ConcurrentHashMap<String, Object> map = ThreadLocalUtil.get();
        map.put(GlobalParam.FUNCTION_CODE, "bs_direct_system_list");
        map.put(GlobalParam.MENU_CODE, "CRM20210519000001676");
        ThreadLocalUtil.setUser(UserUtils.getUser());
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        /*
         * 检验数据填写
         * 检验excel 数据重复
         * 编码不能重复
         * 直营体系
         */
        Set<String> systemCodeSet = Sets.newHashSet();
        Set<String> directNameSet = Sets.newHashSet();
        Set<String> cusOrgCodeSet = Sets.newHashSet();
        data.forEach(x -> {
            if (StringUtils.isBlank(x.getDirectName())) {
                x.appendErrorValidateMsg("【直营体系未填写】、");
            }
            if (StringUtils.isBlank(x.getBsDirectSystemCode())) {
                x.appendErrorValidateMsg("【直营体系编码不能为空】、");
            }
            if (StringUtils.isBlank(x.getBsDirectSystemName())) {
                x.appendErrorValidateMsg("【直营体系名称不能为空】、");
            }
            if (StringUtils.isBlank(x.getCustomerOrgCode())) {
                x.appendErrorValidateMsg("【客户组织信息不能为空】、");
            }
            if (systemCodeSet.contains(x.getBsDirectSystemCode())) {
                x.appendErrorValidateMsg("【" + x.getBsDirectSystemCode() + "】的编码重复、");
            }
            if (directNameSet.contains(x.getDirectName())) {
                x.appendErrorValidateMsg("【" + x.getDirectName() + "】的商超重复、");
            }
            if (StringUtils.isNotBlank(x.getCustomerOrgCode()) && StringUtils.isNotBlank(x.getBsDirectSystemCode())
                    && StringUtils.isNotBlank(x.getDirectName())) {
                cusOrgCodeSet.add(x.getCustomerOrgCode());
                systemCodeSet.add(x.getBsDirectSystemCode());
                directNameSet.add(x.getDirectName());
            }
        });
        // 检验商超系统
        if (CollectionUtils.isEmpty(directNameSet)) {
            return;
        }
        List<KmsDirectSystemEntity> systemEntityList = systemMapper.selectList(Wrappers.<KmsDirectSystemEntity>lambdaQuery()
                .in(KmsDirectSystemEntity::getDirectName, directNameSet));
        if (CollectionUtils.isEmpty(systemEntityList)) {
            data.forEach(x -> {
                x.appendErrorValidateMsg("【" + x.getDirectName() + "】的商超不在维护中、");
            });
            return;
        }
        Map<String, KmsDirectSystemEntity> systemEntityMap = systemEntityList.stream().collect(Collectors.toMap(KmsDirectSystemEntity::getDirectName, Function.identity()));
        data.forEach(x -> {
            if (systemEntityMap.containsKey(x.getDirectName())) {
                x.setDirectId(systemEntityMap.get(x.getDirectName()).getDirectName());
            } else {
                x.appendErrorValidateMsg("【" + x.getDirectName() + "】的商超不在维护中、");
            }
        });
        // 检验组织客户
        if (CollectionUtils.isEmpty(cusOrgCodeSet)) {
            return;
        }
        List<MdmCusOrgEntity> cusOrgEntities = mdmCusOrgMapper.selectList(Wrappers.<MdmCusOrgEntity>lambdaQuery()
                .in(MdmCusOrgEntity::getCustomerOrgCode, cusOrgCodeSet));
        if (CollectionUtils.isEmpty(cusOrgEntities)) {
            data.forEach(x -> {
                x.appendErrorValidateMsg("【" + x.getCustomerOrgCode() + "】的客户组织不在维护中、");
            });
            return;
        }
        Map<String, MdmCusOrgEntity> mdmCusOrgEntityMap = cusOrgEntities.stream()
                .collect(Collectors.toMap(MdmCusOrgEntity::getCustomerOrgCode, Function.identity()));
        // 检验账号
        List<KmsTenantryDirectCustomerOrgEntity> customerOrgEntities = customerOrgMapper
                .selectList(Wrappers.<KmsTenantryDirectCustomerOrgEntity>lambdaQuery()
                                .in(KmsTenantryDirectCustomerOrgEntity::getDirectId, systemEntityMap.keySet())
                                .eq(KmsTenantryDirectCustomerOrgEntity::getCreateOrgCode, UserUtils.getUser().getOrgcode())
                        //.eq(KmsTenantryDirectCustomerOrgEntity::getCreatePosCode, UserUtils.getUser().getPoscode())
                );
        List<KmsTenantryDirectCustomerOrgImportVo> vos = Lists.newArrayList();
        for (int i = 0; i < data.size(); i++) {
            KmsTenantryDirectCustomerOrgImportVo x = data.get(i);
            if (!mdmCusOrgEntityMap.containsKey(x.getCustomerOrgId())) {
                x.appendErrorValidateMsg("组织客户为【" + x.getCustomerOrgId() + "】不存在、");
            } else {
                x.setCustomerOrgCode(mdmCusOrgEntityMap.get(x.getCustomerOrgId()).getCustomerOrgCode());
                x.setCustomerOrgName(mdmCusOrgEntityMap.get(x.getCustomerOrgId()).getCustomerOrgName());
            }
            customerOrgEntities.forEach(y -> {
                if (x.getDirectId().equals(y.getDirectId())) {
                    if (y.getEnableStatus().equals(CrmEnableStatusEnum.DISABLE.getCode())
                            || !y.getDelFlag().equals(CrmDelFlagEnum.DELETE.getCode())) {
                        y.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                        y.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                        updateEntities.add(y);
                        vos.add(x);
                    }
                }
            });
        }
        this.updateBatchById(updateEntities);
        data.removeAll(vos);
    }
}
