package com.biz.crm.excel.component.validator.kms.tenantrydirectstore;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.confadmin.model.KmsDirectStoreAreaEntity;
import com.biz.crm.confadmin.model.KmsDirectStoreEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.tenantrydirectstore.KmsTenantryDirectStoreImportVo;
import com.biz.crm.kms.confadmin.mapper.KmsDirectStoreAreaMapper;
import com.biz.crm.kms.confadmin.mapper.KmsDirectStoreMapper;
import com.biz.crm.kms.tenantrydirectcustomerorg.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.kms.tenantrydirectstore.mapper.KmsTenantryDirectStoreMapper;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.mdm.terminal.entity.MdmTerminalEntity;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectCustomerOrgReqVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectStoreReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.supermarket.model.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.supermarket.model.KmsTenantryDirectStoreEntity;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author maoshen
 * @date 2021/4/27.
 */
@Slf4j
@Component("kmsTenantryDirectStoreValidator")
public class KmsTenantryDirectStoreValidator<M extends BaseMapper<T>, T> extends AbstractExcelImportValidator<KmsTenantryDirectStoreMapper, KmsTenantryDirectStoreEntity, KmsTenantryDirectStoreImportVo> implements ExcelImportValidator<KmsTenantryDirectStoreImportVo> {

    private Set<String> bsSystemIdsForExist = Sets.newHashSet();

    private Set<String> terminalCodesForExist = Sets.newHashSet();

    @Resource
    private KmsTenantryDirectStoreMapper kmsTenantryDirectStoreMapper;

    @Resource
    private KmsTenantryDirectCustomerOrgMapper kmsTenantryDirectCustomerOrgMapper;

    @Resource
    private MdmTerminalFeign mdmTerminalFeign;

    @Resource
    private MdmProductFeign mdmProductFeign;

    @Resource
    private KmsDirectStoreMapper kmsDirectStoreMapper;

    @Resource
    private KmsDirectStoreAreaMapper kmsDirectStoreAreaMapper;

    @Resource
    private MdmTerminalMapper mdmTerminalMapper;

    @Override
    public void validate(List<KmsTenantryDirectStoreImportVo> data, DefaultImportContext context) {
        ConcurrentHashMap<String, Object> map = ThreadLocalUtil.get();
        map.put(GlobalParam.FUNCTION_CODE, "kms_direct_stores_table");
        map.put(GlobalParam.MENU_CODE, "CRM20210419000001471");
        ThreadLocalUtil.setUser(UserUtils.getUser());
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        // 直营门店 直营体系，企业门店编码，直营门店编码三者重复才为重复
        // 获取直营门店现有的 list
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        List<KmsTenantryDirectStoreImportVo> needRemoveData = Lists.newArrayList();
        Set<String> deduplicationTerminalCode = Sets.newHashSet();
        Set<String> deduplicationDirectCode = Sets.newHashSet();
        Set<String> deduplicationStrings = Sets.newHashSet();
        Map<String, String> areaMap = Maps.newHashMap();
        data.forEach(x -> {
            if (StringUtils.isBlank(x.getBsDirectSystemCode())) {
                x.appendErrorValidateMsg("【直营体系编码未填写】、");
            }
            if (StringUtils.isBlank(x.getStoreCode())) {
                x.appendErrorValidateMsg("【关联商超门店编码未填写】、");
            }
            if (StringUtils.isBlank(x.getTerminalCode())) {
                x.appendErrorValidateMsg("【CRM门店编码未填写】、");
            }
            if (StringUtils.isBlank(x.getDimension())) {
                x.appendErrorValidateMsg("【维度未填写】、");
            }
            if (x.getTimeOfDay() == null) {
                x.setTimeOfDay(0);
            }
            if (StringUtils.isNotBlank(x.getStoreCode()) && StringUtils.isNotBlank(x.getTerminalCode())
                    && StringUtils.isNotBlank(x.getBsDirectSystemCode())) {
                if (deduplicationStrings.contains(x.getBsDirectSystemCode() + x.getStoreCode() + x.getTerminalCode() + x.getAreaCode())) {
                    x.appendErrorValidateMsg("【重复的excel行数据】、");
                }
                deduplicationStrings.add(x.getBsDirectSystemCode() + x.getStoreCode() + x.getTerminalCode() + x.getAreaCode());
                deduplicationDirectCode.add(x.getBsDirectSystemCode());
                deduplicationTerminalCode.add(x.getTerminalCode());
            }
        });
        if (CollectionUtils.isEmpty(deduplicationStrings)) {
            return;
        }
        checkDirectCusOrgAndTerminal(data, deduplicationTerminalCode, deduplicationDirectCode);
        // 检验excel数据和Db数据重复
        checkDuplicationByDb(deduplicationStrings, data);
    }

    /**
     * 检验excel数据和Db数据重复
     *
     * @param deduplicationStrings
     */
    private void checkDuplicationByDb(Set<String> deduplicationStrings, List<KmsTenantryDirectStoreImportVo> data) {
        KmsTenantryDirectStoreReqVo storeReqVo = new KmsTenantryDirectStoreReqVo();
        storeReqVo.setBsDirectSystemIdList(Lists.newArrayList(this.bsSystemIdsForExist));
        storeReqVo.setTerminalCodes(Lists.newArrayList(this.terminalCodesForExist));
        storeReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        List<KmsTenantryDirectStoreEntity> entities = kmsTenantryDirectStoreMapper.selectListByCompetence(storeReqVo);
        Set<String> duplicationStringsByDb = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(entities)) {
            entities.forEach(x -> {
                if (StringUtils.isNotBlank(x.getBsDirectSystemId())
                        && StringUtils.isNotBlank(x.getStoreId())
                        && StringUtils.isNotBlank(x.getTerminalCode())) {
                    duplicationStringsByDb.add(x.getBsDirectSystemId() + x.getStoreId() + x.getTerminalCode());
                }
            });
            data.forEach(x -> {
                if (duplicationStringsByDb.contains(x.getBsDirectSystemId() + x.getStoreId() + x.getTerminalCode())) {
                    x.appendErrorValidateMsg("该数据已存在");
                }
            });
        }
    }

    /**
     * 检验直营体系和企业门店
     *
     * @param data
     * @param deduplicationTerminalCode
     * @param deduplicationDirectCode
     */
    private void checkDirectCusOrgAndTerminal(List<KmsTenantryDirectStoreImportVo> data, Set<String> deduplicationTerminalCode, Set<String> deduplicationDirectCode) {
        // 直营体系数据检验
        KmsTenantryDirectCustomerOrgReqVo customerOrgReqVo = new KmsTenantryDirectCustomerOrgReqVo();
        customerOrgReqVo.setBsDirectSystemCodeList(deduplicationDirectCode);
        customerOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        customerOrgReqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        List<KmsTenantryDirectCustomerOrgEntity> customerOrgEntities = kmsTenantryDirectCustomerOrgMapper.selectListForExcel(customerOrgReqVo);
        if (CollectionUtils.isEmpty(customerOrgEntities)) {
            for (KmsTenantryDirectStoreImportVo item :
                    data) {
                item.appendErrorValidateMsg("【直营体系不在维护中】、");
            }
            return;
        }
        // 用于对比直营体系并赋值直营体系名称和id
        Map<String, KmsTenantryDirectCustomerOrgEntity> customerOrgEntityMap = customerOrgEntities.stream()
                .collect(Collectors.toMap(KmsTenantryDirectCustomerOrgEntity::getBsDirectSystemCode, Function.identity()));
        // 企业门店数据检验
//        MdmTerminalVo mdmTerminalVo = new MdmTerminalVo();
//        mdmTerminalVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
//        mdmTerminalVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
//        mdmTerminalVo.setTerminalCodeList(new ArrayList<>(deduplicationTerminalCode));
//        mdmTerminalVo.setPageSize(data.size());
//        List<MdmTerminalVo> terminalVos = ApiResultUtil.objResult(mdmTerminalFeign.listCondition(mdmTerminalVo), true);
        List<MdmTerminalEntity> terminalVos = mdmTerminalMapper.selectList(Wrappers.<MdmTerminalEntity>lambdaQuery()
                .eq(MdmTerminalEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode())
                .eq(MdmTerminalEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode())
                .in(MdmTerminalEntity::getTerminalCode, deduplicationTerminalCode));
        // 用于对比企业门店并赋值企业门店名称
        Map<String, MdmTerminalEntity> terminalMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(terminalVos)) {
            terminalMap = terminalVos.stream()
                    .collect(Collectors.toMap(MdmTerminalEntity::getTerminalCode, Function.identity()));
        }
        Map<String, MdmTerminalEntity> finalTerminalVoMap = terminalMap;
        //查询企业商品
        List<String> productCodeList = data.stream().filter(o -> !org.springframework.util.StringUtils.isEmpty(o.getProductCode()))
                .map(KmsTenantryDirectStoreImportVo::getProductCode).distinct().collect(Collectors.toList());
        List<MdmProductRespVo> mdmProductRespVos = org.springframework.util.CollectionUtils.isEmpty(productCodeList) ? Lists.newArrayList() :
                ApiResultUtil.objResult(mdmProductFeign.queryBatchByProductCodeList(productCodeList));
        Map<String, MdmProductRespVo> productMap = mdmProductRespVos.stream()
                .collect(Collectors.toMap(MdmProductRespVo::getProductCode, Function.identity()));

        data.forEach(x -> {
            if (!customerOrgEntityMap.containsKey(x.getBsDirectSystemCode())) {
                x.appendErrorValidateMsg("【" + x.getBsDirectSystemCode() + "】的直营体系不在维护中、");
            } else {
                KmsTenantryDirectCustomerOrgEntity customerOrgEntity = customerOrgEntityMap.get(x.getBsDirectSystemCode());
                x.setBsDirectSystemId(customerOrgEntity.getId());
                x.setBsDirectSystemName(customerOrgEntity.getBsDirectSystemName());
                x.setDirectId(customerOrgEntity.getDirectId());
                this.bsSystemIdsForExist.add(x.getBsDirectSystemId());
            }
            if (!finalTerminalVoMap.containsKey(x.getTerminalCode())) {
                x.appendErrorValidateMsg("【" + x.getTerminalCode() + "】的企业门店不在维护中、");
            } else {
                x.setTerminalName(finalTerminalVoMap.get(x.getTerminalCode()).getTerminalName());
                this.terminalCodesForExist.add(x.getTerminalCode());
            }
            List<KmsDirectStoreAreaEntity> areaEntities = kmsDirectStoreAreaMapper
                    .selectList(Wrappers.<KmsDirectStoreAreaEntity>lambdaQuery()
                            .eq(KmsDirectStoreAreaEntity::getDirectId, x.getDirectId()));
            LambdaQueryWrapper<KmsDirectStoreEntity> wrapper = Wrappers.<KmsDirectStoreEntity>lambdaQuery()
                    .eq(KmsDirectStoreEntity::getStoreCode, x.getStoreCode())
                    .eq(KmsDirectStoreEntity::getDirectId, x.getDirectId())
                    .eq(KmsDirectStoreEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode())
                    .eq(KmsDirectStoreEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode());
            if (StringUtils.isNotBlank(x.getAreaCode())) {
                if (CollectionUtils.isNotEmpty(areaEntities)) {
                    Map<String, String> stringStringMap = areaEntities.stream().collect(Collectors
                            .toMap(KmsDirectStoreAreaEntity::getDsAreaCode, KmsDirectStoreAreaEntity::getId));
                    if (stringStringMap.containsKey(x.getAreaCode())) {
                        x.setAreaId(stringStringMap.get(x.getAreaCode()));
                        wrapper.eq(KmsDirectStoreEntity::getAreaId, x.getAreaId());
                        List<KmsDirectStoreEntity> entities = kmsDirectStoreMapper.selectList(wrapper);
                        if (CollectionUtils.isEmpty(entities)) {
                            x.appendErrorValidateMsg("直营体系【" + x.getBsDirectSystemCode() + "、" + x.getStoreCode() + "】的客户门店不在维护中、");
                        } else {
                            x.setStoreName(entities.get(0).getStoreName());
                            x.setStoreId(entities.get(0).getId());
                        }
                    } else {
                        x.appendErrorValidateMsg("【商超区域不可用】、");
                    }
                } else {
                    x.appendErrorValidateMsg("【商超区域不可用】、");
                }
            }
            if (StringUtils.isBlank(x.getAreaCode())) {
                List<KmsDirectStoreEntity> entities = kmsDirectStoreMapper.selectList(wrapper);
                if (CollectionUtils.isEmpty(entities)) {
                    x.appendErrorValidateMsg("直营体系【" + x.getBsDirectSystemCode() + "、" + x.getStoreCode() + "】的客户门店不在维护中、");
                } else {
                    x.setStoreName(entities.get(0).getStoreName());
                    x.setStoreId(entities.get(0).getId());
                }
            }
            //商品
            if (!org.springframework.util.StringUtils.isEmpty(x.getProductCode())) {
                MdmProductRespVo mdmProductRespVo = productMap.get(x.getProductCode());
                if (ObjectUtils.isEmpty(mdmProductRespVo)) {
                    x.appendErrorValidateMsg("商品编码【" + x.getProductCode() + "】不存在、");
                } else {
                    x.setProductId(mdmProductRespVo.getId());
                    x.setProductName(mdmProductRespVo.getProductName());
                }
            }
        });
    }
}
