package com.biz.crm.excel.component.validator.kms.totalhouse;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.totalwarehouse.KmsTotalWareHouseStoreImportVo;
import com.biz.crm.kaproduct.model.KmsTenantryDirectProductEntity;
import com.biz.crm.kms.confadmin.mapper.KmsDirectStoreMapper;
import com.biz.crm.kms.kaproduct.mapper.KmsTenantryDirectProductMapper;
import com.biz.crm.kms.tenantrydirectcustomerorg.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.kms.tenantrydirectstore.mapper.KmsTenantryDirectStoreMapper;
import com.biz.crm.kms.totalwarehouse.mapper.KmsTotalWarehouseStoreMapper;
import com.biz.crm.nebular.kms.kaproduct.req.KmsTenantryDirectProductReqVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectCustomerOrgReqVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectStoreReqVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTotalWarehouseStoreReqVo;
import com.biz.crm.supermarket.model.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.supermarket.model.KmsTenantryDirectStoreEntity;
import com.biz.crm.supermarket.model.KmsTotalWarehouseStoreEntity;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * @author maoshen
 * @date 2021/6/28.
 */
@Slf4j
@Component("kmsTotalWarehouseStoreValidator")
public class KmsTotalWarehouseStoreValidator<M extends BaseMapper<T>, T> extends AbstractExcelImportValidator<KmsTotalWarehouseStoreMapper, KmsTotalWarehouseStoreEntity, KmsTotalWareHouseStoreImportVo> implements ExcelImportValidator<KmsTotalWareHouseStoreImportVo> {

    private Set<String> bsCodeSet = Sets.newHashSet();

    private Set<String> bsIdSet = Sets.newHashSet();

    private Set<String> terminalCodeSet = Sets.newHashSet();

    private Set<String> storeAndBsCodeSet = Sets.newHashSet();

    private Set<String> productIds = Sets.newHashSet();

    @Resource
    private KmsTenantryDirectCustomerOrgMapper kmsTenantryDirectCustomerOrgMapper;

    @Resource
    private KmsTenantryDirectProductMapper kmsTenantryDirectProductMapper;

    @Resource
    private KmsTotalWarehouseStoreMapper kmsTotalWarehouseStoreMapper;

    @Resource
    private KmsTenantryDirectStoreMapper kmsTenantryDirectStoreMapper;

    @Resource
    private KmsDirectStoreMapper kmsDirectStoreMapper;

    @Override
    public void validate(List<KmsTotalWareHouseStoreImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        ConcurrentHashMap<String, Object> map = ThreadLocalUtil.get();
        map.put(GlobalParam.FUNCTION_CODE, "warehouse_store_list");
        map.put(GlobalParam.MENU_CODE, "CRM20210629000001905");
        ThreadLocalUtil.setUser(UserUtils.getUser());
        validateNotEmpty(data);
        validateCusOrg(data);
        validateDirectStore(data);
        validateProduct(data);
        convertData(data);
        validateByDb(data);
    }

    /**
     * 检验物料
     *
     * @param data
     */
    private void validateProduct(List<KmsTotalWareHouseStoreImportVo> data) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        Set<String> kaProductCode = Sets.newHashSet();
        Set<String> productCode = Sets.newHashSet();
        //Set<String> bsIdSet = Sets.newHashSet();
        data.forEach(x -> {
            if (StringUtils.isNotBlank(x.getProductCode())) {
                productCode.add(x.getProductCode());
            }
        });
        KmsTenantryDirectProductReqVo reqVo = new KmsTenantryDirectProductReqVo();
        reqVo.setProductCodes(Lists.newArrayList(productCode));
        reqVo.setBsDirectSystemIdList(Lists.newArrayList(bsIdSet));
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        List<KmsTenantryDirectProductEntity> productEntities = kmsTenantryDirectProductMapper.selectListForExcel(reqVo);
        if (CollectionUtils.isEmpty(productEntities)) {
            data.forEach(x -> {
                if (StringUtils.isNotBlank(x.getProductCode())) {
                    x.appendErrorValidateMsg("【物料信息】不在维护中、");
                }
            });
        }
        Map<String, List<KmsTenantryDirectProductEntity>> map = Maps.newHashMap();
        productEntities.forEach(x -> {
            String mapKey = x.getBsDirectSystemId() + x.getProductCode();
            if (map.containsKey(mapKey)) {
                map.get(mapKey).add(x);
            } else {
                map.put(mapKey, Lists.newArrayList(x));
            }
        });
        data.forEach(x -> {
            if (StringUtils.isNotBlank(x.getProductCode())) {
                if (!map.containsKey(x.getBsDirectSystemId() + x.getProductCode())) {
                    x.appendErrorValidateMsg("【物料信息】不在维护中、");
                } else {
                    List<KmsTenantryDirectProductEntity> products = map
                            .get(x.getBsDirectSystemId() + x.getProductCode());
                    x.setKaProductCode(products.get(0).getId());
                    x.setDirectProductId(products.get(0).getId());
                    x.setProductName(products.get(0).getProductName());
                }
            }

        });
    }

    /**
     * 检验数据库存在
     *
     * @param data
     */
    private void validateByDb(List<KmsTotalWareHouseStoreImportVo> data) {
        if (CollectionUtils.isEmpty(bsIdSet) || CollectionUtils.isEmpty(terminalCodeSet)) {
            return;
        }
        KmsTotalWarehouseStoreReqVo reqVo = new KmsTotalWarehouseStoreReqVo();
        reqVo.setBsDirectSystemIdList(Lists.newArrayList(bsIdSet));
        reqVo.setTerminalCodeList(Lists.newArrayList(terminalCodeSet));
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        List<KmsTotalWarehouseStoreEntity> entities = kmsTotalWarehouseStoreMapper.selectListWithDataPurview(reqVo);
        if (CollectionUtils.isNotEmpty(entities)) {
            Map<String, List<KmsTotalWarehouseStoreEntity>> map = Maps.newHashMap();
            entities.forEach(x -> {
                if (map.containsKey(x.getBsDirectSystemId() + x.getTerminalCode() + x.getProductType())) {
                    map.get(x.getBsDirectSystemId() + x.getTerminalCode() + x.getProductType()).add(x);
                } else {
                    map.put(x.getBsDirectSystemId() + x.getTerminalCode() + x.getProductType(), Lists.newArrayList(x));
                }
            });
            data.forEach(x -> {
                if (map.containsKey(x.getBsDirectSystemId() + x.getTerminalCode() + x.getProductType())) {
                    List<KmsTotalWarehouseStoreEntity> entityList = map.get(x.getBsDirectSystemId() + x.getTerminalCode() + x.getProductType());
                    if (CollectionUtils.isEmpty(entityList)) {
                        return;
                    }
                    if (StringUtils.isBlank(entityList.get(0).getProductCode())) {
                        x.appendErrorValidateMsg("【该行数据已存在】");
                        return;
                    }
                    Set<String> productCodeSet = entityList.stream()
                            .map(KmsTotalWarehouseStoreEntity::getProductCode).collect(Collectors.toSet());
                    if (StringUtils.isBlank(x.getProductCode())) {
                        x.appendErrorValidateMsg("【该行数据已存在】");
                    }
                    if (StringUtils.isNotBlank(x.getProductCode())) {
                        if (productCodeSet.contains(x.getProductCode())) {
                            x.appendErrorValidateMsg("【该行数据已存在】");
                        }
                    }
                }
            });
        }

    }

    /**
     * 检验填写
     *
     * @param data
     */
    private void validateNotEmpty(List<KmsTotalWareHouseStoreImportVo> data) {
        Map<String, Integer> storeAndBsMap = Maps.newHashMap();
        Map<String, Integer> storeAndBsMapWithoutProduct = Maps.newHashMap();
        Map<String, List<Integer>> map = Maps.newHashMap();
        AtomicReference<Integer> rowNumber = new AtomicReference<>();
        rowNumber.set(2);
        data.forEach(x -> {
            if (StringUtils.isBlank(x.getBsDirectSystemCode())) {
                x.appendErrorValidateMsg("第" + rowNumber.get() + "行的【直营体系未填写】、");
            }
            if (StringUtils.isBlank(x.getTerminalCode())) {
                x.appendErrorValidateMsg("第" + rowNumber.get() + "行的【送达方信息未填写】、");
            }
            // 产品类型 暂不做数据检验
            if (StringUtils.isBlank(x.getProductTypeDesc())) {
                x.appendErrorValidateMsg("第" + rowNumber.get() + "行的【产品类型未填写】、");
            }
            x.setProductType(x.getProductTypeDesc());
            if (StringUtils.isNotBlank(x.getTerminalCode()) ||
                    StringUtils.isNotBlank(x.getBsDirectSystemCode()) ||
                    StringUtils.isNotBlank(x.getProductTypeDesc())) {
                bsCodeSet.add(x.getBsDirectSystemCode());
                terminalCodeSet.add(x.getTerminalCode());
                storeAndBsCodeSet.add(x.getBsDirectSystemCode() + x.getTerminalCode());
                //terminalCodeSet.add(x.getTerminalCode());
                if (StringUtils.isBlank(x.getProductCode())) {
                    if (storeAndBsMapWithoutProduct.containsKey(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductType())) {
                        x.appendErrorValidateMsg("【直营体系和送达方信息】与"
                                + storeAndBsMapWithoutProduct.get(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductType()).toString() + "行重复、");
                    } else {
                        if (map.containsKey(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductType())) {
                            x.appendErrorValidateMsg("【第" + map.get(x.getBsDirectSystemCode()
                                    + x.getTerminalCode() + x.getProductType()).toString() + "行已经维护个别物料的大仓】、");
                        } else {
                            storeAndBsMapWithoutProduct.put(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductType(), rowNumber.get());
                        }

                    }
                }
                if (StringUtils.isNotBlank(x.getProductCode())) {
                    if (storeAndBsMap.containsKey(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductCode() + x.getProductType())) {
                        x.appendErrorValidateMsg("【直营体系和送达方信息】与"
                                + storeAndBsMap.get(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductCode() + x.getProductType()).toString() + "行重复、");
                    } else {
                        if (storeAndBsMapWithoutProduct.containsKey(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductType())) {
                            x.appendErrorValidateMsg("【第" + storeAndBsMapWithoutProduct.get(x.getBsDirectSystemCode()
                                    + x.getTerminalCode() + x.getProductType()) + "行已经维护全部物料的大仓】、");
                        } else {
                            storeAndBsMap.put(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductCode() + x.getProductType(), rowNumber.get());
                            if (map.containsKey(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductType())) {
                                map.get(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductType()).add(rowNumber.get());
                            } else {
                                List<Integer> list = Lists.newArrayList(rowNumber.get());
                                map.put(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductType(), list);
                            }
                        }
                    }
                }
            }
            rowNumber.getAndSet(rowNumber.get() + 1);
        });
    }

    /**
     * 检验直营体系
     *
     * @param data
     */
    private void validateCusOrg(List<KmsTotalWareHouseStoreImportVo> data) {
        if (CollectionUtils.isEmpty(this.bsCodeSet)) {
            data.forEach(x -> {
                x.appendErrorValidateMsg("【直营体系" + x.getBsDirectSystemCode() + "】不在维护中、");
            });
        }
        KmsTenantryDirectCustomerOrgReqVo reqVo = new KmsTenantryDirectCustomerOrgReqVo();
        reqVo.setBsDirectSystemCodeList(Lists.newArrayList(this.bsCodeSet));
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        List<KmsTenantryDirectCustomerOrgEntity> customerOrgEntities = kmsTenantryDirectCustomerOrgMapper
                .selectListForExcel(reqVo);
        if (CollectionUtils.isEmpty(customerOrgEntities)) {
            data.forEach(x -> {
                x.appendErrorValidateMsg("【直营体系" + x.getBsDirectSystemCode() + "】不在维护中、");
            });
            return;
        }
        Map<String, KmsTenantryDirectCustomerOrgEntity> map = customerOrgEntities.stream()
                .collect(Collectors.toMap(KmsTenantryDirectCustomerOrgEntity::getBsDirectSystemCode, Function.identity()));
        data.forEach(x -> {
            if (map.containsKey(x.getBsDirectSystemCode())) {
                x.setBsDirectSystemId(map.get(x.getBsDirectSystemCode()).getId());
                x.setBsDirectSystemName(map.get(x.getBsDirectSystemCode()).getBsDirectSystemName());
                x.setDirectId(map.get(x.getBsDirectSystemCode()).getDirectId());
                bsIdSet.add(x.getBsDirectSystemId());
            } else {
                x.appendErrorValidateMsg("直营体系【" + x.getBsDirectSystemCode() + "】不在维护中、");
            }
        });
    }

    /**
     * 送达方检验
     *
     * @param data
     */
    private void validateDirectStore(List<KmsTotalWareHouseStoreImportVo> data) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        KmsTenantryDirectStoreReqVo reqVo = new KmsTenantryDirectStoreReqVo();
        reqVo.setTerminalCodes(Lists.newArrayList(terminalCodeSet));
        reqVo.setBsDirectSystemIdList(Lists.newArrayList(bsIdSet));
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        List<KmsTenantryDirectStoreEntity> entities = kmsTenantryDirectStoreMapper.selectListByCompetence(reqVo);
        if (CollectionUtils.isEmpty(entities)) {
            data.forEach(x -> {
                x.appendErrorValidateMsg("【送达方" + x.getTerminalCode() + "】不在维护中");
            });
            return;
        }
        Map<String, List<KmsTenantryDirectStoreEntity>> map = Maps.newHashMap();
        entities.forEach(x -> {
            if (map.containsKey(x.getBsDirectSystemId() + x.getTerminalCode())) {
                map.get(x.getBsDirectSystemId() + x.getTerminalCode()).add(x);
            } else {
                map.put(x.getBsDirectSystemId() + x.getTerminalCode(), Lists.newArrayList(x));
            }
        });
        data.forEach(x -> {
            if (map.containsKey(x.getBsDirectSystemId() + x.getTerminalCode())) {
                List<KmsTenantryDirectStoreEntity> entityList = map.get(x.getBsDirectSystemId() + x.getTerminalCode());
                x.setDirectStoreId(entityList.get(0).getId());
                x.setTerminalName(entityList.get(0).getTerminalName());
            } else {
                x.appendErrorValidateMsg("送达方【" + x.getTerminalCode() + "】不在维护中、");
            }
        });
    }

    /**
     * 转换数据
     *
     * @param data
     */
    private void convertData(List<KmsTotalWareHouseStoreImportVo> data) {
    }
}
