package com.biz.crm.excel.component.validator.mall;

import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mall.MallDeliveryImportVo;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;

/**
 * @author zwk
 * @date 2021/9/17
 * @description TODO
 **/
@Component("mallDeliveryValidator")
public class MallDeliveryValidator implements ExcelImportValidator<MallDeliveryImportVo> {
    @Override
    public void validate(List<MallDeliveryImportVo> data, DefaultImportContext context) {
        data.forEach(vo -> {
            this.validate(vo.getOrderCode(),vo,"订单编号不能为空");
            this.validate(vo.getCompanyName(),vo,"快递名称不能为空");
            this.validate(vo.getDeliveryCode(),vo,"快递编号不能为空");
        });
    }
    /**
     * 校验单个字段非空
     * @param value
     * @param li
     * @param msg
     */
    private void validate(Object value, MallDeliveryImportVo li, String msg) {
        if (Objects.isNull(value) || Objects.equals("", value)) {
            li.appendErrorValidateMsg(msg);
        }
    }
}
