package com.biz.crm.excel.component.validator.mdm.availablelistrule;

import com.biz.crm.eunm.dms.AvailableListRuleEunm;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.availablelistrule.AvailableRuleImportVo;
import com.biz.crm.mdm.availablelistrule.AvailableListRuleFeign;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

/**
 * @Author: chenrong
 * @Date: 2021/3/18 10:24
 */
@Component("availableRuleValidator")
public class AvailableRuleValidator implements ExcelImportValidator<AvailableRuleImportVo> {

  @Resource
  private AvailableListRuleFeign availableListRuleFeign;

  /**
   * 导入校验方法
   * 1、校验编码非空和重复
   * 2、校验可购规则维度，并修正数据
   * 3、校验可购规则商品类型，并修正数据
   * @param data
   * @param context
   * @return
   */
  @Override
  public void validate(List<AvailableRuleImportVo> data, DefaultImportContext context) {
    Set<String> codes = data.stream().collect(Collectors.groupingBy(AvailableRuleImportVo::getCode)).keySet();
    Map<String, Boolean> exists = availableListRuleFeign.findExistByCodes(Lists.newArrayList(codes)).getResult();
    data.forEach(d -> {
      //1、
      if(StringUtils.isEmpty(d.getCode())) {
        d.appendErrorValidateMsg("可购编码不能为空");
      }
      for (AvailableRuleImportVo da : data) {
        if(da != d && Objects.equals(da.getCode(), d.getCode())) {
          d.appendErrorValidateMsg("可购规则编码：【".concat(d.getCode()).concat("】重复，请检查"));
          break;
        }
      }
      if(exists.get(d.getCode()) != null && exists.get(d.getCode())) {
        d.appendErrorValidateMsg("可购编码【".concat(d.getCode()).concat("】已存在"));
      }
      AvailableListRuleEunm.Dimension dimension = AvailableListRuleEunm.Dimension.getByCode(d.getDimension());
      //2、
      switch (dimension) {
        case CUS:
          if(StringUtils.isEmpty(d.getCusCode())) {
            d.appendErrorValidateMsg("维度类型为客户时，客户编码不能为空");
          }
          if(StringUtils.isEmpty(d.getCusName())) {
            d.appendErrorValidateMsg("维度类型为客户时，客户名称不能为空");
          }
          d.setOrgCode(null);
          d.setOrgName(null);
          d.setTerminalCode(null);
          d.setTerminalName(null);
          d.setTerminalChannelCode(null);
          d.setTerminalChannelName(null);
          d.setTerminalOrgCode(null);
          d.setTerminalOrgName(null);
          break;
        case CUSORG:
          if(StringUtils.isEmpty(d.getOrgCode())) {
            d.appendErrorValidateMsg("维度类型为客户组织时，组织编码不能为空");
          }
          if(StringUtils.isEmpty(d.getOrgName())) {
            d.appendErrorValidateMsg("维度类型为客户组织时，组织名称不能为空");
          }
          d.setCusCode(null);
          d.setOrgName(null);
          d.setCusChannelCode(null);
          d.setCusChannelName(null);
          d.setTerminalCode(null);
          d.setTerminalName(null);
          d.setTerminalChannelCode(null);
          d.setTerminalChannelName(null);
          d.setTerminalOrgCode(null);
          d.setTerminalOrgName(null);
          break;
        case TERMINAL:
          if(StringUtils.isEmpty(d.getTerminalCode())) {
            d.appendErrorValidateMsg("维度类型为终端时，终端编码不能为空");
          }
          if(StringUtils.isEmpty(d.getTerminalName())) {
            d.appendErrorValidateMsg("维度类型为终端时，组织名称不能为空");
          }
          d.setCusCode(null);
          d.setCusName(null);
          d.setCusChannelCode(null);
          d.setCusChannelName(null);
          d.setOrgCode(null);
          d.setOrgName(null);
          d.setTerminalOrgCode(null);
          d.setTerminalOrgName(null);
          break;
        case TERMINALORG:
          if(StringUtils.isEmpty(d.getTerminalOrgCode())) {
            d.appendErrorValidateMsg("维度类型为终端组织时，终端组织编码不能为空");
          }
          if(StringUtils.isEmpty(d.getTerminalOrgName())) {
            d.appendErrorValidateMsg("维度类型为终端组织时，组织名称不能为空");
          }
          d.setCusCode(null);
          d.setCusName(null);
          d.setCusChannelCode(null);
          d.setCusChannelName(null);
          d.setOrgCode(null);
          d.setOrgName(null);
          d.setTerminalCode(null);
          d.setTerminalName(null);
          d.setTerminalChannelCode(null);
          d.setTerminalChannelName(null);
          break;
        default: break;
      }
      //3、
      if(CommonConstant.GLOBAL.YesOrNo.Y.getItemCode().equals(d.getProductLevelFlag())) {
        if(StringUtils.isEmpty(d.getProductLevelCode())) {
          d.appendErrorValidateMsg("商品类型为商品层级时，商品层级编码不能为空");
        }
        if(StringUtils.isEmpty(d.getProductLevelName())) {
          d.appendErrorValidateMsg("商品类型为商品层级时，商品层级名称不能为空");
        }
        d.setGoodsCode(null);
        d.setGoodsName(null);
      } else {
        if(StringUtils.isEmpty(d.getGoodsCode())) {
          d.appendErrorValidateMsg("商品类型为商品时，商品编码不能为空");
        }
        if(StringUtils.isEmpty(d.getGoodsName())) {
          d.appendErrorValidateMsg("商品类型为商品时，商品名称不能为空");
        }
        d.setProductLevelCode(null);
        d.setProductLevelName(null);
      }
    });
  }
}
