package com.biz.crm.excel.component.validator.mdm.bpmrole;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.bpmrole.MdmBpmRoleImportVo;
import com.biz.crm.mdm.bpmrple.entity.MdmBpmRoleEntity;
import com.biz.crm.mdm.bpmrple.mapper.MdmBpmRoleMapper;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 流程角色导入校验
 *
 * @author Tao.Chen
 * @date 2021-01-04 20:46:13
 */
@Slf4j
@Component("mdmBpmRoleImportValidator")
public class MdmBpmRoleImportValidator <M extends BaseMapper<T>, T> extends AbstractExcelImportValidator<MdmBpmRoleMapper, MdmBpmRoleEntity, MdmBpmRoleImportVo> implements ExcelImportValidator<MdmBpmRoleImportVo> {

    @Resource
    private MdmBpmRoleMapper mdmBpmRoleMapper;

    @Override
    public void validate(List<MdmBpmRoleImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        validateRequired(data);
    }

    protected void validateRequired(List<MdmBpmRoleImportVo> originList) {

        Set<String> roleCodeSet = new HashSet<>(16);
        Set<String> paramBpmRoleCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty(item.getBpmRoleCode())).map(MdmBpmRoleImportVo::getBpmRoleCode).collect(Collectors.toSet());
        if (!paramBpmRoleCodeSet.isEmpty()) {
            QueryWrapper<MdmBpmRoleEntity> codeQueryWrapper = new QueryWrapper<>();
            codeQueryWrapper.in("bpm_role_code", paramBpmRoleCodeSet);
            List<MdmBpmRoleEntity> paramBpmRoleCodeEntityList = mdmBpmRoleMapper.selectList(codeQueryWrapper);
            if (CollectionUtil.listNotEmptyNotSizeZero(paramBpmRoleCodeEntityList)) {
                roleCodeSet.addAll(paramBpmRoleCodeEntityList.stream().map(MdmBpmRoleEntity::getBpmRoleCode).collect(Collectors.toSet()));
            }
        }

        Set<String> roleNameSet = new HashSet<>(16);
        Set<String> paramNameCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty(item.getBpmRoleName())).map(MdmBpmRoleImportVo::getBpmRoleName).collect(Collectors.toSet());
        if (!paramNameCodeSet.isEmpty()) {
            QueryWrapper<MdmBpmRoleEntity> nameQueryWrapper = new QueryWrapper<>();
            nameQueryWrapper.in("bpm_role_name", paramNameCodeSet);
            List<MdmBpmRoleEntity> paramBpmRoleNameEntityList = mdmBpmRoleMapper.selectList(nameQueryWrapper);
            if (CollectionUtil.listNotEmptyNotSizeZero(paramBpmRoleNameEntityList)) {
                roleNameSet.addAll(paramBpmRoleNameEntityList.stream().map(MdmBpmRoleEntity::getBpmRoleName).collect(Collectors.toSet()));
            }
        }

        Map<String, Integer> codeIndexMap = new HashMap<>(16);
        Map<String, Integer> nameIndexMap = new HashMap<>(16);
        for (MdmBpmRoleImportVo item :
                originList) {

            //角色编码
            if (StringUtils.isNotEmpty(item.getBpmRoleCode())) {
                if (roleCodeSet.contains(item.getBpmRoleCode())) {
                    item.appendErrorValidateMsg("流程角色编码已存在；");
                } else {
                    if (codeIndexMap.containsKey(item.getBpmRoleCode())) {
                        item.appendErrorValidateMsg("流程角色编码与第[" + codeIndexMap.get(item.getBpmRoleCode()) + "]行重复；");
                    } else {
                        codeIndexMap.put(item.getBpmRoleCode(), item.getRowIndex());
                    }
                }
            }

            //角色名称
            if (StringUtils.isEmpty(item.getBpmRoleName())) {
                item.appendErrorValidateMsg("缺失流程角色名称；");
            } else {
                if (roleNameSet.contains(item.getBpmRoleName())) {
                    item.appendErrorValidateMsg("流程角色名称已存在；");
                } else {
                    if (nameIndexMap.containsKey(item.getBpmRoleName())) {
                        item.appendErrorValidateMsg("流程角色名称与第[" + nameIndexMap.get(item.getBpmRoleName()) + "]行重复；");
                    } else {
                        nameIndexMap.put(item.getBpmRoleName(), item.getRowIndex());
                    }
                }
            }
        }
    }

}
