package com.biz.crm.excel.component.validator.mdm.customermaterial;

import com.alibaba.excel.context.AnalysisContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.TestImportVo;
import com.biz.crm.excel.vo.mdm.customermaterial.MdmCustomerMaterialImportVo;
import com.biz.crm.mdm.customerorg.entity.MdmCusOrgEntity;
import com.biz.crm.mdm.customerorg.mapper.MdmCusOrgMapper;
import com.biz.crm.mdm.material.entity.MdmMaterialEntity;
import com.biz.crm.mdm.material.mapper.MdmMaterialMapper;
import com.biz.crm.sfa.test.entity.TestImportEntity;
import com.biz.crm.sfa.test.mapper.TestImportMapper;
import com.biz.crm.util.CollectionUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @Description: 客户物料数据校验方法
 * @project：crm-core
 * @package：com.biz.crm.excel.component.validator.mdm.customermaterial
 * @author：longyu
 * @create：2021/1/4 10:33
 */
@Slf4j
@Component("mdmCustomerMaterialValidator")
public class MdmCustomerMaterialValidator <M extends BaseMapper<T>, T> extends AbstractExcelImportValidator<MdmMaterialMapper, MdmMaterialEntity, MdmCustomerMaterialImportVo> implements ExcelImportValidator<MdmCustomerMaterialImportVo> {

    @Resource
    private MdmMaterialMapper mdmMaterialMapper;

    @Resource
    private MdmCusOrgMapper mdmCusOrgMapper;

    /**
     * 导入校验方法
     *
     * @param data
     * @return
     */
    @Override
    public void validate(List<MdmCustomerMaterialImportVo> data, DefaultImportContext context) {

        if (CollectionUtils.isEmpty(data)) {
            return;
        }

        //数据库已有客户组织编码重复校验
        Map<String, String> cusOrg = new HashMap(16);
        Set<String> cusOrgSet = data.stream().filter(item -> StringUtils.isNotEmpty(item.getCustomerOrgCode())).map(MdmCustomerMaterialImportVo::getCustomerOrgCode).collect(Collectors.toSet());
        if (!cusOrgSet.isEmpty()) {
            QueryWrapper<MdmCusOrgEntity> cusOrgCodeUniqueQuery = new QueryWrapper<>();
            cusOrgCodeUniqueQuery.in("customer_org_code", cusOrgSet);
            List<MdmCusOrgEntity> list = mdmCusOrgMapper.selectList(cusOrgCodeUniqueQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                for (int i = 0; i < list.size(); i++) {
                    cusOrg.put(list.get(i).getCustomerOrgCode(), list.get(i).getEnableStatus());
                }
            }
        }

        //数据库已有物料编码重复校验
        Map<String, String> material = new HashMap(16);
        Set<String> materialSet = data.stream().filter(item -> StringUtils.isNotEmpty(item.getMaterialCode())).map(MdmCustomerMaterialImportVo::getMaterialCode).collect(Collectors.toSet());
        if (!materialSet.isEmpty()) {
            QueryWrapper<MdmMaterialEntity> materialCodeUniqueQuery = new QueryWrapper<>();
            materialCodeUniqueQuery.in("material_code", materialSet);
            List<MdmMaterialEntity> list = mdmMaterialMapper.selectList(materialCodeUniqueQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                for (int i = 0; i < list.size(); i++) {
                    material.put(list.get(i).getMaterialCode(), list.get(i).getEnableStatus());
                }
            }
        }

        Map<String, Integer> customerOrgCodeMap = new HashMap<>(16);
        Map<String, Integer> materialCodeMap = new HashMap<>(16);
        Map<String, Integer> barCodeMap = new HashMap<>(16);
        data.forEach(v -> {
            StringBuilder msg = new StringBuilder();
            if (StringUtils.isBlank(v.getCustomerOrgCode())) {
                msg.append("客户组织编码不能为空;");
            } else {
                if (!cusOrg.containsKey(v.getCustomerOrgCode())) {
                    msg.append("客户组织编码:"+v.getCustomerOrgCode()+"不存在;");
                } else {
                    if (!CrmEnableStatusEnum.ENABLE.getCode().equals(cusOrg.get(v.getCustomerOrgCode()))) {
                        msg.append("所选客户组织禁用了;");
                    }
                }
                if (customerOrgCodeMap.containsKey(v.getCustomerOrgCode())){
                    msg.append("客户组织编码与第"+customerOrgCodeMap.get(v.getCustomerOrgCode())+"行重复;");
                }else {
                    customerOrgCodeMap.put(v.getCustomerOrgCode(),v.getRowIndex());
                }
            }
            if (StringUtils.isBlank(v.getMaterialCode())) {
                msg.append("物料编码不能为空;");
            } else {
                if (!material.containsKey(v.getMaterialCode())) {
                    msg.append("物料编码:"+v.getMaterialCode()+"不存在;");
                } else {
                    if (!CrmEnableStatusEnum.ENABLE.getCode().equals(material.get(v.getMaterialCode()))) {
                        msg.append("所选物料禁用了;");
                    }
                }

                if (materialCodeMap.containsKey(v.getMaterialCode())){
                    msg.append("物料编码与第"+materialCodeMap.get(v.getMaterialCode())+"行重复;");
                }else {
                    materialCodeMap.put(v.getMaterialCode(),v.getRowIndex());
                }

            }
            if (StringUtils.isBlank(v.getBarCode())) {
                msg.append("条形编码没有填写;");
            }else {
                if (barCodeMap.containsKey(v.getBarCode())){
                    msg.append("条形码与第"+barCodeMap.get(v.getBarCode())+"行重复;");
                }else {
                    barCodeMap.put(v.getBarCode(),v.getRowIndex());
                }
            }
            if (StringUtils.isNotBlank(msg)) {
                v.appendErrorValidateMsg(msg.toString());
            }
        });
    }
}
