package com.biz.crm.excel.component.validator.mdm.materialGroup;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.material.MdmMaterialImportVo;
import com.biz.crm.excel.vo.mdm.materialGroup.MdmMaterialGroupImportVo;
import com.biz.crm.mdm.material.entity.MdmMaterialEntity;
import com.biz.crm.mdm.material.mapper.MdmMaterialMapper;
import com.biz.crm.mdm.materialGroup.entity.MdmMaterialGroupEntity;
import com.biz.crm.mdm.materialGroup.mapper.MdmMaterialGroupMapper;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * @ClassName: MdmMaterialGroupImportValidator
 * @Author: yangfan
 * @Description: 物料组导入校验
 * @Date: 2021/8/25 16:01
 * @Version: 1.0
 */
@Component("mdmMaterialGroupImportValidator")
public class MdmMaterialGroupImportValidator<M extends BaseMapper<T>, T> extends AbstractExcelImportValidator<MdmMaterialGroupMapper, MdmMaterialGroupEntity, MdmMaterialGroupImportVo> implements
    ExcelImportValidator<MdmMaterialGroupImportVo> {

  @Resource
  private MdmMaterialGroupMapper mdmMaterialGroupMapper;

  @Resource
  private MdmMaterialMapper mdmMaterialMapper;

  @Override
  public void validate(List<MdmMaterialGroupImportVo> data, DefaultImportContext context) {
    if (CollectionUtils.isEmpty(data)) {
      return;
    }

    Set<String> collect = data.stream().filter(itemGroup -> StringUtils.isNotEmpty(itemGroup.getMaterialGroupCode())).map(MdmMaterialGroupImportVo::getMaterialGroupCode).collect(Collectors.toSet());
    if (collect.isEmpty()) {
      return;
    }

    //  获取所有已存在物料组编码
    LambdaQueryWrapper<MdmMaterialGroupEntity> wrapper = Wrappers.<MdmMaterialGroupEntity>lambdaQuery().select(MdmMaterialGroupEntity::getMaterialGroupCode);
    wrapper.in(MdmMaterialGroupEntity::getMaterialGroupCode, collect).eq(MdmMaterialGroupEntity::getEnableStatus,"009");
    final Set<String> materialCodeSet = mdmMaterialGroupMapper.selectList(wrapper).stream()
        .map(MdmMaterialGroupEntity::getMaterialGroupCode)
        .collect(Collectors.toSet());

    data.forEach(item -> {
      if (StringUtils.isEmpty(item.getMaterialGroupCode())) {
        item.appendErrorValidateMsg("物料组编码不能为空；");
      }
      if (StringUtils.isEmpty(item.getMaterialGroupName())) {
        item.appendErrorValidateMsg("物料组名称不能为空；");
      }
      if (StringUtils.isEmpty(item.getMaterialCode())) {
        item.appendErrorValidateMsg("物料编码不能为空；");
      }

      Map<String, Integer> codeIndexMap = new HashMap<>(16);
        if (materialCodeSet.contains(item.getMaterialCode())) {
          item.appendErrorValidateMsg("物料组编码"+item.getMaterialCode()+"已存在；");
        } else if (codeIndexMap.containsKey(item.getMaterialCode())) {
          item.appendErrorValidateMsg("物料组编码" + item.getMaterialCode() + "和第"+codeIndexMap.get(item.getMaterialCode())+"行物料组编码重复；");
        } else {
          codeIndexMap.put(item.getMaterialCode(), item.getRowIndex());
        }

      // 校验物料信息是否存在于系统中
      String materialCode = item.getMaterialCode();
      List<String> materialCodeList = Arrays.asList(materialCode.split(","));
      materialCodeList.forEach(itemCode->{
        List<MdmMaterialEntity> mdmMaterialEntities = mdmMaterialMapper
            .selectList(Wrappers.lambdaQuery(MdmMaterialEntity.class).eq(MdmMaterialEntity::getMaterialCode, itemCode).eq(MdmMaterialEntity::getEnableStatus, "009"));
        if(CollectionUtils.isEmpty(mdmMaterialEntities)){
          item.appendErrorValidateMsg("系统不存在此物料信息"+itemCode);
        }
      });

    });
  }
}
