package com.biz.crm.excel.component.validator.mdm.position;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.position.MdmPositionImportTreeVo;
import com.biz.crm.excel.vo.mdm.position.MdmPositionImportVo;
import com.biz.crm.mdm.bpmrple.entity.MdmBpmRoleEntity;
import com.biz.crm.mdm.bpmrple.mapper.MdmBpmRoleMapper;
import com.biz.crm.mdm.org.entity.MdmOrgEntity;
import com.biz.crm.mdm.org.mapper.MdmOrgMapper;
import com.biz.crm.mdm.position.entity.MdmPositionEntity;
import com.biz.crm.mdm.position.mapper.MdmPositionMapper;
import com.biz.crm.mdm.positionlevel.entity.MdmPositionLevelEntity;
import com.biz.crm.mdm.positionlevel.entity.MdmPositionLevelRoleEntity;
import com.biz.crm.mdm.positionlevel.mapper.MdmPositionLevelMapper;
import com.biz.crm.mdm.positionlevel.mapper.MdmPositionLevelRoleMapper;
import com.biz.crm.mdm.role.entity.MdmRoleEntity;
import com.biz.crm.mdm.role.mapper.MdmRoleMapper;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.TreeRuleCodeUtil;
import com.biz.crm.util.websocket.WebsocketUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

@Slf4j
@Component("mdmPositionImportValidator")
public class MdmPositionImportValidator<M extends BaseMapper<T>, T> extends AbstractExcelImportValidator<MdmPositionMapper, MdmPositionEntity, MdmPositionImportVo> implements ExcelImportValidator<MdmPositionImportVo> {

    @Resource
    private MdmPositionMapper mdmPositionMapper;
    @Resource
    private MdmPositionLevelMapper mdmPositionLevelMapper;
    @Resource
    private MdmOrgMapper mdmOrgMapper;
    @Resource
    private MdmRoleMapper mdmRoleMapper;
    @Resource
    private MdmBpmRoleMapper mdmBpmRoleMapper;
    @Resource
    private MdmPositionLevelRoleMapper mdmPositionLevelRoleMapper;
    @Autowired
    private WebsocketUtil websocketUtil;

    @Override
    public void validate(List<MdmPositionImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        validateRequired(data, context);
    }

    protected void validateRequired(List<MdmPositionImportVo> originList, DefaultImportContext context) {

        String sid = context.getImportParamVo().getWebSocketClientId();
        websocketUtil.sendMsg(sid, "开始职位导入");

        websocketUtil.sendMsg(sid, "开始预加载数据");

        websocketUtil.sendMsg(sid, "开始预加载数据===>开始加载参数职位校验数据");
        //职位编码
        Set<String> positionCodeSet = new HashSet<>(16);
        Set<String> paramPositionCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty(item.getPositionCode())).map(MdmPositionImportVo::getPositionCode).collect(Collectors.toSet());
        if (!paramPositionCodeSet.isEmpty()) {
            QueryWrapper<MdmPositionEntity> positionQuery = new QueryWrapper<>();
            positionQuery.in("position_code", paramPositionCodeSet);
            positionQuery.eq("del_flag", CrmDelFlagEnum.NORMAL.getCode());
            List<MdmPositionEntity> positionEntityList = mdmPositionMapper.selectList(positionQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero(positionEntityList)) {
                positionCodeSet.addAll(positionEntityList.stream().map(MdmPositionEntity::getPositionCode).collect(Collectors.toSet()));
            }
        }
        websocketUtil.sendMsg(sid, "预加载数据===>结束加载参数职位校验数据===>" + positionCodeSet.size());

        websocketUtil.sendMsg(sid, "预加载数据===>开始加载职位级别和职位级别关联角色数据");
        //职位级别编码
        Set<String> positionLevelCodeSet = new HashSet<>(16);
        //职位级别关联角色编码
        Map<String, Set<String>> positionLevelRoleSetMap = new HashMap<>(16);
        //职位级别下的 关联角色编码-名称
        Map<String, String> relRoleCodeNameMap = new HashMap<>(16);
        Set<String> paramPositionLevelCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty(item.getPositionLevelCode())).map(MdmPositionImportVo::getPositionLevelCode).collect(Collectors.toSet());
        if (!paramPositionLevelCodeSet.isEmpty()) {
            QueryWrapper<MdmPositionLevelEntity> positionLevelQuery = new QueryWrapper<>();
            positionLevelQuery.in("position_level_code", paramPositionLevelCodeSet);
            List<MdmPositionLevelEntity> positionLevelEntityList = mdmPositionLevelMapper.selectList(positionLevelQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero(positionLevelEntityList)) {
                positionLevelCodeSet.addAll(positionLevelEntityList.stream().map(MdmPositionLevelEntity::getPositionLevelCode).collect(Collectors.toSet()));
            }

            QueryWrapper<MdmPositionLevelRoleEntity> positionLevelRoleQuery = new QueryWrapper<>();
            positionLevelRoleQuery.in("position_level_code", paramPositionLevelCodeSet);
            List<MdmPositionLevelRoleEntity> positionLevelRoleEntityList = mdmPositionLevelRoleMapper.selectList(positionLevelRoleQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero(positionLevelRoleEntityList)) {
                positionLevelRoleSetMap = positionLevelRoleEntityList.stream().collect(Collectors.groupingBy(MdmPositionLevelRoleEntity::getPositionLevelCode, Collectors.mapping(MdmPositionLevelRoleEntity::getRoleCode, Collectors.toSet())));

                QueryWrapper<MdmRoleEntity> relRoleQuery = new QueryWrapper<>();
                relRoleQuery.in("role_code", positionLevelRoleEntityList.stream().map(MdmPositionLevelRoleEntity::getRoleCode).collect(Collectors.toSet()));
                List<MdmRoleEntity> relRoleEntityList = mdmRoleMapper.selectList(relRoleQuery);
                if (CollectionUtil.listNotEmptyNotSizeZero(relRoleEntityList)) {
                    relRoleCodeNameMap = relRoleEntityList.stream().collect(Collectors.toMap(MdmRoleEntity::getRoleCode, MdmRoleEntity::getRoleName));
                }
            }
        }
        websocketUtil.sendMsg(sid, "预加载数据===>结束加载职位级别和职位级别关联角色数据===>" + positionLevelCodeSet.size());

        websocketUtil.sendMsg(sid, "预加载数据===>开始加载组织数据");
        //组织编码
        Set<String> orgCodeSet = new HashSet<>(16);
        Set<String> paramOrgCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty(item.getOrgCode())).map(MdmPositionImportVo::getOrgCode).collect(Collectors.toSet());
        if (!paramOrgCodeSet.isEmpty()) {
            QueryWrapper<MdmOrgEntity> orgQuery = new QueryWrapper<>();
            orgQuery.in("org_code", paramOrgCodeSet);
            List<MdmOrgEntity> orgEntityList = mdmOrgMapper.selectList(orgQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero(orgEntityList)) {
                orgCodeSet.addAll(orgEntityList.stream().map(MdmOrgEntity::getOrgCode).collect(Collectors.toSet()));
            }
        }
        websocketUtil.sendMsg(sid, "预加载数据===>结束加载组织数据===>" + orgCodeSet.size());


        websocketUtil.sendMsg(sid, "预加载数据===>开始加载上级职位数据");

        //上级职位编码
        Set<String> parentCodeSet = new HashSet<>(16);
        Set<String> paramParentCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty(item.getParentCode())).map(MdmPositionImportVo::getParentCode).collect(Collectors.toSet());
        if (!paramParentCodeSet.isEmpty()) {
            QueryWrapper<MdmPositionEntity> positionQuery = new QueryWrapper<>();
            positionQuery.in("position_code", paramParentCodeSet);
            positionQuery.eq("del_flag", CrmDelFlagEnum.NORMAL.getCode());
            List<MdmPositionEntity> positionEntityList = mdmPositionMapper.selectList(positionQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero(positionEntityList)) {
                parentCodeSet.addAll(positionEntityList.stream().map(MdmPositionEntity::getPositionCode).collect(Collectors.toSet()));
            }
        }
        websocketUtil.sendMsg(sid, "预加载数据===>结束加载上级职位数据===>" + parentCodeSet.size());

        websocketUtil.sendMsg(sid, "预加载数据===>开始加载角色数据");

        //角色编码-名称
        Map<String, String> roleMap = new HashMap<>(16);
        Set<String> roleCodeSet = new HashSet<>(16);
        for (MdmPositionImportVo mdmPositionImportVo : originList) {
            if (StringUtils.isNotEmpty(mdmPositionImportVo.getRoleCode())) {
                roleCodeSet.addAll(Arrays.asList(mdmPositionImportVo.getRoleCode().split(",")));
            }

        }
        if (!roleCodeSet.isEmpty()) {
            QueryWrapper<MdmRoleEntity> roleQuery = new QueryWrapper<>();
            roleQuery.in("role_code", roleCodeSet);
            List<MdmRoleEntity> roleEntityList = mdmRoleMapper.selectList(roleQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero(roleEntityList)) {
                roleMap = roleEntityList.stream().collect(Collectors.toMap(MdmRoleEntity::getRoleCode, MdmRoleEntity::getRoleName));
            }
        }
        websocketUtil.sendMsg(sid, "预加载数据===>结束加载角色数据===>" + roleMap.size());


        websocketUtil.sendMsg(sid, "预加载数据===>开始加载流程角色数据");
        //流程角色编码-名称
        Map<String, String> bpmRoleMap = new HashMap<>(16);
        Set<String> bpmRoleCodeSet = new HashSet<>(16);
        for (MdmPositionImportVo mdmPositionImportVo : originList) {
            if (StringUtils.isNotEmpty(mdmPositionImportVo.getBpmRoleCode())) {
                bpmRoleCodeSet.addAll(Arrays.asList(mdmPositionImportVo.getBpmRoleCode().split(",")));
            }
        }
        if (!bpmRoleCodeSet.isEmpty()) {
            QueryWrapper<MdmBpmRoleEntity> bpmRoleQuery = new QueryWrapper<>();
            bpmRoleQuery.in("bpm_role_code", bpmRoleCodeSet);
            List<MdmBpmRoleEntity> bpmRoleEntityList = mdmBpmRoleMapper.selectList(bpmRoleQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero(bpmRoleEntityList)) {
                bpmRoleMap = bpmRoleEntityList.stream().collect(Collectors.toMap(MdmBpmRoleEntity::getBpmRoleCode, MdmBpmRoleEntity::getBpmRoleName));
            }
        }
        websocketUtil.sendMsg(sid, "预加载数据===>结束加载流程角色数据===>" + bpmRoleMap.size());


        websocketUtil.sendMsg(sid, "预加载数据===>开始加载组织上级关系数据");
        Map<String, Map<String, String>> positionParentOrgMap = new ConcurrentHashMap<>(16);
        //校验组织与上级的关系
        Set<String> collect = originList.stream().filter(x -> StringUtils.isNotEmpty(x.getParentCode()) && StringUtils.isNotEmpty(x.getOrgCode())).map(MdmPositionImportVo::getParentCode).collect(Collectors.toSet());
        if (!collect.isEmpty()) {
            positionParentOrgMap.putAll(findAllParentOrgCodeListOfPositionParentList(new ArrayList<>(collect)));
        }
        websocketUtil.sendMsg(sid, "预加载数据===>结束加载组织上级关系数据===>" + positionParentOrgMap.size());


//        Map<String, MdmPositionImportVo> positionImportVoMap = originList.stream().filter(x -> StringUtils.isNotEmpty(x.getPositionCode())).collect(Collectors.toMap(MdmPositionImportVo::getPositionCode, v -> v, (v1, v2) -> v1));
        websocketUtil.sendMsg(sid, "结束预加载数据");



        Map<String, Integer> positionCodeIndexMap = new HashMap<>(16);
        int i = 1;
        int total = originList.size();
        websocketUtil.sendMsg(sid, "开始第一次遍历");
        for (MdmPositionImportVo item :
                originList) {

            //职位编码
            if (StringUtils.isEmpty(item.getPositionCode())) {
                item.appendErrorValidateMsg("缺失职位编码；");
            } else {
                if (positionCodeSet.contains(item.getPositionCode())) {
                    item.appendErrorValidateMsg("职位编码已经存在；");
                } else {
                    if (positionCodeIndexMap.containsKey(item.getPositionCode())) {
                        item.appendErrorValidateMsg("职位编码与第" + positionCodeIndexMap.get(item.getPositionCode()) + "行重复；");
                    } else {
                        positionCodeIndexMap.put(item.getPositionCode(), item.getRowIndex());
                    }
                }
            }

            //职位级别编码
            if (StringUtils.isEmpty(item.getPositionLevelCode())) {
                item.appendErrorValidateMsg("缺失职位级别编码；");
            } else {
                if (!positionLevelCodeSet.contains(item.getPositionLevelCode())) {
                    item.appendErrorValidateMsg("缺失职位级别编码不存在；");
                }
            }

            //组织编码
            if (StringUtils.isEmpty(item.getOrgCode())) {
                item.appendErrorValidateMsg("缺失组织编码；");
            } else {
                if (!orgCodeSet.contains(item.getOrgCode())) {
                    item.appendErrorValidateMsg("组织编码无效；");
                }
            }

            //权限角色
            if (StringUtils.isNotEmpty(item.getRoleCode())) {
                String[] split = item.getRoleCode().split(",");
                for (String roleCode :
                        split) {
                    if (!roleMap.containsKey(roleCode)) {
                        item.appendErrorValidateMsg("权限角色编码[" + roleCode + "]无效；");
                    }
                }

            } else {
                if (MdmPositionImportVo.ProcessTypeEnum.SUCCESS == item.getProcessType()) {
                    if (positionLevelRoleSetMap.containsKey(item.getPositionLevelCode())) {
                        Set<String> codeList = new HashSet<>(16);
                        Set<String> codeSet = positionLevelRoleSetMap.get(item.getPositionLevelCode());
                        if (!codeSet.isEmpty()) {
                            for (String roleCode :
                                    codeSet) {
                                if (relRoleCodeNameMap.containsKey(roleCode)) {
                                    codeList.add(roleCode);
                                }
                            }
                            item.setRoleCode(String.join(",", codeList));
                        }
                    }
                }
            }

            //流程角色
            if (StringUtils.isNotEmpty(item.getBpmRoleCode())) {
                String[] split = item.getBpmRoleCode().split(",");
                for (String bpmRoleCode :
                        split) {
                    if (!bpmRoleMap.containsKey(bpmRoleCode)) {
                        item.appendErrorValidateMsg("流程角色编码[" + bpmRoleCode + "]无效；");
                    }
                }
            }

            if (StringUtils.isNotEmpty(item.getOrgCode()) && StringUtils.isNotEmpty(item.getParentCode())) {
                if (positionParentOrgMap.containsKey(item.getParentCode())) {
                    Map<String, String> map = positionParentOrgMap.get(item.getParentCode());
                    if (map.containsKey(item.getOrgCode())) {
                        item.appendErrorValidateMsg("组织[" + item.getOrgCode() + "]属于该行上级职位[" + item.getParentCode() + "]（及上级职位）的组织（及上级），不能作为当前职位的组织；");
                    }
                }
            }

            websocketUtil.sendMsg(sid, "第一次遍历，完成" + i++ + "条，共" + total + "条");

        }

        websocketUtil.sendMsg(sid, "结束第一次遍历===>" + total);

        List<MdmPositionImportTreeVo> treeList = originList.stream().map(x -> {
            MdmPositionImportTreeVo treeVo = new MdmPositionImportTreeVo();
            treeVo.setPositionCode(x.getPositionCode());
            treeVo.setOrgCode(x.getOrgCode());
            treeVo.setParentCode(x.getParentCode());
            treeVo.setSuccess(MdmPositionImportVo.ProcessTypeEnum.SUCCESS == x.getProcessType());
            treeVo.setRowIndex(x.getRowIndex());
            return treeVo;
        }).collect(Collectors.toList());


        websocketUtil.sendMsg(sid, "开始构建树形结构用于校验上下级");
        Set<String> set = new HashSet<>(16);
        List<MdmPositionImportTreeVo> tree = generateTreeByParentCode(treeList, set);
        websocketUtil.sendMsg(sid, "结束构建树形结构");


        Map<Integer, String> errorMsgMap = new HashMap<>(16);

        websocketUtil.sendMsg(sid, "开始校验职位上下级关联关系");
        for (MdmPositionImportTreeVo node :
                tree) {

            //上级编码
            if (StringUtils.isNotEmpty(node.getParentCode())) {
                if (!parentCodeSet.contains(node.getParentCode())) {
                    node.setSuccess(false);
                    errorMsgMap.put(node.getRowIndex(), "上级编码无效");
                }
            }

            if (CollectionUtil.listNotEmptyNotSizeZero(node.getChildren())) {
                setCheckChildren(node, node.getChildren(), errorMsgMap);
            }
        }


        for (MdmPositionImportVo item :
                originList) {
            if (StringUtils.isNotEmpty(item.getPositionCode())) {
                if (!set.contains(item.getPositionCode())) {
                    item.appendErrorValidateMsg("当前数据的上下级可能构成环状结构；");
                }
            }
            if (errorMsgMap.containsKey(item.getRowIndex())) {
                item.appendErrorValidateMsg(errorMsgMap.get(item.getRowIndex()));
            }
        }

        websocketUtil.sendMsg(sid, "结束校验职位上下级关联关系");
    }


    protected Map<String, Map<String, String>> findAllParentOrgCodeListOfPositionParentList(List<String> positionCodeList) {
        Map<String, Map<String, String>> map = new ConcurrentHashMap<>(16);
        QueryWrapper<MdmPositionEntity> positionQuery = new QueryWrapper<>();
        positionQuery.eq("del_flag", CrmDelFlagEnum.NORMAL.getCode());
        positionQuery.in("position_code", positionCodeList);
        List<MdmPositionEntity> positionEntityList = mdmPositionMapper.selectList(positionQuery);
        if (CollectionUtil.listNotEmptyNotSizeZero(positionEntityList)) {
            positionEntityList.forEach(position -> {
                Set<String> parentRuleCodes = TreeRuleCodeUtil.splitParentRuleCodes(position.getRuleCode());
                if (!parentRuleCodes.isEmpty()) {
                    QueryWrapper<MdmPositionEntity> positionParentQuery = new QueryWrapper<>();
                    positionParentQuery.in("rule_code", parentRuleCodes);
                    List<MdmPositionEntity> parentPositionList = mdmPositionMapper.selectList(positionParentQuery);
                    if (CollectionUtil.listNotEmptyNotSizeZero(parentPositionList)) {
                        Set<String> orgCodeSet = parentPositionList.stream().filter(item -> StringUtils.isNotEmpty(item.getOrgCode())).map(MdmPositionEntity::getOrgCode).collect(Collectors.toSet());
                        if (!orgCodeSet.isEmpty()) {
                            Set<String> parentRuleCodesExcludeSelf = TreeRuleCodeUtil.splitParentRuleCodesExcludeSelf(new ArrayList<>(orgCodeSet));
                            if (!parentRuleCodesExcludeSelf.isEmpty()) {
                                QueryWrapper<MdmOrgEntity> orgQuery = new QueryWrapper<>();
                                orgQuery.in("rule_code", parentRuleCodesExcludeSelf);
                                List<MdmOrgEntity> orgEntityList = mdmOrgMapper.selectList(orgQuery);
                                if (CollectionUtil.listNotEmptyNotSizeZero(orgEntityList)) {
                                    map.put(position.getPositionCode(), orgEntityList.stream().collect(Collectors.toMap(MdmOrgEntity::getOrgCode, MdmOrgEntity::getOrgName)));
                                }
                            }
                        }
                    }
                }
            });
        }
        return map;
    }

    protected List<MdmPositionImportTreeVo> generateTreeByParentCode(List<MdmPositionImportTreeVo> totalList, Set<String> set) {

        //构建树list
        List<MdmPositionImportTreeVo> treeList = new ArrayList<>();
        //当前操作层级数据
        List<MdmPositionImportTreeVo> curLevelList = new ArrayList<>();
        //未操作数据
        List<MdmPositionImportTreeVo> restList = new ArrayList<>();

        Map<String, MdmPositionImportTreeVo> totalMap = totalList.stream().collect(Collectors.toMap(MdmPositionImportTreeVo::getPositionCode, v -> v));

        //查找第一层
        for (MdmPositionImportTreeVo item :
                totalList) {
            if (StringUtils.isEmpty(item.getParentCode()) || !totalMap.containsKey(item.getParentCode())) {
                treeList.add(item);
                curLevelList.add(item);
                set.add(item.getPositionCode());
            } else {
                restList.add(item);
            }
        }

        //构建数据，从第二层开始
        while (curLevelList.size() > 0 && restList.size() > 0) {
            List<MdmPositionImportTreeVo> restTempList = new ArrayList<>();
            List<MdmPositionImportTreeVo> curLevelTempList = new ArrayList<>();
            Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(MdmPositionImportTreeVo::getPositionCode, MdmPositionImportTreeVo::getPositionCode));
            Map<String, List<MdmPositionImportTreeVo>> curLevelChildrenMap = new HashMap<>();

            for (MdmPositionImportTreeVo item :
                    restList) {
                if (curLevelMap.containsKey(item.getParentCode())) {
                    curLevelTempList.add(item);

                    List<MdmPositionImportTreeVo> childrenList = new ArrayList<>();
                    if (curLevelChildrenMap.containsKey(item.getParentCode())) {
                        childrenList.addAll(curLevelChildrenMap.get(item.getParentCode()));
                    }
                    set.add(item.getPositionCode());
                    childrenList.add(item);
                    curLevelChildrenMap.put(item.getParentCode(), childrenList);
                } else {
                    restTempList.add(item);
                }
            }

            for (MdmPositionImportTreeVo item :
                    curLevelList) {
                if (curLevelChildrenMap.containsKey(item.getPositionCode())) {
                    item.setChildren(curLevelChildrenMap.get(item.getPositionCode()));
                }
            }

            curLevelList.clear();
            curLevelList.addAll(curLevelTempList);
            restList.clear();
            restList.addAll(restTempList);
        }

        return treeList;
    }

    protected void setCheckChildren(MdmPositionImportTreeVo node, List<MdmPositionImportTreeVo> children, Map<Integer, String> errorMsg) {
        for (MdmPositionImportTreeVo child :
                children) {
            if (!node.isSuccess()) {
                child.setSuccess(false);
                errorMsg.put(child.getRowIndex(), "上级校验未通过");
                if (CollectionUtil.listNotEmptyNotSizeZero(child.getChildren())) {
                    setCheckChildren(child, child.getChildren(), errorMsg);
                }
            }
        }
    }

}
