package com.biz.crm.excel.component.validator.mdm.positionlevel;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.positionlevel.MdmPositionLevelImportVo;
import com.biz.crm.mdm.positionlevel.entity.MdmPositionLevelEntity;
import com.biz.crm.mdm.positionlevel.mapper.MdmPositionLevelMapper;
import com.biz.crm.mdm.positionlevel.mapper.MdmPositionLevelRoleMapper;
import com.biz.crm.mdm.role.entity.MdmRoleEntity;
import com.biz.crm.mdm.role.mapper.MdmRoleMapper;
import com.biz.crm.util.CollectionUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description: 校验方法
 * @project：crm-core
 * @package：com.biz.crm.excel.component.validator.mdm
 * @author：longyu
 * @create：2020/12/30 15:43
 */
@Slf4j
@Component("mdmPositionLevelImportValidator")
public class MdmPositionLevelImportValidator <M extends BaseMapper<T>, T> extends AbstractExcelImportValidator<MdmPositionLevelMapper, MdmPositionLevelEntity, MdmPositionLevelImportVo> implements ExcelImportValidator<MdmPositionLevelImportVo> {

    @Resource
    private MdmPositionLevelMapper mdmPositionLevelMapper;

    @Resource
    private MdmPositionLevelRoleMapper mdmPositionLevelRoleMapper;

    @Resource
    private MdmRoleMapper mdmRoleMapper;

    /**
     * 导入校验方法
     *
     * @param data
     * @return
     */

    @Override
    public void validate(List<MdmPositionLevelImportVo> data, DefaultImportContext context) {
        if(CollectionUtils.isEmpty(data)){
            return;
        }

        //数据库已有职位级别编码重复校验
        Set<String> positionLevelCodeUniqueSet = new HashSet<>(16);
        Set<String> positionCodeSet = data.stream().filter(item -> StringUtils.isNotEmpty(item.getPositionLevelCode())).map(MdmPositionLevelImportVo::getPositionLevelCode).collect(Collectors.toSet());
        if (!positionCodeSet.isEmpty()) {
            QueryWrapper<MdmPositionLevelEntity> positionCodeUniqueQuery = new QueryWrapper<>();
            positionCodeUniqueQuery.in("position_level_code", positionCodeSet);
            List<MdmPositionLevelEntity> positionCodeUniqueList = mdmPositionLevelMapper.selectList(positionCodeUniqueQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeUniqueList)) {
                positionLevelCodeUniqueSet.addAll(positionCodeUniqueList.stream().map(MdmPositionLevelEntity::getPositionLevelCode).collect(Collectors.toSet()));
            }
        }

        //数据库已有职位级别名称重复校验
        Set<String> positionLevelNameUniqueSet = new HashSet<>(16);
        Set<String> positionNameSet = data.stream().filter(item -> com.biz.crm.util.StringUtils.isNotEmpty(item.getPositionLevelName())).map(MdmPositionLevelImportVo::getPositionLevelName).collect(Collectors.toSet());
        if (!positionNameSet.isEmpty()) {
            QueryWrapper<MdmPositionLevelEntity> positionNameUniqueQuery = new QueryWrapper<>();
            positionNameUniqueQuery.in("position_level_name", positionNameSet);
            List<MdmPositionLevelEntity> positionNameUniqueList = mdmPositionLevelMapper.selectList(positionNameUniqueQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero(positionNameUniqueList)) {
                positionLevelNameUniqueSet.addAll(positionNameUniqueList.stream().map(MdmPositionLevelEntity::getPositionLevelName).collect(Collectors.toSet()));
            }
        }

        //数据库已有角色编码重复校验
        HashSet<String> roleCode = new HashSet<>();
        data.forEach(v -> {
            if (StringUtils.isNotEmpty(v.getRoleCode())){
                List<String> role = Arrays.asList(v.getRoleCode().split(","));
                for (int i = 0;i<role.size();i++){
                    roleCode.add(role.get(i));
                }
            }
        });
        Set<String> roleCodeUniqueSet = new HashSet<>(16);
        if (!roleCode.isEmpty()) {
            QueryWrapper<MdmRoleEntity> roleCodeUniqueQuery = new QueryWrapper<>();
            roleCodeUniqueQuery.in("role_code", roleCode);
            List<MdmRoleEntity> roleCodeUniqueList = mdmRoleMapper.selectList(roleCodeUniqueQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero(roleCodeUniqueList)) {
                roleCodeUniqueSet.addAll(roleCodeUniqueList.stream().map(MdmRoleEntity::getRoleCode).collect(Collectors.toSet()));
            }
        }

        Map<String, Integer> positionLevelCodeMap = new HashMap<>(16);
        Map<String, Integer> positionLevelNameMap = new HashMap<>(16);
        data.forEach(v -> {
            StringBuilder msg = new StringBuilder();
            if(StringUtils.isBlank(v.getPositionLevelName())){
                msg.append("职位级别名称不能为空;");
            }else {
                if (positionLevelNameMap.containsKey(v.getPositionLevelName())){
                    msg.append("职位级别名称与第"+positionLevelNameMap.get(v.getPositionLevelName())+"行重复;");
                }else {
                    positionLevelNameMap.put(v.getPositionLevelName(),v.getRowIndex());
                }
            }
            if (positionLevelNameUniqueSet.contains(v.getPositionLevelName())){
                msg.append(v.getPositionLevelName()+"职位级别名称已存在;");
            }
            if(StringUtils.isNotEmpty(v.getPositionLevelCode())){
                if (positionLevelCodeUniqueSet.contains(v.getPositionLevelCode())){
                    msg.append(v.getPositionLevelCode()+"职位级别编码已存在;");
                }
                if (positionLevelCodeMap.containsKey(v.getPositionLevelCode())){
                    msg.append("职位级别编码与第"+positionLevelCodeMap.get(v.getPositionLevelCode())+"行重复;");
                }else {
                    positionLevelCodeMap.put(v.getPositionLevelCode(),v.getRowIndex());
                }
            }
            if(StringUtils.isBlank(v.getRoleCode())){
                msg.append("角色编码不能为空;");
            }else {
                HashSet<String> code = new HashSet<>();
                List<String> list = Arrays.asList(v.getRoleCode().split(","));
                for (int i = 0;i<list.size();i++){
                    if (code.contains(list.get(i))){
                        msg.append("写了相同的角色编码");
                    }
                    code.add(list.get(i));
                }
                Iterator r = code.iterator();
                while (r.hasNext()){
                    if (!roleCodeUniqueSet.contains(r.next())){
                        msg.append("角色编码错误;");
                    }
                }
            }
            if(StringUtils.isNotBlank(msg)){
                v.appendErrorValidateMsg(msg.toString());
            }
        });
    }
}
