package com.biz.crm.excel.component.validator.mdm.role;

import com.alibaba.excel.context.AnalysisContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.TestImportVo;
import com.biz.crm.excel.vo.mdm.role.MdmRoleImportVo;
import com.biz.crm.mdm.role.entity.MdmRoleEntity;
import com.biz.crm.mdm.role.mapper.MdmRoleMapper;
import com.biz.crm.sfa.test.entity.TestImportEntity;
import com.biz.crm.sfa.test.mapper.TestImportMapper;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 权限角色导入校验
 *
 * @author Tao.Chen
 * @date 2021-01-04 20:46:13
 */
@Slf4j
@Component("mdmRoleImportValidator")
public class MdmRoleImportValidator <M extends BaseMapper<T>, T> extends AbstractExcelImportValidator<MdmRoleMapper, MdmRoleEntity, MdmRoleImportVo> implements ExcelImportValidator<MdmRoleImportVo> {

    @Resource
    private MdmRoleMapper mdmRoleMapper;

    @Override
    public void validate(List<MdmRoleImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        validateRequired(data);
    }

    protected void validateRequired(List<MdmRoleImportVo> originList) {

        Set<String> roleCodeSet = new HashSet<>(16);
        Set<String> paramRoleCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty(item.getRoleCode())).map(MdmRoleImportVo::getRoleCode).collect(Collectors.toSet());
        if (!paramRoleCodeSet.isEmpty()) {
            QueryWrapper<MdmRoleEntity> codeQueryWrapper = new QueryWrapper<>();
            codeQueryWrapper.in("role_code", paramRoleCodeSet);
            List<MdmRoleEntity> paramRoleCodeEntityList = mdmRoleMapper.selectList(codeQueryWrapper);
            if (CollectionUtil.listNotEmptyNotSizeZero(paramRoleCodeEntityList)) {
                roleCodeSet.addAll(paramRoleCodeEntityList.stream().map(MdmRoleEntity::getRoleCode).collect(Collectors.toSet()));
            }
        }

        Set<String> roleNameSet = new HashSet<>(16);
        Set<String> paramNameCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty(item.getRoleName())).map(MdmRoleImportVo::getRoleName).collect(Collectors.toSet());
        if (!paramNameCodeSet.isEmpty()) {
            QueryWrapper<MdmRoleEntity> nameQueryWrapper = new QueryWrapper<>();
            nameQueryWrapper.in("role_name", paramNameCodeSet);
            List<MdmRoleEntity> paramRoleNameEntityList = mdmRoleMapper.selectList(nameQueryWrapper);
            if (CollectionUtil.listNotEmptyNotSizeZero(paramRoleNameEntityList)) {
                roleNameSet.addAll(paramRoleNameEntityList.stream().map(MdmRoleEntity::getRoleName).collect(Collectors.toSet()));
            }
        }

        Map<String, Integer> codeIndexMap = new HashMap<>(16);
        Map<String, Integer> nameIndexMap = new HashMap<>(16);
        for (MdmRoleImportVo item :
                originList) {

            //角色编码
            if (StringUtils.isNotEmpty(item.getRoleCode())) {
                if (roleCodeSet.contains(item.getRoleCode())) {
                    item.appendErrorValidateMsg("角色编码已存在；");
                } else {
                    if (codeIndexMap.containsKey(item.getRoleCode())) {
                        item.appendErrorValidateMsg("角色编码与第[" + codeIndexMap.get(item.getRoleCode()) + "]行重复；");
                    } else {
                        codeIndexMap.put(item.getRoleCode(), item.getRowIndex());
                    }
                }
            }

            //角色名称
            if (StringUtils.isEmpty(item.getRoleName())) {
                item.appendErrorValidateMsg("角色名称不能为空；");
            }else {
                if (roleNameSet.contains(item.getRoleName())) {
                    item.appendErrorValidateMsg("角色名称已存在；");
                } else {
                    if (nameIndexMap.containsKey(item.getRoleName())) {
                        item.appendErrorValidateMsg("角色名称与第[" + nameIndexMap.get(item.getRoleName()) + "]行重复；");
                    } else {
                        nameIndexMap.put(item.getRoleName(), item.getRowIndex());
                    }
                }
            }

        }
    }

}
