package com.biz.crm.excel.component.validator.mdm.terminal;

import com.alibaba.excel.context.AnalysisContext;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.TestImportVo;
import com.biz.crm.excel.vo.mdm.terminal.MdmTerminalContactImportVo;
import com.biz.crm.mdm.terminal.entity.MdmTerminalContactEntity;
import com.biz.crm.mdm.terminal.entity.MdmTerminalEntity;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalContactMapper;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.sfa.test.entity.TestImportEntity;
import com.biz.crm.sfa.test.mapper.TestImportMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;


/**
 * @author: luoqi
 * @Date: 2020-12-11 10:50
 * @version: V1.0
 * @Description:
 */
@Slf4j
@Component("mdmTerminalContactImportValidator")
public class MdmTerminalContactImportValidator <M extends BaseMapper<T>, T> extends AbstractExcelImportValidator<MdmTerminalMapper, MdmTerminalEntity, MdmTerminalContactImportVo> implements ExcelImportValidator<MdmTerminalContactImportVo> {



    @Resource
    private MdmTerminalMapper mdmTerminalMapper;

    @Override
    public void validate(List<MdmTerminalContactImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        validTerminalCode(data);
        initialsEmptyContactMain(data);
    }

    /**
     * 初始化空联系人级别
     *
     * @param data list
     */
    protected void initialsEmptyContactMain(List<MdmTerminalContactImportVo> data) {
        for (MdmTerminalContactImportVo mdmTerminalContactImportVo : data) {
            if (StringUtils.isEmpty(mdmTerminalContactImportVo.getContactMain())) {
                mdmTerminalContactImportVo.setContactMain(YesNoEnum.yesNoEnum.ZERO.getValue());
            }
        }
    }

    /**
     * 校验终端编码
     *
     * @param data list
     */
    protected void validTerminalCode(List<MdmTerminalContactImportVo> data) {
        //校验传入终端编码
        for (MdmTerminalContactImportVo mdmTerminalContactImportVo : data) {
            if (StringUtils.isEmpty(mdmTerminalContactImportVo.getTerminalCode())) {
                mdmTerminalContactImportVo.appendErrorValidateMsg("行号：" + mdmTerminalContactImportVo.getRowIndex() + "终端编码不能为空;");
            }
        }
        //校验数据库是否存在终端编码
        List<MdmTerminalEntity> mdmTerminalEntities = mdmTerminalMapper.selectList(Wrappers.<MdmTerminalEntity>lambdaQuery()
                .select(MdmTerminalEntity::getTerminalCode));
        if (!CollectionUtils.isEmpty(mdmTerminalEntities)) {
            List<String> dbTerminalCodeList = mdmTerminalEntities.stream()
                    .filter(x -> x != null && !StringUtils.isEmpty(x.getTerminalCode()))
                    .map(MdmTerminalEntity::getTerminalCode)
                    .collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(dbTerminalCodeList)) {
                for (MdmTerminalContactImportVo mdmTerminalContactImportVo : data) {
                    if (!dbTerminalCodeList.contains(mdmTerminalContactImportVo.getTerminalCode())) {
                        mdmTerminalContactImportVo.appendErrorValidateMsg("行号：" + mdmTerminalContactImportVo.getRowIndex() + "终端编码不存在;");
                    }
                }
            }
        }
    }
}
