package com.biz.crm.excel.component.validator.mdm.terminal;

import com.alibaba.excel.context.AnalysisContext;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.TestImportVo;
import com.biz.crm.excel.vo.mdm.terminal.MdmTerminalSupplyDetailImportVo;
import com.biz.crm.mdm.product.entity.MdmProductEntity;
import com.biz.crm.mdm.product.entity.MdmProductLevelEntity;
import com.biz.crm.mdm.product.mapper.MdmProductLevelMapper;
import com.biz.crm.mdm.product.mapper.MdmProductMapper;
import com.biz.crm.mdm.terminal.entity.MdmTerminalSupplyEntity;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalSupplyMapper;
import com.biz.crm.sfa.test.entity.TestImportEntity;
import com.biz.crm.sfa.test.mapper.TestImportMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;


/**
 * @author: luoqi
 * @Date: 2020-12-11 10:50
 * @version: V1.0
 * @Description:
 */
@Slf4j
@Component("mdmTerminalSupplyDetailImportValidator")
public class MdmTerminalSupplyDetailImportValidator <M extends BaseMapper<T>, T> extends AbstractExcelImportValidator<MdmTerminalSupplyMapper, MdmTerminalSupplyEntity, MdmTerminalSupplyDetailImportVo> implements ExcelImportValidator<MdmTerminalSupplyDetailImportVo> {

    @Resource
    private MdmProductMapper mdmProductMapper;

    @Resource
    private MdmProductLevelMapper mdmProductLevelMapper;

    @Resource
    private MdmTerminalSupplyMapper mdmTerminalSupplyMapper;

    @Override
    public void validate(List<MdmTerminalSupplyDetailImportVo> data, DefaultImportContext context) {
        if(CollectionUtils.isEmpty(data)){
            return;
        }
        validDataType(data);
        validCode(data);
        validEmptyName(data);
        for (MdmTerminalSupplyDetailImportVo mdmTerminalSupplyDetailImportVo : data) {
            if(StringUtils.isEmpty(mdmTerminalSupplyDetailImportVo.getSupplyId())){
                mdmTerminalSupplyDetailImportVo.appendErrorValidateMsg("行号:"+mdmTerminalSupplyDetailImportVo.getRowIndex()+",对接人id不能为空;");
            }
        }
        Set<String> importSupplyIdSet = data.stream()
                .filter(x -> !StringUtils.isEmpty(x.getSupplyId()))
                .map(MdmTerminalSupplyDetailImportVo::getSupplyId)
                .collect(Collectors.toSet());
        if(CollectionUtils.isEmpty(importSupplyIdSet)){
            return;
        }
        LambdaQueryWrapper<MdmTerminalSupplyEntity> wrapper = Wrappers.<MdmTerminalSupplyEntity>lambdaQuery()
                .select(MdmTerminalSupplyEntity::getId);
        Set<String> dbTerminalSupplyIdSet = mdmTerminalSupplyMapper.selectList(wrapper).stream()
                .filter(x -> x != null && !StringUtils.isEmpty(x.getId()))
                .map(BaseIdEntity::getId)
                .collect(Collectors.toSet());
        for (MdmTerminalSupplyDetailImportVo mdmTerminalSupplyDetailImportVo : data) {
            String supplyId = mdmTerminalSupplyDetailImportVo.getSupplyId();
            if(!StringUtils.isEmpty(supplyId)){
                if(CollectionUtils.isEmpty(dbTerminalSupplyIdSet)|| !dbTerminalSupplyIdSet.contains(supplyId)){
                    mdmTerminalSupplyDetailImportVo.appendErrorValidateMsg("行号:"+mdmTerminalSupplyDetailImportVo.getRowIndex()+",对接人id"+supplyId+"不存在;");
                }
            }
        }
    }

    /**
     * 校验编码
     * @param data list
     */
    protected void validCode(List<MdmTerminalSupplyDetailImportVo> data) {
        for (MdmTerminalSupplyDetailImportVo mdmTerminalSupplyDetailImportVo : data) {
            if(StringUtils.isEmpty(mdmTerminalSupplyDetailImportVo.getCode())){
                mdmTerminalSupplyDetailImportVo.appendErrorValidateMsg("行号:"+mdmTerminalSupplyDetailImportVo.getRowIndex()+",供货编码不能为空;");
            }
        }
        Set<String> importCodeSet = data.stream()
                .filter(x->"1".equals(x.getDataType())||!"2".equals(x.getDataType()))
                .filter(x -> !StringUtils.isEmpty(x.getCode()))
                .map(MdmTerminalSupplyDetailImportVo::getCode)
                .collect(Collectors.toSet());
        if(CollectionUtils.isEmpty(importCodeSet)){
            return;
        }
        LambdaQueryWrapper<MdmProductEntity> productWrapper = Wrappers.<MdmProductEntity>lambdaQuery()
                .select(MdmProductEntity::getProductCode);
        Set<String> dbProductCodeSet = mdmProductMapper.selectList(productWrapper).stream()
                .filter(x -> x != null && !StringUtils.isEmpty(x.getProductCode()))
                .map(MdmProductEntity::getProductCode)
                .collect(Collectors.toSet());
        LambdaQueryWrapper<MdmProductLevelEntity> productLevelWrapper = Wrappers.<MdmProductLevelEntity>lambdaQuery()
                .select(MdmProductLevelEntity::getProductLevelCode);
        Set<String> dbProductLevelCodeSet = mdmProductLevelMapper.selectList(productLevelWrapper).stream()
                .filter(x -> x != null && !StringUtils.isEmpty(x.getProductLevelCode()))
                .map(MdmProductLevelEntity::getProductLevelCode)
                .collect(Collectors.toSet());
        for (MdmTerminalSupplyDetailImportVo mdmTerminalSupplyDetailImportVo : data) {
            String code = mdmTerminalSupplyDetailImportVo.getCode();
            String dataType = mdmTerminalSupplyDetailImportVo.getDataType();
            if(!StringUtils.isEmpty(code)&&importCodeSet.contains(code)){
                if ("1".equals(dataType)) {
                    if(CollectionUtils.isEmpty(dbProductCodeSet)|| !dbProductCodeSet.contains(code)){
                        mdmTerminalSupplyDetailImportVo.appendErrorValidateMsg("行号:"+mdmTerminalSupplyDetailImportVo.getRowIndex()+",商品编码"+code+"不存在;");
                    }
                } else if ("2".equals(dataType)) {
                    if(CollectionUtils.isEmpty(dbProductLevelCodeSet)|| !dbProductLevelCodeSet.contains(code)){
                        mdmTerminalSupplyDetailImportVo.appendErrorValidateMsg("行号:"+mdmTerminalSupplyDetailImportVo.getRowIndex()+",产品层级编码"+code+"不存在;");
                    }
                }
            }
        }
    }

    /**
     * 校验名称
     * @param data list
     */
    protected void validEmptyName(List<MdmTerminalSupplyDetailImportVo> data) {
        for (MdmTerminalSupplyDetailImportVo mdmTerminalSupplyDetailImportVo : data) {
            if(StringUtils.isEmpty(mdmTerminalSupplyDetailImportVo.getName())){
                mdmTerminalSupplyDetailImportVo.appendErrorValidateMsg("行号:"+mdmTerminalSupplyDetailImportVo.getRowIndex()+",供货名称不能为空;");
            }
        }
    }

    /**
     * 校验供货头型
     * @param data list
     */
    protected void validDataType(List<MdmTerminalSupplyDetailImportVo> data) {
        for (MdmTerminalSupplyDetailImportVo mdmTerminalSupplyDetailImportVo : data) {
            String dataType = mdmTerminalSupplyDetailImportVo.getDataType();
            if(!"1".equals(dataType)&&!"2".equals(dataType)){
                mdmTerminalSupplyDetailImportVo.appendErrorValidateMsg("行号:"+mdmTerminalSupplyDetailImportVo.getRowIndex()+",终端供货类型仅支持类型 1: 商品 2：产品层级");
            }
        }
    }
}
