package com.biz.crm.excel.component.validator.mdm.terminal;

import com.alibaba.excel.context.AnalysisContext;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.TestImportVo;
import com.biz.crm.excel.vo.mdm.terminal.MdmTerminalSupplyImportVo;
import com.biz.crm.mdm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.mdm.customer.model.MdmCustomerEntity;
import com.biz.crm.mdm.org.entity.MdmOrgEntity;
import com.biz.crm.mdm.org.mapper.MdmOrgMapper;
import com.biz.crm.mdm.position.entity.MdmPositionEntity;
import com.biz.crm.mdm.position.mapper.MdmPositionMapper;
import com.biz.crm.mdm.terminal.entity.MdmTerminalEntity;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.sfa.test.entity.TestImportEntity;
import com.biz.crm.sfa.test.mapper.TestImportMapper;
import com.biz.crm.util.DictUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;


/**
 * @author: luoqi
 * @Date: 2020-12-11 10:50
 * @version: V1.0
 * @Description:
 */
@Slf4j
@Component("mdmTerminalSupplyImportValidator")
public class MdmTerminalSupplyImportValidator <M extends BaseMapper<T>, T> extends AbstractExcelImportValidator<MdmTerminalMapper, MdmTerminalEntity, MdmTerminalSupplyImportVo> implements ExcelImportValidator<MdmTerminalSupplyImportVo> {

    @Resource
    private MdmTerminalMapper mdmTerminalMapper;

    @Resource
    private MdmPositionMapper mdmPositionMapper;

    @Resource
    private MdmOrgMapper mdmOrgMapper;

    @Resource
    private MdmCustomerMsgMapper mdmCustomerMsgMapper;


    @Override
    public void validate(List<MdmTerminalSupplyImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        validTerminalCode(data);
        validPositionCode(data);
        validOrgCode(data);
        validCustomerCode(data);
        validSaleCompany(data);
        validChannel(data);
    }

    /**
     * 校验渠道
     *
     * @param data list
     */
    protected void validChannel(List<MdmTerminalSupplyImportVo> data) {
        Map<String, String> map = DictUtil.dictMap("channel");
        for (MdmTerminalSupplyImportVo mdmTerminalSupplyImportVo : data) {
            String channel = mdmTerminalSupplyImportVo.getChannel();
            if (!StringUtils.isEmpty(channel)) {
                if (map == null || map.size() == 0 || map.get(channel) == null) {
                    mdmTerminalSupplyImportVo.appendErrorValidateMsg("行号:" + mdmTerminalSupplyImportVo.getRowIndex() + "数据字典channel:" + channel + "不存在;");
                }
            }
        }
    }

    /**
     * 校验销售公司
     *
     * @param data list
     */
    protected void validSaleCompany(List<MdmTerminalSupplyImportVo> data) {
        Map<String, String> map = DictUtil.dictMap("sale_company");
        for (MdmTerminalSupplyImportVo mdmTerminalSupplyImportVo : data) {
            String saleCompany = mdmTerminalSupplyImportVo.getSaleCompany();
            if (!StringUtils.isEmpty(saleCompany)) {
                if (map == null || map.size() == 0 || map.get(saleCompany) == null) {
                    mdmTerminalSupplyImportVo.appendErrorValidateMsg("行号:" + mdmTerminalSupplyImportVo.getRowIndex() + "数据字典sale_company:" + saleCompany + "不存在;");
                }
            }
        }
    }

    /**
     * 校验客户编码
     *
     * @param data list
     */
    protected void validCustomerCode(List<MdmTerminalSupplyImportVo> data) {
        LambdaQueryWrapper<MdmCustomerEntity> wrapper = Wrappers.<MdmCustomerEntity>lambdaQuery()
                .select(MdmCustomerEntity::getCustomerCode);
        Set<String> dbCustomerCodeSet = mdmCustomerMsgMapper.selectList(wrapper).stream()
                .filter(x -> x != null && !StringUtils.isEmpty(x.getCustomerCode()))
                .map(MdmCustomerEntity::getCustomerCode)
                .collect(Collectors.toSet());
        for (MdmTerminalSupplyImportVo mdmTerminalSupplyImportVo : data) {
            String customerCode = mdmTerminalSupplyImportVo.getCustomerCode();
            if (!StringUtils.isEmpty(customerCode)) {
                if (CollectionUtils.isEmpty(dbCustomerCodeSet) || !dbCustomerCodeSet.contains(customerCode)) {
                    mdmTerminalSupplyImportVo.appendErrorValidateMsg("行号:" + mdmTerminalSupplyImportVo.getRowIndex() + "客户编码不存在;");
                }
            }
        }
    }

    /**
     * 校验组织编码
     *
     * @param data list
     */
    protected void validOrgCode(List<MdmTerminalSupplyImportVo> data) {
        LambdaQueryWrapper<MdmOrgEntity> wrapper = Wrappers.<MdmOrgEntity>lambdaQuery()
                .select(MdmOrgEntity::getOrgCode);
        Set<String> dbOrgCodeSet = mdmOrgMapper.selectList(wrapper).stream()
                .filter(x -> x != null && !StringUtils.isEmpty(x.getOrgCode()))
                .map(MdmOrgEntity::getOrgCode)
                .collect(Collectors.toSet());
        for (MdmTerminalSupplyImportVo mdmTerminalSupplyImportVo : data) {
            String orgCode = mdmTerminalSupplyImportVo.getOrgCode();
            if (!StringUtils.isEmpty(orgCode)) {
                if (CollectionUtils.isEmpty(dbOrgCodeSet) || !dbOrgCodeSet.contains(orgCode)) {
                    mdmTerminalSupplyImportVo.appendErrorValidateMsg("行号:" + mdmTerminalSupplyImportVo.getRowIndex() + "组织编码不存在;");
                }
            }
        }
    }

    /**
     * 校验职位编码
     *
     * @param data list
     */
    protected void validPositionCode(List<MdmTerminalSupplyImportVo> data) {
        LambdaQueryWrapper<MdmPositionEntity> wrapper = Wrappers.<MdmPositionEntity>lambdaQuery()
                .select(MdmPositionEntity::getPositionCode);
        Set<String> dbPositionCodeList = mdmPositionMapper.selectList(wrapper).stream()
                .filter(x -> x != null && !StringUtils.isEmpty(x.getPositionCode()))
                .map(MdmPositionEntity::getPositionCode)
                .collect(Collectors.toSet());
        for (MdmTerminalSupplyImportVo mdmTerminalSupplyImportVo : data) {
            String positionCode = mdmTerminalSupplyImportVo.getPositionCode();
            if (!StringUtils.isEmpty(positionCode)) {
                if (CollectionUtils.isEmpty(dbPositionCodeList) || !dbPositionCodeList.contains(positionCode)) {
                    mdmTerminalSupplyImportVo.appendErrorValidateMsg("行号:" + mdmTerminalSupplyImportVo.getRowIndex() + "职位编码不存在;");
                }
            }
        }
    }

    /**
     * 校验终端编码
     *
     * @param data list
     */
    protected void validTerminalCode(List<MdmTerminalSupplyImportVo> data) {
        for (MdmTerminalSupplyImportVo mdmTerminalSupplyImportVo : data) {
            if (StringUtils.isEmpty(mdmTerminalSupplyImportVo.getTerminalCode())) {
                mdmTerminalSupplyImportVo.appendErrorValidateMsg("行号:" + mdmTerminalSupplyImportVo.getRowIndex() + "终端编码不能为空;");
            }
        }
        //校验数据库终端编码
        LambdaQueryWrapper<MdmTerminalEntity> wrapper = Wrappers.<MdmTerminalEntity>lambdaQuery()
                .select(MdmTerminalEntity::getTerminalCode);
        Set<String> dbTerminalCodeSet = mdmTerminalMapper.selectList(wrapper)
                .stream()
                .filter(x -> x != null && !StringUtils.isEmpty(x.getTerminalCode()))
                .map(MdmTerminalEntity::getTerminalCode)
                .collect(Collectors.toSet());
        for (MdmTerminalSupplyImportVo mdmTerminalSupplyImportVo : data) {
            String terminalCode = mdmTerminalSupplyImportVo.getTerminalCode();
            if (!StringUtils.isEmpty(terminalCode)) {
                if (CollectionUtils.isEmpty(dbTerminalCodeSet) || !dbTerminalCodeSet.contains(terminalCode)) {
                    mdmTerminalSupplyImportVo.appendErrorValidateMsg("行号:" + mdmTerminalSupplyImportVo.getRowIndex() + "终端编码不存在;");
                }
            }
        }
    }
}
