package com.biz.crm.excel.component.validator.mdm.user;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.user.MdmUserImportTreeVo;
import com.biz.crm.excel.vo.mdm.user.MdmUserImportVo;
import com.biz.crm.mdm.bpmrple.entity.MdmBpmRoleEntity;
import com.biz.crm.mdm.bpmrple.mapper.MdmBpmRoleMapper;
import com.biz.crm.mdm.org.entity.MdmOrgEntity;
import com.biz.crm.mdm.org.mapper.MdmOrgMapper;
import com.biz.crm.mdm.position.entity.MdmPositionEntity;
import com.biz.crm.mdm.position.entity.MdmPositionUserEntity;
import com.biz.crm.mdm.position.mapper.MdmPositionMapper;
import com.biz.crm.mdm.position.mapper.MdmPositionUserMapper;
import com.biz.crm.mdm.positionlevel.entity.MdmPositionLevelEntity;
import com.biz.crm.mdm.positionlevel.entity.MdmPositionLevelRoleEntity;
import com.biz.crm.mdm.positionlevel.mapper.MdmPositionLevelMapper;
import com.biz.crm.mdm.positionlevel.mapper.MdmPositionLevelRoleMapper;
import com.biz.crm.mdm.role.entity.MdmRoleEntity;
import com.biz.crm.mdm.role.mapper.MdmRoleMapper;
import com.biz.crm.mdm.user.entity.MdmUserEntity;
import com.biz.crm.mdm.user.mapper.MdmUserMapper;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.biz.crm.nebular.mdm.constant.PositionOperationEnum;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.websocket.WebsocketUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;


@Slf4j
@Component("mdmUserImportValidator")
public class MdmUserImportValidator<M extends BaseMapper<T>, T> extends AbstractExcelImportValidator<MdmUserMapper, MdmUserEntity, MdmUserImportVo> implements ExcelImportValidator<MdmUserImportVo> {

    @Resource
    private MdmUserMapper mdmUserMapper;

    @Resource
    private MdmPositionUserMapper mdmPositionUserMapper;

    @Resource
    private MdmPositionMapper mdmPositionMapper;
    @Resource
    private MdmRoleMapper mdmRoleMapper;
    @Resource
    private MdmBpmRoleMapper mdmBpmRoleMapper;
    @Resource
    private MdmPositionLevelMapper mdmPositionLevelMapper;
    @Resource
    private MdmPositionLevelRoleMapper mdmPositionLevelRoleMapper;
    @Resource
    private MdmOrgMapper mdmOrgMapper;
    @Autowired
    private WebsocketUtil websocketUtil;

    private final String PHONE_REGEX = "[1][\\d]{10}";

    /**
     * 导入校验方法
     *
     * @param data
     * @return
     */
    @Override
    public void validate(List<MdmUserImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        verify(data, context);
    }

    protected void verify(List<MdmUserImportVo> originList, DefaultImportContext context) {
        String sid = context.getImportParamVo().getWebSocketClientId();
        websocketUtil.sendMsg(sid, "开始获取校验前预加载准备数据");

        websocketUtil.sendMsg(sid, "开始获取账号预加载数据");
        //登录名已存在校验map
        Map<String, String> userNameCheckMap = new HashMap<>(16);
        Set<String> paramUserNameSet = originList.stream().filter(item -> StringUtils.isNotEmpty(item.getUserName())).map(MdmUserImportVo::getUserName).collect(Collectors.toSet());
        if (!paramUserNameSet.isEmpty()) {
            List<String> list = new ArrayList<>(paramUserNameSet);
            List<List<String>> lists = Lists.partition(list, 500);
            for (List<String> item : lists) {
                QueryWrapper<MdmUserEntity> userNameQuery = new QueryWrapper<>();
                userNameQuery.in("user_name", item);
                userNameQuery.select("user_name", "user_type");
                List<MdmUserEntity> userNameQueryEntityList = mdmUserMapper.selectList(userNameQuery);
                if (CollectionUtil.listNotEmptyNotSizeZero(userNameQueryEntityList)) {
                    userNameCheckMap.putAll(userNameQueryEntityList.stream().collect(Collectors.toMap(MdmUserEntity::getUserName, MdmUserEntity::getUserType)));
                }
            }
        }
        websocketUtil.sendMsg(sid, "结束获取账号预加载数据===>" + paramUserNameSet.size());

        websocketUtil.sendMsg(sid, "开始获取手机号预加载数据");
        Set<String> existPhoneSet = new HashSet<>(16);
        Set<String> paramPhoneSet = originList.stream().filter(item -> StringUtils.isNotEmpty(item.getEmail())).map(MdmUserImportVo::getUserPhone).collect(Collectors.toSet());
        if (!paramPhoneSet.isEmpty()) {
            List<String> list = new ArrayList<>(paramPhoneSet);
            List<List<String>> lists = Lists.partition(list, 500);
            for (List<String> item : lists) {
                QueryWrapper<MdmUserEntity> queryWrapper = new QueryWrapper<>();
                queryWrapper.in("user_phone", item);
                queryWrapper.select("user_phone");
                List<MdmUserEntity> entityList = mdmUserMapper.selectList(queryWrapper);
                if (CollectionUtil.listNotEmptyNotSizeZero(entityList)) {
                    existPhoneSet.addAll(entityList.stream().map(MdmUserEntity::getUserPhone).collect(Collectors.toList()));
                }
            }
        }
        websocketUtil.sendMsg(sid, "结束获取手机号预加载数据===>" + existPhoneSet.size());

        websocketUtil.sendMsg(sid, "开始获取邮箱预加载数据");
        Set<String> existEmailSet = new HashSet<>(16);
        Set<String> paramEmailSet = originList.stream().filter(item -> StringUtils.isNotEmpty(item.getEmail())).map(MdmUserImportVo::getEmail).collect(Collectors.toSet());
        if (!paramEmailSet.isEmpty()) {
            List<String> list = new ArrayList<>(paramEmailSet);
            List<List<String>> lists = Lists.partition(list, 500);
            for (List<String> item : lists) {
                QueryWrapper<MdmUserEntity> queryWrapper = new QueryWrapper<>();
                queryWrapper.in("email", item);
                queryWrapper.select("email");
                List<MdmUserEntity> entityList = mdmUserMapper.selectList(queryWrapper);
                if (CollectionUtil.listNotEmptyNotSizeZero(entityList)) {
                    existEmailSet.addAll(entityList.stream().map(MdmUserEntity::getEmail).collect(Collectors.toList()));
                }
            }
        }
        websocketUtil.sendMsg(sid, "结束获取邮箱预加载数据===>" + existEmailSet.size());

        websocketUtil.sendMsg(sid, "开始获取上级账号预加载数据");
        //登录名已存在校验map
        Map<String, MdmUserEntity> parentUserNameCheckMap = new HashMap<>(16);
        Map<String, MdmPositionEntity> parentUserNamePrimaryPositionMap = new HashMap<>(16);
        Set<String> paramParentUserNameSet = originList.stream().filter(item -> StringUtils.isNotEmpty(item.getParentUserName())).map(MdmUserImportVo::getParentUserName).collect(Collectors.toSet());
        if (!paramParentUserNameSet.isEmpty()) {
            List<String> list = new ArrayList<>(paramParentUserNameSet);
            List<List<String>> lists = Lists.partition(list, 500);
            for (List<String> item : lists) {
                QueryWrapper<MdmUserEntity> userNameQuery = new QueryWrapper<>();
                userNameQuery.in("user_name", item);
                userNameQuery.select("user_name", "user_type", "enable_status");
                List<MdmUserEntity> userNameQueryEntityList = mdmUserMapper.selectList(userNameQuery);
                if (CollectionUtil.listNotEmptyNotSizeZero(userNameQueryEntityList)) {
                    parentUserNameCheckMap.putAll(userNameQueryEntityList.stream().collect(Collectors.toMap(MdmUserEntity::getUserName, v -> v)));
                    QueryWrapper<MdmPositionUserEntity> positionUserQuery = new QueryWrapper<>();
                    positionUserQuery.eq("primary_flag", YesNoEnum.yesNoEnum.ONE.getValue());
                    positionUserQuery.in("user_name", userNameQueryEntityList.stream().map(MdmUserEntity::getUserName).collect(Collectors.toSet()));
                    positionUserQuery.select("user_name", "position_code");
                    List<MdmPositionUserEntity> positionUserEntityList = mdmPositionUserMapper.selectList(positionUserQuery);
                    if (CollectionUtil.listNotEmptyNotSizeZero(positionUserEntityList)) {
                        QueryWrapper<MdmPositionEntity> positionQuery = new QueryWrapper<>();
                        positionQuery.in("position_code", positionUserEntityList.stream().map(MdmPositionUserEntity::getPositionCode).collect(Collectors.toSet()));
                        positionQuery.select("position_code", "position_name", "org_code", "enable_status");
                        final Map<String, MdmPositionEntity> parentPositionMap = mdmPositionMapper.selectList(positionQuery).stream().collect(Collectors.toMap(MdmPositionEntity::getPositionCode, v -> v));
                        if (!parentPositionMap.isEmpty()) {
                            parentUserNamePrimaryPositionMap.putAll(positionUserEntityList.stream().filter(x -> parentPositionMap.containsKey(x.getPositionCode())).collect(Collectors.toMap(MdmPositionUserEntity::getUserName, v -> parentPositionMap.get(v.getPositionCode()))));
                        }
                    }
                }
            }
        }
        websocketUtil.sendMsg(sid, "结束获取上级账号预加载数据===>" + paramEmailSet.size());

        websocketUtil.sendMsg(sid, "开始获取性别预加载数据");
        //性别名称：编码map
        Map<String, String> genderValueCodeMap = DictUtil.dictRevertMap(DictConstant.GENDER);
        websocketUtil.sendMsg(sid, "结束获取性别预加载数据===>" + genderValueCodeMap.size());

        websocketUtil.sendMsg(sid, "开始获取职位操作类型预加载数据");
        //操作类型 名称：编码map
        Map<String, String> operationValueCodeMap = DictUtil.dictRevertMap(DictConstant.POSITION_OPERATION);
        websocketUtil.sendMsg(sid, "结束获取职位操作类型预加载数据===>" + operationValueCodeMap.size());

        websocketUtil.sendMsg(sid, "开始获取职位预加载数据");
        Map<String, MdmPositionEntity> positionMap = new HashMap<>(16);
        Map<String, MdmPositionUserEntity> positionRelUserMap = new HashMap<>(16);
        Set<String> paramPositionCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty(item.getPrimaryPositionCode())).map(MdmUserImportVo::getPrimaryPositionCode).collect(Collectors.toSet());
        for (MdmUserImportVo item : originList) {
            if (StringUtils.isNotEmpty(item.getOtherPositionCodes())) {
                paramPositionCodeSet.addAll(Arrays.asList(item.getOtherPositionCodes().split(",")));
            }
        }
        if (!paramPositionCodeSet.isEmpty()) {
            List<String> list = new ArrayList<>(paramPositionCodeSet);
            List<List<String>> lists = Lists.partition(list, 500);
            for (List<String> item : lists) {
                QueryWrapper<MdmPositionEntity> primaryPositionQuery = new QueryWrapper<>();
                primaryPositionQuery.in("position_code", item);
                List<MdmPositionEntity> primaryPositionEntityList = mdmPositionMapper.selectList(primaryPositionQuery);
                if (CollectionUtil.listNotEmptyNotSizeZero(primaryPositionEntityList)) {
                    positionMap.putAll(primaryPositionEntityList.stream().collect(Collectors.toMap(MdmPositionEntity::getPositionCode, v -> v)));
                    QueryWrapper<MdmPositionUserEntity> queryWrapper = new QueryWrapper<>();
                    queryWrapper.in("position_code", item);
                    positionRelUserMap.putAll(mdmPositionUserMapper.selectList(queryWrapper).stream().collect(Collectors.toMap(MdmPositionUserEntity::getPositionCode, v -> v)));
                }
            }

        }
        websocketUtil.sendMsg(sid, "结束获取职位预加载数据===>" + positionRelUserMap.size());

        websocketUtil.sendMsg(sid, "开始获取权限角色预加载数据");
        Set<String> paramRoleCodeSet = originList.stream().filter(x -> StringUtils.isNotEmpty(x.getRoleCode())).flatMap(x -> Arrays.stream(x.getRoleCode().split(","))).collect(Collectors.toSet());
        Map<String, MdmRoleEntity> roleMap = new HashMap<>(16);
        if (!paramRoleCodeSet.isEmpty()) {
            QueryWrapper<MdmRoleEntity> roleQuery = new QueryWrapper<>();
            roleQuery.in("role_code", paramRoleCodeSet);
            roleQuery.select("role_code", "role_name", "enable_status");
            roleMap.putAll(mdmRoleMapper.selectList(roleQuery)
                    .stream().collect(Collectors.toMap(MdmRoleEntity::getRoleCode, v -> v)));
        }
        websocketUtil.sendMsg(sid, "结束获取权限角色预加载数据===>" + roleMap.size());

        websocketUtil.sendMsg(sid, "开始获取流程角色预加载数据");
        Set<String> paramBpmRoleCodeSet = originList.stream().filter(x -> StringUtils.isNotEmpty(x.getBpmRoleCode())).flatMap(x -> Arrays.stream(x.getBpmRoleCode().split(","))).collect(Collectors.toSet());
        Map<String, MdmBpmRoleEntity> bpmRoleMap = new HashMap<>(16);
        if (!paramBpmRoleCodeSet.isEmpty()) {
            QueryWrapper<MdmBpmRoleEntity> bpmRoleQuery = new QueryWrapper<>();
            bpmRoleQuery.in("bpm_role_code", paramBpmRoleCodeSet);
            bpmRoleQuery.select("bpm_role_code", "bpm_role_name", "enable_status");
            bpmRoleMap.putAll(mdmBpmRoleMapper.selectList(bpmRoleQuery)
                    .stream().collect(Collectors.toMap(MdmBpmRoleEntity::getBpmRoleCode, v -> v)));
        }
        websocketUtil.sendMsg(sid, "结束获取流程角色预加载数据===>" + bpmRoleMap.size());

        websocketUtil.sendMsg(sid, "开始获取职位级别预加载数据");
        Set<String> paramPositionLevelCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty(item.getPositionLevelCode())).map(MdmUserImportVo::getPositionLevelCode).collect(Collectors.toSet());
        Map<String, MdmPositionLevelEntity> positionLevelMap = new HashMap<>(16);
        if (!paramPositionLevelCodeSet.isEmpty()) {
            QueryWrapper<MdmPositionLevelEntity> positionLevelQuery = new QueryWrapper<>();
            positionLevelQuery.in("position_level_code", paramPositionLevelCodeSet);
            positionLevelQuery.select("position_level_code", "position_level_name", "enable_status");
            positionLevelMap.putAll(mdmPositionLevelMapper.selectList(positionLevelQuery)
                    .stream().collect(Collectors.toMap(MdmPositionLevelEntity::getPositionLevelCode, v -> v)));
        }
        websocketUtil.sendMsg(sid, "结束获取职位级别预加载数据===>" + positionLevelMap.size());

        websocketUtil.sendMsg(sid, "开始获取职位级别关联权限角色预加载数据");
        Set<String> strings = positionLevelMap.keySet();
        Map<String, List<String>> positionLevelRoleMap = new HashMap<>(16);
        if (!strings.isEmpty()) {
            QueryWrapper<MdmPositionLevelRoleEntity> positionLevelRoleQuery = new QueryWrapper<>();
            positionLevelRoleQuery.in("position_level_code", strings);
            positionLevelRoleQuery.select("position_level_code", "role_code");
            positionLevelRoleMap.putAll(mdmPositionLevelRoleMapper.selectList(positionLevelRoleQuery)
                    .stream().collect(Collectors.groupingBy(MdmPositionLevelRoleEntity::getPositionLevelCode, Collectors.mapping(MdmPositionLevelRoleEntity::getRoleCode, Collectors.toList()))));
        }
        websocketUtil.sendMsg(sid, "结束获取职位级别关联权限角色预加载数据===>" + positionLevelRoleMap.size());

        websocketUtil.sendMsg(sid, "开始获取企业组织预加载数据");
        Set<String> paramOrgCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty(item.getOrgCode())).map(MdmUserImportVo::getOrgCode).collect(Collectors.toSet());
        Map<String, MdmOrgEntity> orgMap = new HashMap<>(16);
        if (!paramOrgCodeSet.isEmpty()) {
            QueryWrapper<MdmOrgEntity> orgQuery = new QueryWrapper<>();
            orgQuery.in("org_code", paramOrgCodeSet);
            orgQuery.select("org_code", "org_name", "enable_status", "parent_code");
            orgMap.putAll(mdmOrgMapper.selectList(orgQuery)
                    .stream().collect(Collectors.toMap(MdmOrgEntity::getOrgCode, v -> v)));
        }
        websocketUtil.sendMsg(sid, "结束获取企业组织预加载数据===>" + orgMap.size());
        websocketUtil.sendMsg(sid, "结束获取校验前预加载准备数据");


        Map<String, Integer> userNameIndexMap = new HashMap<>(16);
        Map<String, Integer> emailIndexMap = new HashMap<>(16);
        Map<String, Integer> phoneIndexMap = new HashMap<>(16);
        Map<String, Integer> primaryPositionIndexMap = new HashMap<>(16);
        Map<String, Integer> otherPositionIndexMap = new HashMap<>(16);
        int count = 1;
        int total = originList.size();
        websocketUtil.sendMsg(sid, "开始执行第一次遍历进行常规校验");

        for (MdmUserImportVo item :
                originList) {

            //校验账号
            if (StringUtils.isEmpty(item.getUserName())) {
                item.appendErrorValidateMsg("缺失账号；");
            } else {
                if (userNameIndexMap.containsKey(item.getUserName())) {
                    item.appendErrorValidateMsg("账号与第" + userNameIndexMap.get(item.getUserName()) + "行重复；");
                } else {
                    userNameIndexMap.put(item.getUserName(), item.getRowIndex());
                }
                if (userNameCheckMap.containsKey(item.getUserName())) {
                    item.appendErrorValidateMsg("账号已存在；");
                }
            }

            //校验姓名
            if (StringUtils.isEmpty(item.getFullName())) {
                item.appendErrorValidateMsg("缺失用户名；");
            }

            //校验性别
            if (StringUtils.isNotEmpty(item.getGenderName())) {
                if (!genderValueCodeMap.containsKey(item.getGenderName())) {
                    item.appendErrorValidateMsg("性别无效；");
                } else {
                    item.setGender(genderValueCodeMap.get(item.getGenderName()));
                }
            }

            //校验密码
            if (StringUtils.isEmpty(item.getUserPassword())) {
                item.appendErrorValidateMsg("缺失密码；");
            }

            //电话校验
            if (StringUtils.isNotEmpty(item.getUserPhone())) {
                if (existPhoneSet.contains(item.getUserPhone())) {
                    item.appendErrorValidateMsg("联系电话已存在；");
                } else {
                    if (!item.getUserPhone().matches(PHONE_REGEX)) {
                        item.appendErrorValidateMsg("联系电话格式不正确；");
                    }
                    if (phoneIndexMap.containsKey(item.getUserPhone())) {
                        item.appendErrorValidateMsg("联系电话与第" + phoneIndexMap.get(item.getUserPhone()) + "行重复；");
                    } else {
                        phoneIndexMap.put(item.getUserPhone(), item.getRowIndex());
                    }
                }
            }

            //邮箱
            if (StringUtils.isNotEmpty(item.getEmail())) {
                if (existEmailSet.contains(item.getEmail())) {
                    item.appendErrorValidateMsg("邮箱已存在；");
                    if ((item.getEmail().length() - item.getEmail().replace("@", "").length()) != 1) {
                        item.appendErrorValidateMsg("邮箱格式不正确；");
                    }
                    if (emailIndexMap.containsKey(item.getEmail())) {
                        item.appendErrorValidateMsg("邮箱与第" + emailIndexMap.get(item.getEmail()) + "行重复；");
                    } else {
                        emailIndexMap.put(item.getEmail(), item.getRowIndex());
                    }
                }
            }

            //生效时间
            if (StringUtils.isEmpty(item.getStartTime())) {
                item.appendErrorValidateMsg("缺失生效时间；");
            } else {
                if (!verifyDateFormat(item.getStartTime(), DateUtil.DEFAULT_DAY_PATTERN)) {
                    item.appendErrorValidateMsg("生效时间格式不合法；");
                }
            }

            //失效时间
            if (StringUtils.isEmpty(item.getEndTime())) {
                item.appendErrorValidateMsg("缺失失效时间；");
            } else {
                if (!verifyDateFormat(item.getEndTime(), DateUtil.DEFAULT_DAY_PATTERN)) {
                    item.appendErrorValidateMsg("失效时间格式不合法；");
                }
            }

            //校验操作类型
            if (StringUtils.isEmpty(item.getOperationTypeName())) {
                item.appendErrorValidateMsg("缺失操作类型；");
            } else if (!operationValueCodeMap.containsKey(item.getOperationTypeName())) {
                item.appendErrorValidateMsg("操作类型不存在；");
            } else {
                item.setOperationType(operationValueCodeMap.get(item.getOperationTypeName()));
                if (PositionOperationEnum.NEW.getCode().equals(item.getOperationType())) {
                    //新建职位


                    if (StringUtils.isEmpty(item.getOrgCode())) {
                        item.appendErrorValidateMsg("缺失所属组织编码；");
                    } else if (!orgMap.containsKey(item.getOrgCode())) {
                        item.appendErrorValidateMsg("组织编码不存在；");
                    } else if (CrmEnableStatusEnum.DISABLE.getCode().equals(orgMap.get(item.getOrgCode()).getEnableStatus())) {
                        item.appendErrorValidateMsg("组织已经停用；");
                    } else {
                    }

                    if (StringUtils.isEmpty(item.getPositionLevelCode())) {
                        item.appendErrorValidateMsg("缺失职位级别编码；");
                    } else if (!positionLevelMap.containsKey(item.getPositionLevelCode())) {
                        item.appendErrorValidateMsg("职位级别不存在；");
                    } else if (CrmEnableStatusEnum.DISABLE.getCode().equals(positionLevelMap.get(item.getPositionLevelCode()).getEnableStatus())) {
                        item.appendErrorValidateMsg("职位级别已经停用；");
                    } else {
                    }

                    if (StringUtils.isNotEmpty(item.getRoleCode())) {
                        for (String roleCode :
                                item.getRoleCode().split(",")) {
                            if (!roleMap.containsKey(roleCode)) {
                                item.appendErrorValidateMsg("权限角色编码" + roleCode + "不存在；");
                            } else if (CrmEnableStatusEnum.DISABLE.getCode().equals(roleMap.get(roleCode).getEnableStatus())) {
                                item.appendErrorValidateMsg("权限角色编码" + roleCode + "已停用；");
                            } else {

                            }
                        }
                    }

                    if (StringUtils.isNotEmpty(item.getBpmRoleCode())) {
                        for (String bpmRoleCode :
                                item.getBpmRoleCode().split(",")) {
                            if (!bpmRoleMap.containsKey(bpmRoleCode)) {
                                item.appendErrorValidateMsg("流程角色编码" + bpmRoleCode + "不存在；");
                            } else if (CrmEnableStatusEnum.DISABLE.getCode().equals(bpmRoleMap.get(bpmRoleCode).getEnableStatus())) {
                                item.appendErrorValidateMsg("流程角色编码" + bpmRoleCode + "已停用；");
                            } else {

                            }
                        }
                    }

                } else if (PositionOperationEnum.HISTORY.getCode().equals(item.getOperationType())) {
                    //已有职位

                    //主职位
                    if (StringUtils.isEmpty(item.getPrimaryPositionCode())) {
                        item.appendErrorValidateMsg("缺失主职位编码；");
                    } else {
                        if (!positionMap.containsKey(item.getPrimaryPositionCode())) {
                            item.appendErrorValidateMsg("主职位编码无效；");
                        } else {
                            if (positionRelUserMap.containsKey(item.getPrimaryPositionCode()) && YesNoEnum.yesNoEnum.ONE.getValue().equals(positionRelUserMap.get(item.getPrimaryPositionCode()).getPrimaryFlag())) {
                                item.appendErrorValidateMsg("主职位已经是其它用户的主职位；");
                            }
                        }
                        if (primaryPositionIndexMap.containsKey(item.getPrimaryPositionCode())) {
                            item.appendErrorValidateMsg("主职位与第" + primaryPositionIndexMap.get(item.getPrimaryPositionCode()) + "行主职位重复；");
                        } else {
                            primaryPositionIndexMap.put(item.getPrimaryPositionCode(), item.getRowIndex());
                        }

                        if (otherPositionIndexMap.containsKey(item.getPrimaryPositionCode())) {
                            item.appendErrorValidateMsg("主职位在第" + otherPositionIndexMap.get(item.getPrimaryPositionCode()) + "行已存在；");
                        }
                    }

                    //其它职位
                    if (StringUtils.isNotEmpty(item.getOtherPositionCodes())) {
                        for (String positionCode :
                                item.getOtherPositionCodes().split(",")) {
                            if (!positionMap.containsKey(positionCode)) {
                                item.appendErrorValidateMsg("职位编码[" + positionCode + "]无效；");
                            } else {
                                if (positionRelUserMap.containsKey(item.getPrimaryPositionCode()) && YesNoEnum.yesNoEnum.ONE.getValue().equals(positionRelUserMap.get(item.getPrimaryPositionCode()).getPrimaryFlag())) {
                                    item.appendErrorValidateMsg("职位[" + positionCode + "]已经是其它用户的主职位；");
                                }
                            }
                            if (primaryPositionIndexMap.containsKey(positionCode)) {
                                item.appendErrorValidateMsg("职位编码[" + positionCode + "]与第" + primaryPositionIndexMap.get(positionCode) + "行主职位重复；");
                            }
                            if (otherPositionIndexMap.containsKey(positionCode)) {
                                item.appendErrorValidateMsg("职位编码[" + positionCode + "]在第" + otherPositionIndexMap.get(positionCode) + "行已存在；");
                            } else {
                                otherPositionIndexMap.put(positionCode, item.getRowIndex());
                            }
                        }
                    }

                } else {

                }
            }

            if (count > 1 && count % 300 == 0) {
                websocketUtil.sendMsg(sid, "第一次遍历已校验数据===>" + count + "条，共" + total + "条");
            }
            count++;
        }

        websocketUtil.sendMsg(sid, "结束执行第一次遍历常规校验===>" + total);

        verifyParent(originList, context, sid, parentUserNameCheckMap, parentUserNamePrimaryPositionMap);
    }

    protected void verifyParent(List<MdmUserImportVo> originList, DefaultImportContext context, String sid, Map<String, MdmUserEntity> parentUserNameCheckMap, Map<String, MdmPositionEntity> parentUserNamePrimaryPositionMap) {
        websocketUtil.sendMsg(sid, "开始第二次遍历校验上级用户");
//        final Map<String, MdmUserImportVo> originUserMap = originList.stream().filter(x -> StringUtils.isNotEmpty(x.getUserName())).collect(Collectors.toMap(MdmUserImportVo::getUserName, v -> v));

//        List<MdmUserImportTreeVo> list = new ArrayList<>();
        int total = originList.size();
        int count = 1;

        Map<String, MdmUserImportTreeVo> map = new HashMap<>(16);
        for (MdmUserImportVo item :
                originList) {
            if (StringUtils.isNotEmpty(item.getUserName())) {
                MdmUserImportTreeVo vo = new MdmUserImportTreeVo();
                vo.setRowIndex(item.getRowIndex());
                vo.setUserName(item.getUserName());
                vo.setParentUserName(item.getParentUserName());
                vo.setSuccess(MdmUserImportVo.ProcessTypeEnum.SUCCESS == item.getProcessType());

//                if (PositionOperationEnum.NEW.getCode().equals(item.getOperationType())) {
//                    //新建职位
//                    vo.setPrimaryPositionCode(UUID.randomUUID().toString().replace("-", ""));
//                } else if (PositionOperationEnum.HISTORY.getCode().equals(item.getOperationType())) {
//                    //已有职位
//                    vo.setPrimaryPositionCode(item.getPrimaryPositionCode());
//                } else {
//
//                }
                map.put(item.getUserName(), vo);
            }
            if (count > 1 && count % 300 == 0) {
                websocketUtil.sendMsg(sid, "第二次遍历已校验数据===>第" + count + "条，共" + total + "条");
            }
            count++;
        }

        for (MdmUserImportVo item :
                originList) {
            if (StringUtils.isNotEmpty(item.getUserName())) {

                if (PositionOperationEnum.NEW.getCode().equals(item.getOperationType())) {
                    if (StringUtils.isNotEmpty(item.getParentUserName())) {
                        if (parentUserNameCheckMap.containsKey(item.getParentUserName())) {
                            //上级职位在数据库中

                            MdmUserEntity mdmUserEntity = parentUserNameCheckMap.get(item.getParentUserName());
                            if (CrmEnableStatusEnum.DISABLE.getCode().equals(mdmUserEntity.getEnableStatus())) {
                                item.appendErrorValidateMsg("上级用户已停用；");
                            } else if (!parentUserNamePrimaryPositionMap.containsKey(item.getParentUserName())) {
                                item.appendErrorValidateMsg("上级用户没有主职位；");
                            } else if (CrmEnableStatusEnum.DISABLE.getCode().equals(parentUserNamePrimaryPositionMap.get(item.getParentUserName()).getEnableStatus())) {
                                item.appendErrorValidateMsg("上级用户的主职位被停用；");
                            } else {
//                                map.get(item.getUserName()).setParentPositionCode(parentUserNamePrimaryPositionMap.get(item.getParentUserName()).getPositionCode());
                            }

                        } else if (map.containsKey(item.getParentUserName())) {
                            //上级在excel中
//                            map.get(item.getUserName()).setParentPositionCode(map.get(item.getParentUserName()).getPrimaryPositionCode());
                        } else {
                            item.appendErrorValidateMsg("上级用户不存在；");
                        }
                    }
                }
            }
        }

        List<MdmUserImportTreeVo> collect = new ArrayList<>(map.values());

        Set<String> set = new HashSet<>(16);
        List<MdmUserImportTreeVo> tree = generateTree(collect, set);

        Set<Integer> parentErrorRowIndexSet = new HashSet<>(16);
        for (MdmUserImportTreeVo node :
                tree) {
            if (CollectionUtil.listNotEmptyNotSizeZero(node.getChildren())) {
                setCheckChildren(node, node.getChildren(), parentErrorRowIndexSet);
            }
        }

        for (MdmUserImportVo item :
                originList) {
            if (parentErrorRowIndexSet.contains(item.getRowIndex())) {
                item.appendErrorValidateMsg("上级校验未通过；");
            }
            if (StringUtils.isNotEmpty(item.getUserName())) {
                if (!set.contains(item.getUserName())) {
                    item.appendErrorValidateMsg("当前数据的上下级可能构成环状结构；");
                }
            }
        }

        websocketUtil.sendMsg(sid, "结束第二次遍历校验上级用户===>" + total);
    }

    protected void setCheckChildren(MdmUserImportTreeVo node, List<MdmUserImportTreeVo> children, Set<Integer> parentErrorRowIndexSet) {
        for (MdmUserImportTreeVo child :
                children) {
            if (!node.isSuccess()) {
                child.setSuccess(false);
                parentErrorRowIndexSet.add(child.getRowIndex());
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(child.getChildren())) {
                setCheckChildren(child, child.getChildren(), parentErrorRowIndexSet);
            }
        }
    }

    private List<MdmUserImportTreeVo> generateTree(List<MdmUserImportTreeVo> totalList, Set<String> set) {

        //构建树list
        List<MdmUserImportTreeVo> treeList = new ArrayList<>();
        //当前操作层级数据
        List<MdmUserImportTreeVo> curLevelList = new ArrayList<>();
        //未操作数据
        List<MdmUserImportTreeVo> restList = new ArrayList<>();

        //key:id
        Map<String, MdmUserImportTreeVo> totalMap = totalList.stream().collect(Collectors.toMap(MdmUserImportTreeVo::getUserName, v -> v));

        //查找第一层
        for (MdmUserImportTreeVo item :
                totalList) {
            if (StringUtils.isEmpty(item.getParentUserName()) || !totalMap.containsKey(item.getParentUserName())) {
                treeList.add(item);
                set.add(item.getUserName());
                curLevelList.add(item);
            } else {
                restList.add(item);
            }
        }

        //构建数据，从第二层开始
        while (curLevelList.size() > 0 && restList.size() > 0) {
            List<MdmUserImportTreeVo> restTempList = new ArrayList<>();
            List<MdmUserImportTreeVo> curLevelTempList = new ArrayList<>();
            Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(MdmUserImportTreeVo::getUserName, MdmUserImportTreeVo::getUserName));
            Map<String, List<MdmUserImportTreeVo>> curLevelChildrenMap = new HashMap<>();

            for (MdmUserImportTreeVo item :
                    restList) {
                if (curLevelMap.containsKey(item.getParentUserName())) {
                    curLevelTempList.add(item);

                    List<MdmUserImportTreeVo> childrenList = new ArrayList<>();
                    if (curLevelChildrenMap.containsKey(item.getParentUserName())) {
                        childrenList.addAll(curLevelChildrenMap.get(item.getParentUserName()));
                    }
                    childrenList.add(item);
                    set.add(item.getUserName());
                    curLevelChildrenMap.put(item.getParentUserName(), childrenList);
                } else {
                    restTempList.add(item);
                }
            }

            for (MdmUserImportTreeVo item :
                    curLevelList) {
                if (curLevelChildrenMap.containsKey(item.getUserName())) {
                    item.setChildren(curLevelChildrenMap.get(item.getUserName()));
                }
            }

            curLevelList.clear();
            curLevelList.addAll(curLevelTempList);
            restList.clear();
            restList.addAll(restTempList);
        }

        return treeList;
    }

    protected boolean verifyDateFormat(String dataStr, String formatStr) {
        boolean flag = false;
        if (StringUtils.isNotEmpty(dataStr) && StringUtils.isNotEmpty(formatStr)) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
                Date parse = sdf.parse(dataStr);
                String dateFormatStr = sdf.format(parse);
                if (dataStr.equals(dateFormatStr)) {
                    flag = true;
                }
            } catch (Exception e) {

            }
        }
        return flag;
    }
}
