package com.biz.crm.excel.component.validator.sfa;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.sfa.SfaIndexImportVo;
import com.biz.crm.sfa.test.entity.SfaIndexEntity;
import com.biz.crm.sfa.test.mapper.SfaIndexMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.List;


/**
 *  @author: yangshan
 *  @Date: 2021-3-3 10:56:18
 */
@Slf4j
@Component("sfaIndexValidator")
public class SfaIndexValidator<M extends BaseMapper<T>, T> extends AbstractExcelImportValidator<SfaIndexMapper, SfaIndexEntity, SfaIndexImportVo> implements ExcelImportValidator<SfaIndexImportVo> {

    @Autowired
    private SfaIndexMapper indexMapper;
    /**
     * 导入校验方法
     *
     * @param data
     * @return
     */
    @Override
    public void validate(List<SfaIndexImportVo> data, DefaultImportContext context) {
        if(CollectionUtils.isEmpty(data)){
            return;
        }

        data.forEach(v -> {
            StringBuilder msg = new StringBuilder();
            if(StringUtils.isBlank(v.getIndexCode())){
                msg.append("指标编码不能为空;");
            }
            if(StringUtils.isBlank(v.getIndexName())){
                msg.append("指标名称不能为空;");
            }
            this.doCheckIndex(v.getIndexCode(), v.getIndexName(), msg);
            if(StringUtils.isNotBlank(msg)){
                this.errorMsgAndSendWebsocket(v, msg.toString(), context);
            }

        });
    }
    /**
     * 指标校验
     * @param indexCode
     * @param indexName
     */
    public void doCheckIndex(String indexCode, String indexName, StringBuilder msg){
        QueryWrapper<SfaIndexEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("index_code", indexCode)
                .eq("index_name", indexName);
        SfaIndexEntity entity = indexMapper.selectOne(wrapper);
        if (!ObjectUtils.isEmpty(entity)){
            msg.append("已存在的指标;");
        }
    }
}
