package com.biz.crm.excel.component.validator.sfa;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.TestImportVo;
import com.biz.crm.sfa.test.entity.TestImportEntity;
import com.biz.crm.sfa.test.mapper.TestImportMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;


/**
 *  @author: luoqi
 *  @Date: 2020-12-11 10:50
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Component("testValidator")
public class TestValidator<M extends BaseMapper<T>, T> extends AbstractExcelImportValidator<TestImportMapper, TestImportEntity, TestImportVo> implements ExcelImportValidator<TestImportVo> {
    /**
     * 导入校验方法
     *
     * @param data
     * @return
     */
    @Override
    public void validate(List<TestImportVo> data, DefaultImportContext context) {
        if(CollectionUtils.isEmpty(data)){
            return;
        }
        String temp = "admin,test-user1,test-user2";

        data.forEach(v -> {
            StringBuilder msg = new StringBuilder();
            if(StringUtils.isBlank(v.getFullName())){
                msg.append("用户名不能为空;");
            }
            if(StringUtils.isBlank(v.getUserName())){
                msg.append("用户账号不能为空;");
            }else if(temp.contains(v.getUserName())){
                msg.append("已存在的用户账号;");
            }
            if(StringUtils.isNotBlank(msg)){
                this.errorMsgAndSendWebsocket(v, msg.toString(), context);
            }

        });
    }
}
