package com.biz.crm.excel.component.validator.sfa.visitgroup;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.sfa.SfaVisitGroupImportVo;
import com.biz.crm.sfa.test.entity.SfaVisitGroupEntity;
import com.biz.crm.sfa.test.mapper.SfaVisitGroupMapper;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author lf
 * @describe 线路组导入验证
 * @project crm
 * @package com.biz.crm.excel.component.validator.sfa.visitgroup
 * @date 2021/5/27 15:05
 */
@Slf4j
@Component("sfaVisitGroupImportValidator")
public class SfaVisitGroupImportValidator<M extends BaseMapper<T>, T> extends AbstractExcelImportValidator<SfaVisitGroupMapper, SfaVisitGroupEntity, SfaVisitGroupImportVo> implements ExcelImportValidator<SfaVisitGroupImportVo> {


    private final static String DEALER = "0";

    private final static String TERMINAL = "1";

    @Override
    public void validate(List<SfaVisitGroupImportVo> data, DefaultImportContext context) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(data)){
            return;
        }
    }

    /**
     * 校验参数信息
     * @param data
     */
    private void checkData(List<SfaVisitGroupImportVo> data){
        data.forEach(da->{
            if (StringUtils.isEmpty(da.getGroupName())){
                da.appendErrorValidateMsg("线路组名称不能为空");
            }
            if (StringUtils.isEmpty(da.getPosCode())){
                da.appendErrorValidateMsg("职位编码不能为空");
            }
            if (StringUtils.isEmpty(da.getPosName())){
                da.appendErrorValidateMsg("职位名称不能为空");
            }
            if (StringUtils.isEmpty(da.getCode())){
                da.appendErrorValidateMsg("经销商/终端编码不能为空");
            }
            if (StringUtils.isEmpty(da.getName())){
                da.appendErrorValidateMsg("经销商/终端名称不能为空");
            }
            if (StringUtils.isEmpty(da.getType())){
                da.appendErrorValidateMsg("客户类型不能为空");
            }else {
                if (!(da.getType().equals(DEALER) || da.getType().equals(TERMINAL))){
                    da.appendErrorValidateMsg("客户类型错误(0-经销商,1-终端)");
                }
            }

        });
    }
}
