package com.biz.crm.excel.component.validator.tpm.auditinvoice;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.component.validator.tpm.invoicecommon.InvoiceCheckHelper;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.tpm.auditinvoice.TpmAuditInvoiceImportVo;
import com.biz.crm.excel.vo.tpm.invoice.TpmInvoiceImportVo;
import com.biz.crm.tpm.invoicepool.mapper.TpmInvoicePoolMapper;
import com.biz.crm.tpm.invoicepool.model.TpmInvoicePoolEntity;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.HashSet;
import java.util.List;

/**
 * @author yb
 * @version 1.0
 * @date 2021/12/10 14:01
 * @description
 */
@Component("tpmAuditInvoiceImportValidator")
public class TpmAuditInvoiceImportValidator<M extends BaseMapper<T>, T>  extends AbstractExcelImportValidator<TpmInvoicePoolMapper, TpmInvoicePoolEntity, TpmAuditInvoiceImportVo> implements ExcelImportValidator <TpmAuditInvoiceImportVo> {

    @Resource
    private InvoiceCheckHelper invoiceCheckHelper;

    @Override
    public void validate(List<TpmAuditInvoiceImportVo> data, DefaultImportContext context) {
        HashSet<String> unique = new HashSet<>();
        data.forEach(o -> {
            invoiceCheckHelper.validateAuditInvoice(o, unique);
        });
    }
}
