package com.biz.crm.excel.component.validator.tpm.budgetgeneraterule;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.tpm.FeeBudgetTypeEnum;
import com.biz.crm.excel.component.helper.MdmPropertyCheckHelper;
import com.biz.crm.excel.component.saver.tpm.FeeBudgetServiceHelper;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.util.ImportVoCheckUtil;
import com.biz.crm.excel.vo.tpm.budgetgeneraterule.TpmBudgetGenerateRuleImportVo;
import com.biz.crm.tpm.budgetgeneraterule.mapper.TpmBudgetGenerateRuleMapper;
import com.biz.crm.tpm.budgetgeneraterule.model.TpmBudgetGenerateRuleEntity;
import com.biz.crm.tpm.feebudget.model.TpmBudgetSubjectsEntity;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author yb
 * @version 1.0
 * @date 2021/12/10 14:01
 * @description
 */
@Component("tpmBudgetGenerateRuleImportValidator")
public class TpmBudgetGenerateRuleImportValidator <M extends BaseMapper<T>, T>  extends AbstractExcelImportValidator<TpmBudgetGenerateRuleMapper, TpmBudgetGenerateRuleEntity, TpmBudgetGenerateRuleImportVo > implements ExcelImportValidator <TpmBudgetGenerateRuleImportVo> {

    @Resource
    private TpmBudgetGenerateRuleMapper tpmBudgetGenerateRuleMapper;

    @Resource
    private FeeBudgetServiceHelper feeBudgetServiceHelper;

    @Resource
    private MdmPropertyCheckHelper mdmPropertyCheckHelper;

    @Override
    public void validate(List<TpmBudgetGenerateRuleImportVo> data, DefaultImportContext context) {
        Map<String, TpmBudgetSubjectsEntity> budgetSubjectsEntityMap = feeBudgetServiceHelper.getSubjectMap(data.stream().filter(importVo ->  importVo.getBudgetSubjectCode() != null).map(TpmBudgetGenerateRuleImportVo::getBudgetSubjectCode).collect(Collectors.toSet()));
        HashSet<String> unique = new HashSet<>();
        data.forEach(importVo -> {
            ImportVoCheckUtil.checkNotNull(importVo, importVo.getBudgetRuleName(), "预算规则名称");
            if(ImportVoCheckUtil.isNotNull(importVo, importVo.getBudgetSubjectCode(), "预算科目编码")){
                TpmBudgetSubjectsEntity tpmBudgetSubjectsEntity;
                if((tpmBudgetSubjectsEntity = budgetSubjectsEntityMap.get(importVo.getBudgetSubjectCode())) == null){
                    importVo.appendErrorValidateMsg("未找到对应预算科目;");
                }else if(org.apache.commons.lang3.StringUtils.equals(CrmEnableStatusEnum.DISABLE.getCode(),tpmBudgetSubjectsEntity.getEnableStatus())){
                    importVo.appendErrorSaveMsg("预算科目尚未启用;");
                } else  {
                    importVo.setBudgetSubjectName(tpmBudgetSubjectsEntity.getBudgetSubjectsName());
                }
            }
            importVo.setYear(ImportVoCheckUtil.getAndCheckDict(importVo, importVo.getYear(), "年份", TpmGlobalDictConstants.BUDGET_YEAR));
            importVo.setMonth(ImportVoCheckUtil.getAndCheckDict(importVo, importVo.getMonth(), "月份", TpmGlobalDictConstants.BUDGET_MONTH_TRUE));
            if(ImportVoCheckUtil.isNotNull(importVo, importVo.getRatio(), "比例")){
                if(importVo.getRatio().compareTo(BigDecimal.ZERO) < 0 || importVo.getRatio().compareTo(new BigDecimal(100)) > 0){
                    importVo.appendErrorValidateMsg("比例应在0~100之间的;");
                }
            }
            if(StringUtils.isNotBlank(importVo.getChannelName())){
                importVo.setChannel(ImportVoCheckUtil.getAndCheckDict(importVo, importVo.getChannelName(),"渠道" ,TpmGlobalDictConstants.CHANNEL));
            }
            checkDimension(importVo);
            checkIsExist(importVo, unique);
        });
    }

    private void checkDimension(TpmBudgetGenerateRuleImportVo importVo){
        String code;
        if((code = ImportVoCheckUtil.getAndCheckDict(importVo, importVo.getFeeBudgetTypeName(), "预算生成维度", TpmGlobalDictConstants.FEE_BUDGET_TYPE)) != null){
            UserRedis userRedis = UserUtils.getUser();
            importVo.setFeeBudgetType(code);
            mdmPropertyCheckHelper.checkOrg(importVo, userRedis.getOrgcode(), false);
            if(StringUtils.isNotBlank(importVo.getCustomerCode())){
                if(ImportVoCheckUtil.isNotNull(importVo, importVo.getOrgCode(), "组织编码")){
                    mdmPropertyCheckHelper.checkCustomer(importVo, importVo.getOrgCode(), false);
                }
            }
            if(StringUtils.isNotBlank(importVo.getTerminalCode())){
                if(ImportVoCheckUtil.isNotNull(importVo, importVo.getCustomerCode(), "客户编码")){
                    mdmPropertyCheckHelper.checkTerminal(importVo, false);
                }
            }

            if(FeeBudgetTypeEnum.CUSTOMER.getCode().equals(importVo.getFeeBudgetType())){
                if(importVo.getChannel() != null){
                    importVo.appendErrorValidateMsg("填写了渠道,但所填维度为客户;");
                }
                if(importVo.getTerminalCode() != null){
                    importVo.appendErrorValidateMsg("填写了门店,但所填维度为客户;");
                }
            }else if(FeeBudgetTypeEnum.TERMINAL.getCode().equals(importVo.getFeeBudgetType())){
                if(importVo.getChannel() != null){
                    importVo.appendErrorValidateMsg("填写了渠道,但所填维度为门店;");
                }
            }else if(FeeBudgetTypeEnum.CHANNEL.getCode().equals(importVo.getFeeBudgetType())){
                if(importVo.getCustomerCode() != null){
                    importVo.appendErrorValidateMsg("填写了客户,但所填维度为渠道;");
                }
                if(importVo.getTerminalCode() != null){
                    importVo.appendErrorValidateMsg("填写了门店,但所填维度为渠道;");
                }
            }
        }
    }




    private void checkIsExist(TpmBudgetGenerateRuleImportVo importVo, HashSet<String> unique){
        LambdaQueryWrapper<TpmBudgetGenerateRuleEntity> wrapper = Wrappers.lambdaQuery(TpmBudgetGenerateRuleEntity.class)
                .eq(TpmBudgetGenerateRuleEntity::getBudgetSubjectCode, importVo.getBudgetSubjectCode())
                .eq(TpmBudgetGenerateRuleEntity::getYear, importVo.getYear())
                .eq(TpmBudgetGenerateRuleEntity::getMonth, importVo.getMonth())
                .eq(TpmBudgetGenerateRuleEntity::getFeeBudgetType, importVo.getFeeBudgetType());
        if(importVo.getOrgCode() != null){
            wrapper.eq(TpmBudgetGenerateRuleEntity::getOrgCode, importVo.getOrgCode());
        }else {
            wrapper.isNull(TpmBudgetGenerateRuleEntity::getOrgCode);
        }
        if(importVo.getCustomerCode() != null){
            wrapper.eq(TpmBudgetGenerateRuleEntity::getCustomerCode, importVo.getOrgCode());
        }else {
            wrapper.isNull(TpmBudgetGenerateRuleEntity::getCustomerCode);
        }
        if(importVo.getTerminalCode() != null){
            wrapper.eq(TpmBudgetGenerateRuleEntity::getTerminalCode, importVo.getOrgCode());
        }else {
            wrapper.isNull(TpmBudgetGenerateRuleEntity::getTerminalCode);
        }
        if(importVo.getChannel() != null){
            wrapper.eq(TpmBudgetGenerateRuleEntity::getChannel, importVo.getChannel());
        }else {
            wrapper.isNull(TpmBudgetGenerateRuleEntity::getChannel);
        }
        int count = tpmBudgetGenerateRuleMapper.selectCount(wrapper);
        if(unique.contains(importVo.getUniqueKey()) || count > 0){
            importVo.appendErrorValidateMsg("已存在相同数据，不允许重复提交;");
        }
        unique.add(importVo.getUniqueKey());
    }
}
