package com.biz.crm.excel.component.validator.tpm.incomebudget;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.eunm.tpm.FeeBudgetTypeEnum;
import com.biz.crm.excel.component.helper.MdmPropertyCheckHelper;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.util.ImportVoCheckUtil;
import com.biz.crm.excel.vo.tpm.incomebudget.TpmIncomeBudgetImportVo;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.mdm.productlevel.MdmProductLevelFeign;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelSelectReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelSelectRespVo;
import com.biz.crm.tpm.incomebudget.mapper.TpmIncomeBudgetMapper;
import com.biz.crm.tpm.incomebudget.model.TpmIncomeBudgetEntity;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Maps;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

import static java.util.stream.Collectors.toMap;


/**
 * @author yb
 * @version 1.0
 * @date 2021/12/14 13:57
 * @description
 */
@Component("tpmIncomeBudgetValidator")
public class TpmIncomeBudgetValidator  <M extends BaseMapper<T>, T>  extends AbstractExcelImportValidator<TpmIncomeBudgetMapper, TpmIncomeBudgetEntity, TpmIncomeBudgetImportVo> implements ExcelImportValidator<TpmIncomeBudgetImportVo> {

    @Resource
    private MdmPropertyCheckHelper mdmPropertyCheckHelper;

    @Resource
    private TpmIncomeBudgetMapper tpmIncomeBudgetMapper;

    @Resource
    private MdmProductLevelFeign mdmProductLevelFeign;

    @Resource
    private MdmProductFeign productFeign;

    @Override
    public void validate(List<TpmIncomeBudgetImportVo> data, DefaultImportContext context) {
        data.forEach(importVo -> {
            importVo.setFeeBudgetType(ImportVoCheckUtil.getAndCheckDict(importVo, importVo.getFeeBudgetTypeName(), "预算分组", TpmGlobalDictConstants.FEE_BUDGET_TYPE));
            mdmPropertyCheckHelper.checkOrg(importVo, UserUtils.getUser().getOrgcode(), true);
            if(importVo.getProductLevelCode() != null){
                MdmProductLevelRespVo productLevelRespVo =ApiResultUtil.objResult(mdmProductLevelFeign.detail("",importVo.getProductLevelCode()));
                AssertUtils.isNotNull(productLevelRespVo,"不存在该产品层级");
                importVo.setProductLevelName(productLevelRespVo.getProductLevelName());
                //产品编码非必填,填了校验有效性
                if(importVo.getProductCode() != null) {
                    List<String> productLevelCodeList = Collections.singletonList(importVo.getProductLevelCode());
                    List<MdmProductRespVo> productRespVos = ApiResultUtil.objResult(productFeign.queryBatchByProductLevelCodeList(productLevelCodeList));
                    Map<String, MdmProductRespVo> productRespVoMap = productRespVos.stream()
                            .collect(toMap(MdmProductRespVo::getProductCode, Function.identity()));
                    if (!productRespVoMap.containsKey(importVo.getProductCode())) {
                        importVo.appendErrorValidateMsg("产品不属于所选层级");
                    }
                    importVo.setProductName(productRespVoMap.get(importVo.getProductCode()).getProductName());
                }
            }

            if(importVo.getFeeBudgetType() != null){
                if (FeeBudgetTypeEnum.CUSTOMER.getCode().equals(importVo.getFeeBudgetType())){
                    mdmPropertyCheckHelper.checkCustomer(importVo, importVo.getOrgCode(), true);
                    if(importVo.getTerminalCode() != null){
                        importVo.appendErrorValidateMsg("所选维度为客户,不应填写门店编码,请确认填写维度是否正确;");
                    }
                    if(importVo.getChannelName() != null){
                        importVo.appendErrorValidateMsg("所选维度为客户,不应填写渠道,请确认填写维度是否正确;");
                    }
                }else if(FeeBudgetTypeEnum.TERMINAL.getCode().equals(importVo.getFeeBudgetType())){
                    mdmPropertyCheckHelper.checkCustomer(importVo, importVo.getOrgCode(), true);
                    mdmPropertyCheckHelper.checkTerminal(importVo, true);
                }else if(FeeBudgetTypeEnum.CHANNEL.getCode().equals(importVo.getFeeBudgetType())) {
                    if(importVo.getCustomerCode() != null){
                        importVo.appendErrorValidateMsg("所选维度为渠道,不应填写客户编码,请确认填写维度是否正确;");
                    }
                    if(importVo.getTerminalCode() != null){
                        importVo.appendErrorValidateMsg("所选维度为渠道,不应填写门店编码,请确认填写维度是否正确;");
                    }
                    importVo.setChannel(ImportVoCheckUtil.getAndCheckDict(importVo, importVo.getChannelName(), "渠道", TpmGlobalDictConstants.CHANNEL));
                }
            }
            importVo.setBudgetYear(ImportVoCheckUtil.getAndCheckDict(importVo, importVo.getBudgetYear(), "年份", TpmGlobalDictConstants.FISCAL_YEAR));
            importVo.setBudgetMonth(ImportVoCheckUtil.getAndCheckDict(importVo, importVo.getBudgetMonth(), "月份", TpmGlobalDictConstants.FISCAL_MONTH));
            HashSet<String> unique = new HashSet<>();
            checkIsExist(importVo, unique);
        });
    }

    private void checkIsExist(TpmIncomeBudgetImportVo importVo, HashSet<String> unique){
        LambdaQueryWrapper<TpmIncomeBudgetEntity> queryWrapper = Wrappers.<TpmIncomeBudgetEntity>lambdaQuery();
        StringBuilder key = new StringBuilder();
        key.append(importVo.getBudgetYear()).append("-").append(importVo.getBudgetMonth());
        queryWrapper.eq(TpmIncomeBudgetEntity::getBudgetMonth,importVo.getBudgetMonth());
        queryWrapper.eq(TpmIncomeBudgetEntity::getBudgetYear,importVo.getBudgetYear());
        if (importVo.getProductLevelCode() != null){
            key.append("-").append(importVo.getProductLevelCode());
            queryWrapper.eq(TpmIncomeBudgetEntity::getProductLevelCode,importVo.getProductLevelCode());
        }else {
            queryWrapper.isNull(TpmIncomeBudgetEntity::getProductLevelCode);
        }
        if (importVo.getProductCode() != null){
            key.append("-").append(importVo.getProductCode());
            queryWrapper.eq(TpmIncomeBudgetEntity::getProductCode,importVo.getProductCode());
        }else {
            queryWrapper.isNull(TpmIncomeBudgetEntity::getProductCode);
        }
        key.append("-").append(importVo.getOrgCode());
        //分组 渠道
        if(importVo.getChannel() != null){
            key.append("-").append(importVo.getChannel());
            queryWrapper.eq(TpmIncomeBudgetEntity::getChannel,importVo.getChannel());
        }
        // 分组 组织
        queryWrapper.eq(TpmIncomeBudgetEntity::getOrgCode,importVo.getOrgCode());
        // 分组 客户
        if (importVo.getCustomerCode() != null){
            key.append("-").append(importVo.getCustomerCode());
            queryWrapper.eq(TpmIncomeBudgetEntity::getCustomerCode,importVo.getCustomerCode());
        }
        // 分组 门店
        if (importVo.getTerminalCode() != null){
            key.append("-").append(importVo.getTerminalCode());
            queryWrapper.eq(TpmIncomeBudgetEntity::getTerminalCode,importVo.getTerminalCode());
        }
        if (unique.contains(key.toString()) || tpmIncomeBudgetMapper.selectCount(queryWrapper) > 0){
            importVo.appendErrorValidateMsg("该年月已存在相同维度预算");
        }
        unique.add(key.toString());
    }
}
