package com.biz.crm.excel.component.validator.tpm.invoicecommon;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.eunm.tpm.InvoiceTypeEnum;
import com.biz.crm.excel.util.ImportVoCheckUtil;
import com.biz.crm.excel.vo.tpm.auditinvoice.TpmAuditInvoiceImportVo;
import com.biz.crm.excel.vo.tpm.invoice.TpmInvoiceImportVo;
import com.biz.crm.tpm.invoicepool.mapper.TpmInvoicePoolMapper;
import com.biz.crm.tpm.invoicepool.model.TpmInvoicePoolEntity;
import com.biz.crm.util.AssertUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;

/**
 * @author yb
 * @version 1.0
 * @date 2021/12/20 11:13
 * @description
 */
@Service
public class InvoiceCheckHelper {

    @Resource
    private TpmInvoicePoolMapper tpmInvoicePoolMapper;

    public void validateInvoice(TpmInvoiceImportVo o) {
        o.setInvoiceType(ImportVoCheckUtil.getAndCheckDict(o, o.getInvoiceTypeName(), "发票类型", TpmGlobalDictConstants.INVOICE_TYPE));
        if(o.getInvoiceType() != null){
            commonProperty(o);
            if(InvoiceTypeEnum.SPECIAL_VAT.getCode().equals(o.getInvoiceType())){
                ImportVoCheckUtil.checkNotNull(o, o.getPurchaserInfo(), "买方地址及电话信息");
                ImportVoCheckUtil.checkNotNull(o, o.getPurchaserAccount(), "买方账户");
                vatProperty(o);
            }else if(InvoiceTypeEnum.ORDINARY_VAT.getCode().equals(o.getInvoiceType())){
                vatProperty(o);
            }else if(InvoiceTypeEnum.STABLE.getCode().equals(o.getInvoiceType())){
                ImportVoCheckUtil.check(o, o.getInvoicingDate(), "开票时间", "定额发票");
                ImportVoCheckUtil.check(o, o.getCheckCode(), "校验码", "定额发票");
                ImportVoCheckUtil.check(o, o.getPurchaserName(), "买方名称", "定额发票");
                ImportVoCheckUtil.check(o, o.getPurchaserTaxpayerNumber(), "买方纳税人号码", "定额发票");
                ImportVoCheckUtil.check(o, o.getSellerName(), "卖方名称", "定额发票");
                ImportVoCheckUtil.check(o, o.getSellerTaxpayerNumber(), "卖方纳税人号码", "定额发票");
                ImportVoCheckUtil.check(o, o.getSellerInfo(), "卖方地址及电话信息", "定额发票");
                ImportVoCheckUtil.check(o, o.getSellerAccount(), "卖方账户", "定额发票");
                ImportVoCheckUtil.check(o, o.getAmount(), "金额", "定额发票");
                ImportVoCheckUtil.check(o, o.getTaxRate(), "税率", "定额发票");
            }else {
                o.appendErrorValidateMsg("未知发票类型");
            }
        }
    }

    public void validateInvoicePool(TpmInvoiceImportVo o, HashSet<String> unique){
        validateInvoice(o);
        checkIsExist(o, unique);
        o.setUsedAmount(o.getTotalAmount());
        o.setAvailableAmount(BigDecimal.ZERO);
    }

    public void validateAuditInvoice(TpmAuditInvoiceImportVo o, HashSet<String> unique){
        validateInvoice(o);
        ImportVoCheckUtil.checkValidAmount(o, o.getUseAmount(), "本次使用金额");
        TpmInvoicePoolEntity invoicePoolEntity = tpmInvoicePoolMapper  .selectOne(Wrappers.lambdaQuery(TpmInvoicePoolEntity.class)
                        .eq(TpmInvoicePoolEntity::getInvoiceNumber, o.getInvoiceNumber()));
        if(invoicePoolEntity != null){
            if(!o.getInvoiceType().equals(invoicePoolEntity.getInvoiceType())){
                o.appendErrorValidateMsg("发票池存在该号码发票,但发票类型与所填不同;");
            }
            o.setUsedAmount(invoicePoolEntity.getUsedAmount());
            o.setAvailableAmount(invoicePoolEntity.getAvailableAmount());
        }else {
            o.setUsedAmount(BigDecimal.ZERO);
            o.setAvailableAmount(o.getTotalAmount());
        }
        if(o.getUseAmount().compareTo(o.getAvailableAmount()) > 0){
            o.appendErrorValidateMsg("发票的本次使用金额大于发票所剩余额");
        }
        if(unique.contains(o.getInvoiceNumber())){
            o.appendErrorValidateMsg("已存在相同发票号码的发票,请勿重复上传");
        }
        unique.add(o.getInvoiceNumber());
    }

    private void vatProperty(TpmInvoiceImportVo o){
        ImportVoCheckUtil.checkNotNull(o, o.getInvoicingDate(), "开票时间");
        ImportVoCheckUtil.checkNotNull(o, o.getCheckCode(), "校验码");
        ImportVoCheckUtil.checkNotNull(o, o.getPurchaserName(), "买方名称");
        ImportVoCheckUtil.checkNotNull(o, o.getPurchaserTaxpayerNumber(), "买方纳税人号码");
        ImportVoCheckUtil.checkNotNull(o, o.getSellerName(), "卖方名称");
        ImportVoCheckUtil.checkNotNull(o, o.getSellerTaxpayerNumber(), "卖方纳税人号码");
        ImportVoCheckUtil.checkNotNull(o, o.getSellerInfo(), "卖方地址及电话信息");
        ImportVoCheckUtil.checkNotNull(o, o.getSellerAccount(), "卖方账户");
        ImportVoCheckUtil.checkValidAmount(o, o.getAmount(), "金额");
        ImportVoCheckUtil.checkValidAmount(o, o.getTaxRate(), "税率");
        if(o.getAmount() != null && o.getTaxRate() != null && o.getTotalAmount() != null){
            BigDecimal taxAmount = o.getTotalAmount().multiply(o.getTaxRate()).divide(new BigDecimal(100));
            o.setTaxAmount(taxAmount);
            BigDecimal totalAmount = o.getAmount().add(taxAmount);
            if(totalAmount.compareTo(o.getTotalAmount()) != 0){
                o.appendErrorValidateMsg("税价合计不等于所填的金额及税率计算之和");
            }
        }
    }

    private void commonProperty(TpmInvoiceImportVo o){
        ImportVoCheckUtil.checkNotNull(o, o.getInvoiceCode(), "发票编码");
        ImportVoCheckUtil.checkNotNull(o, o.getInvoiceNumber(), "发票编码");
        ImportVoCheckUtil.checkValidAmount(o, o.getTotalAmount(), "税价合计");
    }


    private void checkIsExist(TpmInvoiceImportVo o, HashSet<String> unique){
        if(unique.contains(o.getInvoiceNumber()) ||
                tpmInvoicePoolMapper
                        .selectOne(Wrappers.lambdaQuery(TpmInvoicePoolEntity.class)
                                .eq(TpmInvoicePoolEntity::getInvoiceNumber, o.getInvoiceNumber())) != null){
            o.appendErrorValidateMsg("已存在相同发票号码的发票,请勿重复上传");
        };
    }
}
