package com.biz.crm.excel.component.validator.tpm.invoicepool;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.component.validator.tpm.invoicecommon.InvoiceCheckHelper;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.tpm.invoice.TpmInvoiceImportVo;
import com.biz.crm.tpm.invoicepool.mapper.TpmInvoicePoolMapper;
import com.biz.crm.tpm.invoicepool.model.TpmInvoicePoolEntity;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.HashSet;
import java.util.List;

/**
 * @author yb
 * @version 1.0
 * @date 2021/12/10 14:01
 * @description
 */
@Component("tpmInvoicePoolImportValidator")
public class TpmInvoicePoolImportValidator<M extends BaseMapper<T>, T>  extends AbstractExcelImportValidator<TpmInvoicePoolMapper, TpmInvoicePoolEntity, TpmInvoiceImportVo> implements ExcelImportValidator <TpmInvoiceImportVo> {

    @Resource
    private InvoiceCheckHelper invoiceCheckHelper;

    @Override
    public void validate(List<TpmInvoiceImportVo> data, DefaultImportContext context) {
        HashSet<String> unique = new HashSet<>();
        data.forEach(o -> {
            invoiceCheckHelper.validateInvoicePool(o, unique);
        });
    }
}
