package com.biz.crm.excel.component.validator.tpm.salesplans;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.sfa.SfaAchievementRuleImportVo;
import com.biz.crm.excel.vo.tpm.FeeBudgetImportVo;
import com.biz.crm.excel.vo.tpm.salesplans.TpmSalesPlansImportVo;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.tpm.feebudget.mapper.TpmFeeBudgetMapper;
import com.biz.crm.tpm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.tpm.salesplans.mapper.TpmSalesPlansMapper;
import com.biz.crm.tpm.salesplans.model.TpmSalesPlansEntity;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.ProductLevelUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;

/**
 * @description: 销售计划导入验证
 * @author: rentao
 * @date: 2021/10/28 16:59
 */
@Slf4j
@Component("tpmsalesPlansImportValidator")
public class TpmsalesPlansImportValidator <M extends BaseMapper<T>, T> extends AbstractExcelImportValidator<TpmSalesPlansMapper, TpmSalesPlansEntity, TpmSalesPlansImportVo> implements ExcelImportValidator<TpmSalesPlansImportVo> {


  @Resource
  private MdmProductFeign productFeignign;

  @Resource
  private MdmCustomerMsgFeign customerFeign;

  @Resource
  private MdmOrgFeign orgFeign;

  @Override
  public void validate(List<TpmSalesPlansImportVo> data, DefaultImportContext context) {
    if(CollectionUtils.isEmpty(data)){
      return;
    }
    data.forEach(s->{
      StringBuilder msg = new StringBuilder();
      this.doCheckMouth(s,msg);
      this.doCheckSpType(s,msg);
      this.doCheckChannel(s,msg);
      this.doCheckProductLevel(s,msg);
      this.doCheckProduct(s,msg);
      this.doCheckOrg(s,msg);
      this.doCheckCustomer(s,msg);
      this.doCheckAmount(s,msg);
      if (StringUtils.isNotBlank(msg.toString())){
        this.errorMsgAndSendWebsocket(s,msg.toString(), context);
      }
    });
  }



  /**
   * 年月度，参数校验
   * @param v
   */
  public void doCheckMouth(TpmSalesPlansImportVo v, StringBuilder msg){
    if (!(StringUtils.isNumeric(v.getSpYear()) && StringUtils.isNumeric(v.getSpMonth()))){
      msg.append("绩效年月格式不正确；");
    }
    if (v.getSpYear().length() != 4){
      msg.append("绩效年份格式不正确；");
    }
    if (v.getSpMonth().length() == 1){
      v.setSpMonth(YesNoEnum.yesNoEnum.ZERO.getValue() + v.getSpMonth());
    }
    if (v.getSpMonth().length() != 2){
      msg.append("绩效月份格式不正确；");
    }
    int month = Integer.parseInt(v.getSpMonth());
    if (month > 12 || month < 0){
      msg.append("绩效月份格式不正确；");
    }
  }

  /**
   * 验证销售计划类型
   *
   * */
  public void doCheckSpType(TpmSalesPlansImportVo v, StringBuilder msg){
    if(StringUtils.isBlank(v.getSpType())){
      msg.append("销售计划类型为空；");
    }
    Map<String, String> map = DictUtil.dictRevertMap(DictConstant.SALES_PLAN_TYPE);
    if (!map.containsKey(v.getSpType())) {
      msg.append("销售计划类型不存在；");
    }else {
      v.setSpType(map.get(v.getSpType()));
    }
  }

  /**
   * 验证销售计划渠道
   *
   * */
  public void doCheckChannel(TpmSalesPlansImportVo v, StringBuilder msg){
    if(StringUtils.isBlank(v.getChannelName())){
      msg.append("销售计划渠道为空；");
    }
    Map<String, String> map = DictUtil.dictRevertMap(DictConstant.CHANNEL);
    if (!map.containsKey(v.getChannelName())) {
      msg.append("销售计划渠道不存在；");
    }else {
      v.setChannelCode(map.get(v.getSpType()));
    }
  }


  /**
   * 验证产品层级 和产品
   *
   * */
  public void doCheckProductLevel(TpmSalesPlansImportVo v, StringBuilder msg){
    if(StringUtils.isBlank(v.getProductLevelCode())){
      msg.append("产品层级编码为空；");
    }
    MdmProductLevelRespVo productLevelvo = ProductLevelUtil.getProductLevelByCode(v.getProductLevelCode());
    if(Objects.nonNull(productLevelvo)  && StringUtils.equals(CrmEnableStatusEnum.ENABLE.getCode(),productLevelvo.getEnableStatus())){
      v.setProductLevelName(productLevelvo.getProductLevelName());
    }else if(Objects.isNull(productLevelvo)){
      msg.append("产品层级不存在为空；");
    }else{
      msg.append("产品层级不是启用状态；");
    }
  }


  public void doCheckProduct(TpmSalesPlansImportVo v, StringBuilder msg){
    if(StringUtils.isNotEmpty(v.getProductLevelCode())){
      if(StringUtils.isNotEmpty(v.getProductCode())){
        MdmProductRespVo mdmProductRespVo = ApiResultUtil.objResult(productFeignign.detail(null, v.getProductCode()), true);
        if(Objects.nonNull(mdmProductRespVo) &&  StringUtils.equals(CrmEnableStatusEnum.ENABLE.getCode(),mdmProductRespVo.getEnableStatus())
            && StringUtils.equals(v.getProductLevelCode(),mdmProductRespVo.getProductLevelCode())){
          v.setProductName(mdmProductRespVo.getProductName());
        }else if(Objects.isNull(mdmProductRespVo)){
          msg.append("产品层级为空；");
        } else if(!StringUtils.equals(CrmEnableStatusEnum.ENABLE.getCode(),mdmProductRespVo.getEnableStatus())){
          msg.append("产品层级不是启用状态；");
        }else if(!StringUtils.equals(v.getProductLevelCode(),mdmProductRespVo.getProductLevelCode())){
          msg.append("产品层级和产品不存在关联关系；");
        }
      }else {
        v.setPositionName(null);
      }
    }
  }


  public void doCheckOrg(TpmSalesPlansImportVo v, StringBuilder msg){
    if(StringUtils.isNotEmpty(v.getOrgCode())){
      MdmOrgRespVo orgRespVo = orgFeign.detail(v.getOrgCode()).getResult();
      if(Objects.nonNull(orgRespVo) && StringUtils.equals(CrmEnableStatusEnum.ENABLE.getCode(),orgRespVo.getEnableStatus())){
         v.setOrgName(orgRespVo.getOrgName());
      }else if(Objects.isNull(orgRespVo)){
        msg.append("组织不存在；");
      }else {
        msg.append("组织尚未启用；");
      }
    }else {
      v.setOrgName(null);
    }
  }


  public void doCheckCustomer(TpmSalesPlansImportVo v, StringBuilder msg){
    if(StringUtils.isNotEmpty(v.getCustomerCode())){
      MdmCustomerMsgReqVo customerMsgReqVo = new MdmCustomerMsgReqVo();
      customerMsgReqVo.setCustomerCode(v.getCustomerCode());
      List<MdmCustomerMsgRespVo> customerMsgRespVos = customerFeign.list(customerMsgReqVo).getResult().getData();
      if(StringUtils.isBlank(v.getOrgCode())){
        if(CollectionUtils.isNotEmpty(customerMsgRespVos) && StringUtils.equals(CrmEnableStatusEnum.ENABLE.getCode(),customerMsgRespVos.get(0).getEnableStatus())){
          v.setCustomerName(customerMsgRespVos.get(0).getCustomerName());
        }else if(CollectionUtil.listEmpty(customerMsgRespVos)){
          msg.append("经销商不存在；");
        }else {
          msg.append("经销商尚未启用；");
        }
      }else {
        if(CollectionUtils.isNotEmpty(customerMsgRespVos) && StringUtils.equals(CrmEnableStatusEnum.ENABLE.getCode(),customerMsgRespVos.get(0).getEnableStatus())
            && StringUtils.equals(v.getOrgCode(),customerMsgRespVos.get(0).getOrgCode())
        ) {
          v.setCustomerName(customerMsgRespVos.get(0).getCustomerName());
        }else if(CollectionUtil.listEmpty(customerMsgRespVos)){
          msg.append("经销商不存在；");
        }else if(StringUtils.equals(CrmEnableStatusEnum.ENABLE.getCode(),customerMsgRespVos.get(0).getEnableStatus())) {
          msg.append("经销商尚未启用；");
        }else {
          msg.append("经销商组织与选取组织不一致；");
        }
      }
    }else {
     v.setCustomerName(null);
    }
  }


  public void doCheckAmount(TpmSalesPlansImportVo v, StringBuilder msg){
    if(Objects.isNull(v.getAmount())){
      msg.append("金额为空；");
    }else if (v.getAmount().compareTo(BigDecimal.ZERO) <= 0){
      msg.append("金额不能小于等于0；");
    }
  }

}

